/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.common.semantic.SemanticUtils;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DecompressingByteBufferObjectStrategy;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.LongsLongEncodingReader;
import org.apache.druid.segment.file.SegmentFileMapper;

public class BlockLayoutColumnarLongsSupplier
implements Supplier<ColumnarLongs> {
    private static final Map<Class<?>, Function<BlockLayoutColumnarLongs, ?>> AS_MAP = SemanticUtils.makeAsMap(BlockLayoutColumnarLongs.class);
    private final GenericIndexed<ResourceHolder<ByteBuffer>> baseLongBuffers;
    private final int totalSize;
    private final int sizePer;
    private final CompressionFactory.LongEncodingReader baseReader;
    private final CompressionStrategy strategy;

    public BlockLayoutColumnarLongsSupplier(int totalSize, int sizePer, ByteBuffer fromBuffer, ByteOrder order, CompressionFactory.LongEncodingReader reader, CompressionStrategy strategy, SegmentFileMapper fileMapper) {
        this.strategy = strategy;
        this.baseLongBuffers = GenericIndexed.read(fromBuffer, DecompressingByteBufferObjectStrategy.of(order, strategy), fileMapper);
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.baseReader = reader;
    }

    public ColumnarLongs get() {
        boolean isPowerOf2;
        final int div = Integer.numberOfTrailingZeros(this.sizePer);
        final int rem = this.sizePer - 1;
        boolean bl = isPowerOf2 = this.sizePer == 1 << div;
        if (isPowerOf2) {
            if (this.baseReader instanceof LongsLongEncodingReader) {
                return new BlockLayoutColumnarLongs(){

                    @Override
                    public long get(int index) {
                        int bufferNum = index >> div;
                        if (bufferNum != this.currBufferNum) {
                            this.loadBuffer(bufferNum);
                        }
                        int bufferIndex = index & rem;
                        return this.longBuffer.get(bufferIndex);
                    }

                    @Override
                    protected void loadBuffer(int bufferNum) {
                        if (this.holder != null) {
                            this.holder.close();
                        }
                        this.holder = (ResourceHolder)this.singleThreadedLongBuffers.get(bufferNum);
                        this.buffer = (ByteBuffer)this.holder.get();
                        this.longBuffer = this.buffer.asLongBuffer();
                        this.reader.setBuffer(this.buffer);
                        this.currBufferNum = bufferNum;
                    }
                };
            }
            return new BlockLayoutColumnarLongs(){

                @Override
                public long get(int index) {
                    int bufferNum = index >> div;
                    if (bufferNum != this.currBufferNum) {
                        this.loadBuffer(bufferNum);
                    }
                    int bufferIndex = index & rem;
                    return this.reader.read(bufferIndex);
                }
            };
        }
        return new BlockLayoutColumnarLongs();
    }

    public class BlockLayoutColumnarLongs
    implements ColumnarLongs {
        final CompressionFactory.LongEncodingReader reader;
        final Indexed<ResourceHolder<ByteBuffer>> singleThreadedLongBuffers;
        int currBufferNum;
        @Nullable
        ResourceHolder<ByteBuffer> holder;
        @Nullable
        ByteBuffer buffer;
        @Nullable
        LongBuffer longBuffer;

        public BlockLayoutColumnarLongs() {
            this.reader = BlockLayoutColumnarLongsSupplier.this.baseReader.duplicate();
            this.singleThreadedLongBuffers = BlockLayoutColumnarLongsSupplier.this.baseLongBuffers.singleThreaded();
            this.currBufferNum = -1;
        }

        public CompressionFactory.LongEncodingStrategy getEncodingStrategy() {
            return BlockLayoutColumnarLongsSupplier.this.baseReader.getStrategy();
        }

        public CompressionStrategy getCompressionStrategy() {
            return BlockLayoutColumnarLongsSupplier.this.strategy;
        }

        @Override
        public int size() {
            return BlockLayoutColumnarLongsSupplier.this.totalSize;
        }

        @Override
        public long get(int index) {
            int bufferNum = index / BlockLayoutColumnarLongsSupplier.this.sizePer;
            int bufferIndex = index % BlockLayoutColumnarLongsSupplier.this.sizePer;
            if (bufferNum != this.currBufferNum) {
                this.loadBuffer(bufferNum);
            }
            return this.reader.read(bufferIndex);
        }

        @Override
        public void get(long[] out, int start, int length) {
            this.get(out, 0, start, length);
        }

        @Override
        public void get(long[] out, int offset, int start, int length) {
            int bufferNum = start / BlockLayoutColumnarLongsSupplier.this.sizePer;
            int bufferIndex = start % BlockLayoutColumnarLongsSupplier.this.sizePer;
            int p = 0;
            while (p < length) {
                if (bufferNum != this.currBufferNum) {
                    this.loadBuffer(bufferNum);
                }
                int limit = Math.min(length - p, BlockLayoutColumnarLongsSupplier.this.sizePer - bufferIndex);
                this.reader.read(out, offset + p, bufferIndex, limit);
                p += limit;
                ++bufferNum;
                bufferIndex = 0;
            }
        }

        @Override
        public void get(long[] out, int[] indexes, int length) {
            int numRead;
            for (int p = 0; p < length; p += numRead) {
                int bufferNum = indexes[p] / BlockLayoutColumnarLongsSupplier.this.sizePer;
                if (bufferNum != this.currBufferNum) {
                    this.loadBuffer(bufferNum);
                }
                numRead = this.reader.read(out, p, indexes, length - p, bufferNum * BlockLayoutColumnarLongsSupplier.this.sizePer, BlockLayoutColumnarLongsSupplier.this.sizePer);
                assert (numRead > 0);
            }
        }

        protected void loadBuffer(int bufferNum) {
            if (this.holder != null) {
                this.holder.close();
            }
            this.holder = this.singleThreadedLongBuffers.get(bufferNum);
            this.buffer = this.holder.get();
            this.currBufferNum = bufferNum;
            this.reader.setBuffer(this.buffer);
        }

        @Override
        public void close() {
            if (this.holder != null) {
                this.currBufferNum = -1;
                this.holder.close();
                this.holder = null;
                this.buffer = null;
                this.longBuffer = null;
            }
        }

        @Override
        @Nullable
        public <T> T as(Class<? extends T> clazz) {
            return (T)AS_MAP.getOrDefault(clazz, arg -> null).apply(this);
        }

        public String toString() {
            return "BlockCompressedColumnarLongs_Anonymous{currBufferNum=" + this.currBufferNum + ", sizePer=" + BlockLayoutColumnarLongsSupplier.this.sizePer + ", numChunks=" + this.singleThreadedLongBuffers.size() + ", totalSize=" + BlockLayoutColumnarLongsSupplier.this.totalSize + "}";
        }
    }
}

