/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.file;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.file.SegmentFileChannel;
import org.apache.druid.segment.file.SegmentFileMetadata;
import org.apache.druid.segment.projections.ProjectionMetadata;

public class SegmentFileBuilderV10
implements SegmentFileBuilder {
    private final ObjectMapper jsonMapper;
    private final String outputFileName;
    private final File baseDir;
    private final long maxChunkSize;
    private final CompressionStrategy metadataCompression;
    private final FileSmoosher smoosher;
    private final Map<String, SegmentFileBuilderV10> externalSegmentFileBuilders;
    private final Map<String, ColumnDescriptor> columns = new TreeMap<String, ColumnDescriptor>();
    @Nullable
    private String interval = null;
    @Nullable
    private BitmapSerdeFactory bitmapEncoding = null;
    @Nullable
    private List<ProjectionMetadata> projections = null;

    public static SegmentFileBuilderV10 create(ObjectMapper jsonMapper, File baseDir) {
        return SegmentFileBuilderV10.create(jsonMapper, baseDir, CompressionStrategy.NONE);
    }

    public static SegmentFileBuilderV10 create(ObjectMapper jsonMapper, File baseDir, CompressionStrategy metaCompression) {
        return new SegmentFileBuilderV10(jsonMapper, "druid.segment", baseDir, Integer.MAX_VALUE, metaCompression);
    }

    private SegmentFileBuilderV10(ObjectMapper jsonMapper, String outputFileName, File baseDir, long maxChunkSize, CompressionStrategy metadataCompression) {
        this.jsonMapper = jsonMapper;
        this.outputFileName = outputFileName;
        this.baseDir = baseDir;
        this.maxChunkSize = maxChunkSize;
        this.metadataCompression = metadataCompression;
        this.smoosher = new FileSmoosher(baseDir, Ints.checkedCast((long)maxChunkSize), outputFileName);
        this.externalSegmentFileBuilders = new TreeMap<String, SegmentFileBuilderV10>();
    }

    @Override
    public void add(String name, File fileToAdd) throws IOException {
        this.smoosher.add(name, fileToAdd);
    }

    @Override
    public void add(String name, ByteBuffer bufferToAdd) throws IOException {
        this.smoosher.add(name, bufferToAdd);
    }

    @Override
    public SegmentFileChannel addWithChannel(String name, long size) throws IOException {
        return this.smoosher.addWithChannel(name, size);
    }

    @Override
    public SegmentFileBuilder getExternalBuilder(String externalFile) {
        return this.externalSegmentFileBuilders.computeIfAbsent(externalFile, k -> new SegmentFileBuilderV10(this.jsonMapper, externalFile, this.baseDir, this.maxChunkSize, this.metadataCompression));
    }

    @Override
    public void addColumn(String name, ColumnDescriptor columnDescriptor) {
        this.columns.put(name, columnDescriptor);
    }

    public void addInterval(String interval) {
        this.interval = interval;
    }

    public void addBitmapEncoding(BitmapSerdeFactory bitmapEncoding) {
        this.bitmapEncoding = bitmapEncoding;
    }

    public void addProjections(List<ProjectionMetadata> projections) {
        this.projections = projections;
    }

    @Override
    public void abort() {
        this.smoosher.abort();
    }

    @Override
    public void close() throws IOException {
        for (SegmentFileBuilderV10 externalBuilder : this.externalSegmentFileBuilders.values()) {
            externalBuilder.close();
        }
        this.smoosher.close();
        SegmentFileMetadata segmentFileMetadata = new SegmentFileMetadata(this.smoosher.getContainers(), this.smoosher.getInternalFiles(), this.interval, this.columns.isEmpty() ? null : this.columns, this.projections, this.bitmapEncoding);
        byte[] metadataBytes = this.jsonMapper.writeValueAsBytes((Object)segmentFileMetadata);
        try (Closer closer = Closer.create();){
            FileOutputStream outputStream = closer.register(new FileOutputStream(new File(this.baseDir, this.outputFileName)));
            FileChannel channel = closer.register(outputStream.getChannel());
            ByteBuffer intBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            outputStream.write(new byte[]{10, this.metadataCompression.getId()});
            intBuffer.putInt(metadataBytes.length);
            intBuffer.flip();
            outputStream.write(intBuffer.array());
            if (CompressionStrategy.NONE == this.metadataCompression) {
                outputStream.write(metadataBytes);
            } else {
                CompressionStrategy.Compressor compressor = this.metadataCompression.getCompressor();
                ByteBuffer inBuffer = compressor.allocateInBuffer(metadataBytes.length, closer).order(ByteOrder.nativeOrder());
                inBuffer.put(metadataBytes, 0, metadataBytes.length);
                inBuffer.flip();
                ByteBuffer outBuffer = compressor.allocateOutBuffer(metadataBytes.length, closer).order(ByteOrder.nativeOrder());
                ByteBuffer compressed = compressor.compress(inBuffer, outBuffer);
                intBuffer.position(0);
                intBuffer.putInt(compressed.remaining());
                intBuffer.flip();
                outputStream.write(intBuffer.array());
                Channels.writeFully(channel, compressed);
            }
            for (File f : this.smoosher.getOutFiles()) {
                try (FileInputStream fis = new FileInputStream(f);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                DruidException.conditionalDefensive(f.delete(), "Failed to delete temporary file[%s]", f);
            }
        }
    }
}

