/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import java.util.Arrays;

public enum InputRowFilterResult {
    ACCEPTED("accepted"),
    NULL_OR_EMPTY_RECORD("null"),
    BEFORE_MIN_MESSAGE_TIME("beforeMinimumMessageTime"),
    AFTER_MAX_MESSAGE_TIME("afterMaximumMessageTime"),
    CUSTOM_FILTER("filtered"),
    UNKNOWN("unknown");

    private static final InputRowFilterResult[] REJECTED_VALUES;
    private final String reason;

    private InputRowFilterResult(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isRejected() {
        return this != ACCEPTED;
    }

    public static InputRowFilterResult[] rejectedValues() {
        return REJECTED_VALUES;
    }

    public static int numValues() {
        return InputRowFilterResult.values().length;
    }

    static {
        REJECTED_VALUES = (InputRowFilterResult[])Arrays.stream(InputRowFilterResult.values()).filter(InputRowFilterResult::isRejected).toArray(InputRowFilterResult[]::new);
    }
}

