/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.segment.incremental.InputRowFilterResult;

public class RowIngestionMetersTotals {
    private final long processed;
    private final long processedBytes;
    private final long processedWithError;
    private final long thrownAway;
    private final Map<String, Long> thrownAwayByReason;
    private final long unparseable;

    @JsonCreator
    public RowIngestionMetersTotals(@JsonProperty(value="processed") long processed, @JsonProperty(value="processedBytes") long processedBytes, @JsonProperty(value="processedWithError") long processedWithError, @JsonProperty(value="thrownAway") long thrownAway, @JsonProperty(value="thrownAwayByReason") @Nullable Map<String, Long> thrownAwayByReason, @JsonProperty(value="unparseable") long unparseable) {
        this(processed, processedBytes, processedWithError, Configs.valueOrDefault(thrownAwayByReason, RowIngestionMetersTotals.getBackwardsCompatibleThrownAwayByReason(thrownAway)), unparseable);
    }

    public RowIngestionMetersTotals(long processed, long processedBytes, long processedWithError, long thrownAway, long unparseable) {
        this(processed, processedBytes, processedWithError, RowIngestionMetersTotals.getBackwardsCompatibleThrownAwayByReason(thrownAway), unparseable);
    }

    public RowIngestionMetersTotals(long processed, long processedBytes, long processedWithError, Map<String, Long> thrownAwayByReason, long unparseable) {
        this.processed = processed;
        this.processedBytes = processedBytes;
        this.processedWithError = processedWithError;
        this.thrownAway = thrownAwayByReason.values().stream().reduce(0L, Long::sum);
        this.thrownAwayByReason = thrownAwayByReason;
        this.unparseable = unparseable;
    }

    @JsonProperty
    public long getProcessed() {
        return this.processed;
    }

    @JsonProperty
    public long getProcessedBytes() {
        return this.processedBytes;
    }

    @JsonProperty
    public long getProcessedWithError() {
        return this.processedWithError;
    }

    @JsonProperty
    public long getThrownAway() {
        return this.thrownAway;
    }

    @JsonProperty
    public Map<String, Long> getThrownAwayByReason() {
        return this.thrownAwayByReason;
    }

    @JsonProperty
    public long getUnparseable() {
        return this.unparseable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowIngestionMetersTotals that = (RowIngestionMetersTotals)o;
        return this.processed == that.processed && this.processedBytes == that.processedBytes && this.processedWithError == that.processedWithError && this.thrownAway == that.thrownAway && this.thrownAwayByReason.equals(that.thrownAwayByReason) && this.unparseable == that.unparseable;
    }

    public int hashCode() {
        return Objects.hash(this.processed, this.processedBytes, this.processedWithError, this.thrownAway, this.thrownAwayByReason, this.unparseable);
    }

    public String toString() {
        return "RowIngestionMetersTotals{processed=" + this.processed + ", processedBytes=" + this.processedBytes + ", processedWithError=" + this.processedWithError + ", thrownAway=" + this.thrownAway + ", thrownAwayByReason=" + String.valueOf(this.thrownAwayByReason) + ", unparseable=" + this.unparseable + "}";
    }

    private static Map<String, Long> getBackwardsCompatibleThrownAwayByReason(long thrownAway) {
        HashMap<String, Long> results = new HashMap<String, Long>();
        if (thrownAway > 0L) {
            results.put(InputRowFilterResult.UNKNOWN.getReason(), thrownAway);
        }
        return results;
    }
}

