/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.column.BitmapIndexType;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.FixedIndexedIntWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.data.VSizeColumnarIntsSerializer;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.file.SegmentFileChannel;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.LocalDimensionDictionary;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class GlobalDictionaryEncodedFieldColumnWriter<T> {
    private static final Logger log = new Logger(GlobalDictionaryEncodedFieldColumnWriter.class);
    protected final SegmentWriteOutMedium segmentWriteOutMedium;
    protected final String columnName;
    protected final String fieldName;
    protected final NestedCommonFormatColumnFormatSpec columnFormatSpec;
    protected final DictionaryIdLookup globalDictionaryIdLookup;
    protected final LocalDimensionDictionary localDictionary = new LocalDimensionDictionary();
    public BitmapIndexType bitmapIndexType = BitmapIndexType.DictionaryEncodedValueIndex.INSTANCE;
    protected final Int2ObjectRBTreeMap<MutableBitmap> arrayElements = new Int2ObjectRBTreeMap();
    protected final Closer fieldResourceCloser = Closer.create();
    protected FixedIndexedIntWriter intermediateValueWriter;
    protected int flags = 0;
    protected DictionaryEncodedColumnPartSerde.VERSION version = null;
    protected SingleValueColumnarIntsSerializer encodedValueSerializer;
    protected int cursorPosition;

    protected GlobalDictionaryEncodedFieldColumnWriter(String columnName, String fieldName, SegmentWriteOutMedium segmentWriteOutMedium, NestedCommonFormatColumnFormatSpec columnFormatSpec, DictionaryIdLookup globalDictionaryIdLookup) {
        this.columnName = columnName;
        this.fieldName = fieldName;
        this.columnFormatSpec = columnFormatSpec;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.globalDictionaryIdLookup = globalDictionaryIdLookup;
    }

    T processValue(int row, Object value) {
        return (T)value;
    }

    void writeValue(@Nullable T value) throws IOException {
    }

    abstract int lookupGlobalId(T var1);

    public void open() throws IOException {
        this.intermediateValueWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, false);
        this.intermediateValueWriter.open();
        this.cursorPosition = 0;
    }

    public void addValue(int row, Object val) throws IOException {
        int localId;
        T value;
        if (row > this.cursorPosition) {
            this.fillNull(row);
        }
        if ((value = this.processValue(row, val)) == null) {
            localId = this.localDictionary.add(0);
        } else {
            int globalId = this.lookupGlobalId(value);
            Preconditions.checkArgument((globalId >= 0 ? 1 : 0) != 0, (String)"Value [%s] is not present in global dictionary", value);
            localId = this.localDictionary.add(globalId);
        }
        this.intermediateValueWriter.write(localId);
        ++this.cursorPosition;
    }

    private void fillNull(int row) throws IOException {
        int localId = this.localDictionary.add(0);
        while (this.cursorPosition < row) {
            this.intermediateValueWriter.write(localId);
            ++this.cursorPosition;
        }
    }

    long getSerializedColumnSize() throws IOException {
        return 8L + this.encodedValueSerializer.getSerializedSize();
    }

    void writeColumnTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        this.writeLongAndDoubleColumnLength(channel, 0, 0);
        this.encodedValueSerializer.writeTo(channel, fileBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(int finalRowCount, SegmentFileBuilder fileBuilder) throws IOException {
        if (finalRowCount > this.cursorPosition) {
            this.fillNull(finalRowCount);
        }
        SegmentWriteOutMedium tmpWriteoutMedium = this.segmentWriteOutMedium.makeChildWriteOutMedium();
        final FixedIndexedIntWriter sortedDictionaryWriter = new FixedIndexedIntWriter(tmpWriteoutMedium, true);
        sortedDictionaryWriter.open();
        final FixedIndexedIntWriter arrayElementDictionaryWriter = new FixedIndexedIntWriter(tmpWriteoutMedium, true);
        arrayElementDictionaryWriter.open();
        final BitmapIndexType.Writer bitmapIndexWriter = this.bitmapIndexType.getWriter();
        bitmapIndexWriter.openWriter(tmpWriteoutMedium, this.columnName, this.columnFormatSpec.getBitmapEncoding().getObjectStrategy());
        final GenericIndexedWriter<ImmutableBitmap> arrayElementIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(tmpWriteoutMedium, this.columnName, this.columnFormatSpec.getBitmapEncoding().getObjectStrategy());
        arrayElementIndexWriter.open();
        arrayElementIndexWriter.setObjectsNotSorted();
        Int2IntOpenHashMap globalToUnsorted = this.localDictionary.getGlobalIdToLocalId();
        int[] unsortedToGlobal = new int[this.localDictionary.size()];
        IntIterator intIterator = globalToUnsorted.keySet().iterator();
        while (intIterator.hasNext()) {
            int key;
            unsortedToGlobal[globalToUnsorted.get((int)key)] = key = ((Integer)intIterator.next()).intValue();
        }
        int[] sortedGlobal = new int[unsortedToGlobal.length];
        System.arraycopy(unsortedToGlobal, 0, sortedGlobal, 0, unsortedToGlobal.length);
        IntArrays.unstableSort((int[])sortedGlobal);
        int[] unsortedToSorted = new int[unsortedToGlobal.length];
        int index = 0;
        while (index < sortedGlobal.length) {
            int globalId = sortedGlobal[index];
            sortedDictionaryWriter.write(globalId);
            int unsortedId = globalToUnsorted.get(globalId);
            unsortedToSorted[unsortedId] = index++;
        }
        for (Int2ObjectMap.Entry arrayElement : this.arrayElements.int2ObjectEntrySet()) {
            arrayElementDictionaryWriter.write(arrayElement.getIntKey());
            arrayElementIndexWriter.write(this.columnFormatSpec.getBitmapEncoding().getBitmapFactory().makeImmutableBitmap((MutableBitmap)arrayElement.getValue()));
        }
        this.openColumnSerializer(tmpWriteoutMedium, sortedGlobal[sortedGlobal.length - 1]);
        bitmapIndexWriter.init(this.columnFormatSpec.getBitmapEncoding().getBitmapFactory(), sortedGlobal.length);
        IntIterator rows = this.intermediateValueWriter.getIterator();
        int rowCount = 0;
        while (rows.hasNext()) {
            int unsortedLocalId = rows.nextInt();
            int sortedLocalId = unsortedToSorted[unsortedLocalId];
            this.encodedValueSerializer.addValue(sortedLocalId);
            Object value = this.globalDictionaryIdLookup.getDictionaryValue(unsortedToGlobal[unsortedLocalId]);
            this.writeValue(value);
            bitmapIndexWriter.add(rowCount, sortedLocalId, value);
            ++rowCount;
        }
        bitmapIndexWriter.finalizeWriter(this.columnFormatSpec.getBitmapEncoding().getBitmapFactory());
        Serializer fieldSerializer = new Serializer(){

            @Override
            public long getSerializedSize() throws IOException {
                long arraySize = GlobalDictionaryEncodedFieldColumnWriter.this.arrayElements.size() > 0 ? arrayElementDictionaryWriter.getSerializedSize() + arrayElementIndexWriter.getSerializedSize() : 0L;
                return 5L + sortedDictionaryWriter.getSerializedSize() + GlobalDictionaryEncodedFieldColumnWriter.this.getSerializedColumnSize() + bitmapIndexWriter.getSerializedSize() + arraySize;
            }

            @Override
            public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
                Channels.writeFully(channel, ByteBuffer.wrap(new byte[]{GlobalDictionaryEncodedFieldColumnWriter.this.version.asByte()}));
                Channels.writeFully(channel, ByteBuffer.wrap(Ints.toByteArray((int)GlobalDictionaryEncodedFieldColumnWriter.this.flags)));
                sortedDictionaryWriter.writeTo(channel, fileBuilder);
                GlobalDictionaryEncodedFieldColumnWriter.this.writeColumnTo(channel, fileBuilder);
                bitmapIndexWriter.writeTo(channel, fileBuilder);
                if (GlobalDictionaryEncodedFieldColumnWriter.this.arrayElements.size() > 0) {
                    arrayElementDictionaryWriter.writeTo(channel, fileBuilder);
                    arrayElementIndexWriter.writeTo(channel, fileBuilder);
                }
            }
        };
        String fieldFileName = ColumnSerializerUtils.getInternalFileName(this.columnName, this.fieldName);
        long size = fieldSerializer.getSerializedSize();
        log.debug("Column [%s] serializing [%s] field of size [%d].", this.columnName, this.fieldName, size);
        try (SegmentFileChannel channel = fileBuilder.addWithChannel(fieldFileName, size);){
            fieldSerializer.writeTo(channel, fileBuilder);
        }
        finally {
            tmpWriteoutMedium.close();
            this.fieldResourceCloser.close();
        }
    }

    public void openColumnSerializer(SegmentWriteOutMedium medium, int maxId) throws IOException {
        if (this.columnFormatSpec.getDictionaryEncodedColumnCompression() != CompressionStrategy.UNCOMPRESSED) {
            this.version = DictionaryEncodedColumnPartSerde.VERSION.COMPRESSED;
            this.encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.fieldName, medium, this.columnName, maxId, this.columnFormatSpec.getDictionaryEncodedColumnCompression(), this.fieldResourceCloser);
        } else {
            this.encodedValueSerializer = new VSizeColumnarIntsSerializer(medium, maxId);
            this.version = DictionaryEncodedColumnPartSerde.VERSION.UNCOMPRESSED_SINGLE_VALUE;
        }
        this.encodedValueSerializer.open();
    }

    public void writeLongAndDoubleColumnLength(WritableByteChannel channel, int longLength, int doubleLength) throws IOException {
        ByteBuffer intBuffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        intBuffer.position(0);
        intBuffer.putInt(longLength);
        intBuffer.flip();
        Channels.writeFully(channel, intBuffer);
        intBuffer.position(0);
        intBuffer.limit(intBuffer.capacity());
        intBuffer.putInt(doubleLength);
        intBuffer.flip();
        Channels.writeFully(channel, intBuffer);
    }
}

