/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.GlobalDictionaryEncodedFieldColumnWriter;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public final class ScalarDoubleFieldColumnWriter
extends GlobalDictionaryEncodedFieldColumnWriter<Double> {
    private ColumnarDoublesSerializer doublesSerializer;

    public ScalarDoubleFieldColumnWriter(String columnName, String fieldName, SegmentWriteOutMedium segmentWriteOutMedium, NestedCommonFormatColumnFormatSpec columnFormatSpec, DictionaryIdLookup globalDictionaryIdLookup) {
        super(columnName, fieldName, segmentWriteOutMedium, columnFormatSpec, globalDictionaryIdLookup);
        this.bitmapIndexType = columnFormatSpec.getDoubleFieldBitmapIndexType();
    }

    @Override
    int lookupGlobalId(Double value) {
        return this.globalDictionaryIdLookup.lookupDouble(value);
    }

    @Override
    void writeValue(@Nullable Double value) throws IOException {
        if (value == null) {
            this.doublesSerializer.add(0.0);
        } else {
            this.doublesSerializer.add(value);
        }
    }

    @Override
    public void openColumnSerializer(SegmentWriteOutMedium medium, int maxId) throws IOException {
        super.openColumnSerializer(medium, maxId);
        this.doublesSerializer = CompressionFactory.getDoubleSerializer(this.fieldName, medium, StringUtils.format("%s.double_column", this.fieldName), ByteOrder.nativeOrder(), this.columnFormatSpec.getDoubleColumnCompression(), this.fieldResourceCloser);
        this.doublesSerializer.open();
    }

    @Override
    void writeColumnTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        this.writeLongAndDoubleColumnLength(channel, 0, Ints.checkedCast((long)this.doublesSerializer.getSerializedSize()));
        this.doublesSerializer.writeTo(channel, fileBuilder);
        this.encodedValueSerializer.writeTo(channel, fileBuilder);
    }

    @Override
    long getSerializedColumnSize() throws IOException {
        return 8L + this.doublesSerializer.getSerializedSize() + this.encodedValueSerializer.getSerializedSize();
    }
}

