/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.segment.nested.NestedPathArrayElement;
import org.apache.druid.segment.nested.NestedPathField;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.nested.StructuredData;

public class StructuredDataBuilder {
    private final List<Element> elements;

    StructuredDataBuilder(Element ... elements) {
        this(List.of(elements));
    }

    StructuredDataBuilder(List<Element> elements) {
        this.elements = elements;
    }

    StructuredDataBuilder(List<List<NestedPathPart>> parts, List<Object> objects) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < parts.size(); ++i) {
            elements.add(Element.of(parts.get(i), objects.get(i)));
        }
        this.elements = elements;
    }

    public StructuredData build() {
        Object subtree = this.buildObject();
        return StructuredData.wrap(subtree == null ? Map.of() : subtree);
    }

    @Nullable
    private Object buildObject() {
        Object simpleObject = null;
        LinkedListMultimap map = LinkedListMultimap.create();
        ArrayList list = new ArrayList();
        for (Element element : this.elements) {
            if (element.getValue() == null) continue;
            if (element.endOfPath()) {
                simpleObject = element.getValue();
                continue;
            }
            NestedPathPart nestedPathPart = element.getCurrentPath();
            if (nestedPathPart instanceof NestedPathField) {
                map.put((Object)((NestedPathField)nestedPathPart).getField(), (Object)element.next());
                continue;
            }
            if (!(nestedPathPart instanceof NestedPathArrayElement)) continue;
            int index = ((NestedPathArrayElement)nestedPathPart).getIndex();
            while (list.size() <= index) {
                list.add(new ArrayList());
            }
            ((List)list.get(index)).add(element.next());
        }
        if (simpleObject != null) {
            if (!map.isEmpty() || !list.isEmpty()) {
                throw DruidException.defensive("Error building structured data from paths[%s], cannot have map or array elements when root value is set", this.elements);
            }
            return simpleObject;
        }
        if (!map.isEmpty()) {
            if (!list.isEmpty()) {
                throw DruidException.defensive("Error building structured data from paths[%s], cannot have both map and array elements at the same level", this.elements);
            }
            return Maps.transformValues((Map)map.asMap(), mapElements -> new StructuredDataBuilder(new ArrayList<Element>((Collection<Element>)mapElements)).buildObject());
        }
        if (!list.isEmpty()) {
            ArrayList<Object> resultList = new ArrayList<Object>(list.size());
            for (List list2 : list) {
                resultList.add(new StructuredDataBuilder(list2).buildObject());
            }
            return resultList;
        }
        return null;
    }

    public static class Element {
        final List<NestedPathPart> path;
        @Nullable
        final Object value;
        final int depth;

        Element(List<NestedPathPart> path, Object value, int depth) {
            this.path = path;
            this.value = value;
            this.depth = depth;
        }

        static Element of(List<NestedPathPart> path, Object value) {
            return new Element(path, value, 0);
        }

        @Nullable
        Object getValue() {
            return this.value;
        }

        NestedPathPart getCurrentPath() {
            return this.path.get(this.depth);
        }

        boolean endOfPath() {
            return this.path.size() == this.depth;
        }

        Element next() {
            return new Element(this.path, this.value, this.depth + 1);
        }

        public String toString() {
            return "Element{path=" + String.valueOf(this.path) + ", value=" + String.valueOf(this.value) + ", depth=" + this.depth + "}";
        }
    }
}

