/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ConstantExprEvalSelector;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.ConstantVectorSelectors;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;

public class ConstantTimeColumn
implements NumericColumn {
    private final int numRows;
    private final long constant;

    public static Supplier<BaseColumnHolder> makeConstantTimeSupplier(int numRows, long constant) {
        return Suppliers.memoize(() -> new ColumnBuilder().setNumericColumnSupplier((Supplier<? extends NumericColumn>)((Supplier)() -> new ConstantTimeColumn(numRows, constant))).setColumnFormat(new CapabilitiesBasedFormat(ColumnCapabilitiesImpl.createDefault().setType(ColumnType.LONG))).setType(ColumnType.LONG).setHasNulls(false).build());
    }

    public ConstantTimeColumn(int numRows, long constant) {
        this.numRows = numRows;
        this.constant = constant;
    }

    @Override
    public int length() {
        return this.numRows;
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        return this.constant;
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
        return new ConstantExprEvalSelector(ExprEval.ofLong(this.constant));
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        return ConstantVectorSelectors.vectorValueSelector(offset, this.constant);
    }
}

