/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import com.google.common.collect.RangeSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.projections.AggregateProjectionSchema;
import org.apache.druid.segment.projections.ProjectionFilterMatch;
import org.apache.druid.segment.projections.ProjectionMatch;
import org.apache.druid.segment.projections.ProjectionMatchBuilder;
import org.apache.druid.segment.projections.ProjectionSchema;
import org.apache.druid.segment.projections.QueryableProjection;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class Projections {
    public static final String BASE_TABLE_PROJECTION_NAME = "__base";
    private static final ConcurrentHashMap<byte[], Boolean> PERIOD_GRAN_CACHE = new ConcurrentHashMap();

    @Nullable
    public static <T> QueryableProjection<T> findMatchingProjection(CursorBuildSpec cursorBuildSpec, SortedSet<AggregateProjectionMetadata> projections, Interval dataInterval, PhysicalColumnChecker physicalChecker, Function<String, T> getRowSelector) {
        if (cursorBuildSpec.getQueryContext().getBoolean("noProjections", false)) {
            return null;
        }
        String name = cursorBuildSpec.getQueryContext().getString("useProjection");
        if (cursorBuildSpec.isAggregate()) {
            for (AggregateProjectionMetadata spec : projections) {
                ProjectionMatch match;
                if (name != null && !name.equals(spec.getSchema().getName()) || (match = Projections.matchAggregateProjection(spec.getSchema(), cursorBuildSpec, dataInterval, physicalChecker)) == null) continue;
                if (cursorBuildSpec.getQueryMetrics() != null) {
                    cursorBuildSpec.getQueryMetrics().projection(spec.getSchema().getName());
                }
                return new QueryableProjection<T>(match.getCursorBuildSpec(), match.getRemapColumns(), getRowSelector.apply(spec.getSchema().getName()));
            }
        }
        if (name != null) {
            throw InvalidInput.exception("Projection[%s] specified, but does not satisfy query", name);
        }
        if (cursorBuildSpec.getQueryContext().getBoolean("forceProjections", false)) {
            throw InvalidInput.exception("Force projections specified, but none satisfy query", new Object[0]);
        }
        return null;
    }

    @Nullable
    public static ProjectionMatch matchAggregateProjection(AggregateProjectionSchema projection, CursorBuildSpec queryCursorBuildSpec, Interval dataInterval, PhysicalColumnChecker physicalColumnChecker) {
        if (!queryCursorBuildSpec.isCompatibleOrdering(projection.getOrderingWithTimeColumnSubstitution())) {
            return null;
        }
        if (CollectionUtils.isNullOrEmpty(queryCursorBuildSpec.getPhysicalColumns())) {
            return null;
        }
        if (Projections.isUnalignedInterval(projection, queryCursorBuildSpec, dataInterval)) {
            return null;
        }
        ProjectionMatchBuilder matchBuilder = new ProjectionMatchBuilder();
        if ((matchBuilder = Projections.matchQueryVirtualColumns(projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder)) == null) {
            return null;
        }
        if ((matchBuilder = Projections.matchFilter(projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder)) == null) {
            return null;
        }
        if ((matchBuilder = Projections.matchGrouping(projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder)) == null) {
            return null;
        }
        if ((matchBuilder = Projections.matchAggregators(projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder)) == null) {
            return null;
        }
        return matchBuilder.build(queryCursorBuildSpec);
    }

    @Nullable
    public static ProjectionMatchBuilder matchQueryVirtualColumns(AggregateProjectionSchema projection, CursorBuildSpec queryCursorBuildSpec, PhysicalColumnChecker physicalColumnChecker, ProjectionMatchBuilder matchBuilder) {
        for (VirtualColumn vc : queryCursorBuildSpec.getVirtualColumns().getVirtualColumns()) {
            if ((matchBuilder = Projections.matchQueryVirtualColumn(vc, projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder)) != null) continue;
            return null;
        }
        return matchBuilder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static ProjectionMatchBuilder matchFilter(AggregateProjectionSchema projection, CursorBuildSpec queryCursorBuildSpec, PhysicalColumnChecker physicalColumnChecker, ProjectionMatchBuilder matchBuilder) {
        if (projection.getFilter() != null) {
            Filter remappedQueryFilter;
            Filter queryFilter = queryCursorBuildSpec.getFilter();
            if (queryFilter == null) return null;
            Set<String> originalRequired = queryFilter.getRequiredColumns();
            Filter projectionFilter = projection.getFilter().toOptimizedFilter(false);
            Filter rewritten = ProjectionFilterMatch.rewriteFilter(projectionFilter, remappedQueryFilter = Projections.remapFilterToProjection(matchBuilder, queryFilter));
            if (rewritten == null) {
                return null;
            }
            if (rewritten == ProjectionFilterMatch.INSTANCE) {
                matchBuilder.rewriteFilter(null);
            } else {
                matchBuilder.rewriteFilter(rewritten);
            }
        } else {
            matchBuilder.rewriteFilter(queryCursorBuildSpec.getFilter());
        }
        if (matchBuilder.getRewriteFilter() == null) return matchBuilder;
        for (String queryColumn : matchBuilder.getRewriteFilter().getRequiredColumns()) {
            matchBuilder = Projections.matchRequiredColumn(queryColumn, projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder);
            if (matchBuilder != null) continue;
            return null;
        }
        return matchBuilder;
    }

    @Nullable
    public static ProjectionMatchBuilder matchGrouping(AggregateProjectionSchema projection, CursorBuildSpec queryCursorBuildSpec, PhysicalColumnChecker physicalColumnChecker, ProjectionMatchBuilder matchBuilder) {
        List<String> queryGrouping = queryCursorBuildSpec.getGroupingColumns();
        if (queryGrouping != null) {
            for (String queryColumn : queryGrouping) {
                matchBuilder = Projections.matchRequiredColumn(queryColumn, projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder);
                if (matchBuilder == null) {
                    return null;
                }
                if (projection.isInvalidGrouping(queryColumn)) {
                    return null;
                }
                if (!projection.isInvalidGrouping(matchBuilder.getRemapValue(queryColumn))) continue;
                return null;
            }
        }
        return matchBuilder;
    }

    @Nullable
    public static ProjectionMatchBuilder matchAggregators(AggregateProjectionSchema projection, CursorBuildSpec queryCursorBuildSpec, PhysicalColumnChecker physicalColumnChecker, ProjectionMatchBuilder matchBuilder) {
        if (CollectionUtils.isNullOrEmpty(queryCursorBuildSpec.getAggregators())) {
            return matchBuilder;
        }
        boolean allMatch = true;
        for (AggregatorFactory queryAgg : queryCursorBuildSpec.getAggregators()) {
            AggregatorFactory filterAgg = null;
            if (queryAgg instanceof FilteredAggregatorFactory) {
                filterAgg = ((FilteredAggregatorFactory)queryAgg).getAggregator();
            }
            boolean foundMatch = false;
            for (AggregatorFactory projectionAgg : projection.getAggregators()) {
                AggregatorFactory filteredCombining;
                AggregatorFactory combining = queryAgg.substituteCombiningFactory(projectionAgg);
                if (combining != null) {
                    matchBuilder.remapColumn(queryAgg.getName(), projectionAgg.getName()).addReferencedPhysicalColumn(projectionAgg.getName()).addPreAggregatedAggregator(combining);
                    foundMatch = true;
                    break;
                }
                if (filterAgg == null || (filteredCombining = filterAgg.substituteCombiningFactory(projectionAgg)) == null) continue;
                FilteredAggregatorFactory filteredQueryAgg = (FilteredAggregatorFactory)queryAgg;
                Filter aggFilter = filteredQueryAgg.getFilter().toFilter();
                Filter remappedAggFilter = Projections.remapFilterToProjection(matchBuilder, aggFilter);
                for (String column : aggFilter.getRequiredColumns()) {
                    matchBuilder = Projections.matchRequiredColumn(column, projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder);
                    if (matchBuilder != null) continue;
                    return null;
                }
                FilteredAggregatorFactory remappedFilteredAgg = new FilteredAggregatorFactory(filteredCombining, new RewrittenAggDimFilter(filteredQueryAgg.getFilter(), remappedAggFilter));
                matchBuilder.remapColumn(queryAgg.getName(), projectionAgg.getName()).addReferencedPhysicalColumn(projectionAgg.getName()).addPreAggregatedAggregator(remappedFilteredAgg);
                foundMatch = true;
                break;
            }
            allMatch = allMatch && foundMatch;
        }
        if (allMatch) {
            return matchBuilder;
        }
        return null;
    }

    @Nullable
    public static ProjectionMatchBuilder matchRequiredColumn(String column, AggregateProjectionSchema projection, CursorBuildSpec queryCursorBuildSpec, PhysicalColumnChecker physicalColumnChecker, ProjectionMatchBuilder matchBuilder) {
        VirtualColumn virtualColumn = queryCursorBuildSpec.getVirtualColumns().getVirtualColumn(column);
        if (virtualColumn != null) {
            return Projections.matchQueryVirtualColumn(virtualColumn, projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder);
        }
        return Projections.matchQueryPhysicalColumn(column, projection, physicalColumnChecker, matchBuilder);
    }

    @Nullable
    public static ProjectionMatchBuilder matchQueryVirtualColumn(VirtualColumn queryVirtualColumn, AggregateProjectionSchema projection, CursorBuildSpec queryCursorBuildSpec, PhysicalColumnChecker physicalColumnChecker, ProjectionMatchBuilder matchBuilder) {
        VirtualColumn projectionEquivalent = projection.getVirtualColumns().findEquivalent(queryVirtualColumn);
        if (projectionEquivalent != null) {
            String remapColumnName = Objects.equals(projectionEquivalent.getOutputName(), projection.getTimeColumnName()) ? "__time" : projectionEquivalent.getOutputName();
            if (!queryVirtualColumn.getOutputName().equals(remapColumnName)) {
                matchBuilder.remapColumn(queryVirtualColumn.getOutputName(), remapColumnName);
            }
            return matchBuilder.addReferencedPhysicalColumn(remapColumnName);
        }
        matchBuilder.addReferenceedVirtualColumn(queryVirtualColumn);
        List<String> requiredInputs = queryVirtualColumn.requiredColumns();
        if (requiredInputs.size() == 1 && "__time".equals(requiredInputs.get(0))) {
            Granularity virtualGranularity = Granularities.fromVirtualColumn(queryVirtualColumn);
            if (virtualGranularity != null) {
                if (projection.getEffectiveGranularity().equals(virtualGranularity)) {
                    return matchBuilder.remapColumn(queryVirtualColumn.getOutputName(), "__time").addReferencedPhysicalColumn("__time");
                }
                if (Granularities.ALL.equals(virtualGranularity) || Granularities.NONE.equals(projection.getEffectiveGranularity())) {
                    return matchBuilder.addReferencedPhysicalColumn("__time");
                }
                if (virtualGranularity instanceof PeriodGranularity && projection.getEffectiveGranularity() instanceof PeriodGranularity) {
                    PeriodGranularity virtualGran = (PeriodGranularity)virtualGranularity;
                    PeriodGranularity projectionGran = (PeriodGranularity)projection.getEffectiveGranularity();
                    byte[] combinedKey = new CacheKeyBuilder(0).appendCacheable(projectionGran).appendCacheable(virtualGran).build();
                    if (PERIOD_GRAN_CACHE.computeIfAbsent(combinedKey, unused -> projectionGran.canBeMappedTo(virtualGran)).booleanValue()) {
                        return matchBuilder.addReferencedPhysicalColumn("__time");
                    }
                }
                return null;
            }
            if (Granularities.NONE.equals(projection.getEffectiveGranularity())) {
                return matchBuilder.addReferencedPhysicalColumn("__time");
            }
            return null;
        }
        for (String required : requiredInputs) {
            matchBuilder = Projections.matchRequiredColumn(required, projection, queryCursorBuildSpec, physicalColumnChecker, matchBuilder);
            if (matchBuilder != null) continue;
            return null;
        }
        return matchBuilder;
    }

    @Nullable
    public static ProjectionMatchBuilder matchQueryPhysicalColumn(String column, AggregateProjectionSchema projection, PhysicalColumnChecker physicalColumnChecker, ProjectionMatchBuilder matchBuilder) {
        if ("__time".equals(column)) {
            if ("__time".equals(projection.getTimeColumnName())) {
                return matchBuilder.addReferencedPhysicalColumn("__time");
            }
            return null;
        }
        if (physicalColumnChecker.check(projection.getName(), column)) {
            return matchBuilder.addReferencedPhysicalColumn(column);
        }
        return null;
    }

    public static String getProjectionSmooshV9FileName(AggregateProjectionMetadata projectionSpec, String columnName) {
        return Projections.getProjectionSmooshV9Prefix(projectionSpec) + columnName;
    }

    public static String getProjectionSmooshV9Prefix(AggregateProjectionMetadata projectionSpec) {
        return projectionSpec.getSchema().getName() + "/";
    }

    public static String getProjectionSmooshFileName(ProjectionSchema schema, String columnName) {
        return Projections.getProjectionSmooshPrefix(schema) + columnName;
    }

    public static String getProjectionSmooshPrefix(ProjectionSchema projectionSchema) {
        return projectionSchema.getName() + "/";
    }

    private static boolean isUnalignedInterval(AggregateProjectionSchema projection, CursorBuildSpec queryCursorBuildSpec, Interval dataInterval) {
        Interval queryInterval = queryCursorBuildSpec.getInterval();
        if (!queryInterval.contains((ReadableInterval)dataInterval)) {
            Granularity granularity = projection.getEffectiveGranularity();
            DateTime start = queryInterval.getStart();
            DateTime end = queryInterval.getEnd();
            return !start.equals((Object)granularity.bucketStart(start)) || !end.equals((Object)granularity.bucketStart(end));
        }
        return false;
    }

    private static Filter remapFilterToProjection(ProjectionMatchBuilder matchBuilder, Filter aggFilter) {
        HashMap<String, String> filterRewrites = new HashMap<String, String>();
        for (String required : aggFilter.getRequiredColumns()) {
            filterRewrites.put(required, required);
        }
        filterRewrites.putAll(matchBuilder.getRemapColumns());
        Filter remappedAggFilter = aggFilter.rewriteRequiredColumns(filterRewrites);
        return remappedAggFilter;
    }

    private Projections() {
    }

    @FunctionalInterface
    public static interface PhysicalColumnChecker {
        public boolean check(String var1, String var2);
    }

    private static final class RewrittenAggDimFilter
    implements DimFilter {
        private final DimFilter originalFilter;
        private final Filter rewrittenFilter;

        private RewrittenAggDimFilter(DimFilter originalFilter, Filter rewrittenFilter) {
            this.originalFilter = originalFilter;
            this.rewrittenFilter = rewrittenFilter;
        }

        @Override
        public DimFilter optimize(boolean mayIncludeUnknown) {
            return this;
        }

        @Override
        public Filter toOptimizedFilter(boolean mayIncludeUnknown) {
            return this.rewrittenFilter;
        }

        @Override
        public Filter toFilter() {
            return this.rewrittenFilter;
        }

        @Override
        @Nullable
        public RangeSet<String> getDimensionRangeSet(String dimension) {
            return null;
        }

        @Override
        public Set<String> getRequiredColumns() {
            return this.rewrittenFilter.getRequiredColumns();
        }

        @Override
        @Nullable
        public byte[] getCacheKey() {
            return this.originalFilter.getCacheKey();
        }
    }
}

