/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadWriter;
import org.apache.druid.segment.serde.cell.LongSerializer;

public class CellIndexWriter
implements Serializer,
Closeable {
    private final LongSerializer longSerializer = new LongSerializer();
    private final BlockCompressedPayloadWriter payloadWriter;
    private long position = 0L;
    private boolean open = true;

    public CellIndexWriter(BlockCompressedPayloadWriter payloadWriter) {
        this.payloadWriter = payloadWriter;
    }

    public void persistAndIncrement(int increment) throws IOException {
        Preconditions.checkArgument((increment >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.open, (Object)"cannot write to closed CellIndex");
        this.payloadWriter.write(this.longSerializer.serialize(this.position));
        this.position += (long)increment;
    }

    @Override
    public void close() throws IOException {
        if (this.open) {
            this.payloadWriter.write(this.longSerializer.serialize(this.position));
            this.payloadWriter.close();
            this.open = false;
        }
    }

    @Override
    public void writeTo(WritableByteChannel channel, @Nullable SegmentFileBuilder fileBuilder) throws IOException {
        Preconditions.checkState((!this.open ? 1 : 0) != 0, (Object)"cannot transfer a CellIndex that is not closed and finalized");
        this.payloadWriter.writeTo(channel, fileBuilder);
    }

    @Override
    public long getSerializedSize() {
        return this.payloadWriter.getSerializedSize();
    }
}

