/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;

public final class CloseableUtils {
    public static Closer forIterable(Iterable<? extends Closeable> closeables) {
        Closer retVal = Closer.create();
        for (Closeable closeable : closeables) {
            retVal.register(closeable);
        }
        return retVal;
    }

    public static void closeAll(Closeable first, Closeable ... others) throws IOException {
        ArrayList<Closeable> closeables = new ArrayList<Closeable>(others.length + 1);
        closeables.add(first);
        closeables.addAll(Arrays.asList(others));
        CloseableUtils.closeAll(closeables);
    }

    public static <T extends Closeable> void closeAll(Iterable<T> closeables) throws IOException {
        Closer closer = Closer.create();
        closer.registerAll(Lists.reverse((List)Lists.newArrayList(closeables)));
        closer.close();
    }

    public static <E extends Throwable> RuntimeException closeInCatch(E caught, @Nullable Closeable closeable) throws E {
        if (caught == null) {
            IllegalStateException e1 = new IllegalStateException("Must be called with non-null caught exception");
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Throwable e2) {
                    e1.addSuppressed(e2);
                }
            }
            throw e1;
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                caught.addSuppressed(e);
            }
        }
        throw caught;
    }

    public static <E extends Throwable> RuntimeException closeAndWrapInCatch(E caught, @Nullable Closeable closeable) {
        try {
            throw CloseableUtils.closeInCatch(caught, closeable);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeAndWrapExceptions(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeAndSuppressExceptions(@Nullable Closeable closeable, Consumer<Throwable> chomper) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable e) {
            chomper.accept(e);
        }
    }

    private CloseableUtils() {
    }
}

