/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal.signer;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.HmacSHA256Signature;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.internal.SignV2Utils;
import com.aliyun.oss.internal.signer.OSSSignerBase;
import com.aliyun.oss.internal.signer.OSSSignerParams;
import java.util.Set;

public class OSSV2Signer
extends OSSSignerBase {
    protected OSSV2Signer(OSSSignerParams signerParams) {
        super(signerParams);
    }

    @Override
    protected void addAuthorizationHeader(RequestMessage request) {
        Credentials cred = this.signerParams.getCredentials();
        String accessKeyId = cred.getAccessKeyId();
        String secretAccessKey = cred.getSecretAccessKey();
        String signature = SignV2Utils.buildSignature(secretAccessKey, request.getMethod().toString(), this.signerParams.getResourcePath(), request);
        request.addHeader("Authorization", SignV2Utils.composeRequestAuthorization(accessKeyId, signature, request));
    }

    @Override
    public void presign(RequestMessage request) throws ClientException {
        Credentials cred = this.signerParams.getCredentials();
        String accessKeyId = cred.getAccessKeyId();
        String secretAccessKey = cred.getSecretAccessKey();
        String expires = String.valueOf(this.signerParams.getExpiration().getTime() / 1000L);
        String canonicalResource = this.signerParams.getResourcePath();
        if (cred.useSecurityToken()) {
            request.addParameter("security-token", cred.getSecurityToken());
        }
        request.addHeader("Date", expires);
        request.addParameter("x-oss-signature-version", "OSS2");
        request.addParameter("x-oss-expires", expires);
        request.addParameter("x-oss-access-key-id", accessKeyId);
        String additionalHeaderNameStr = SignV2Utils.buildSortedAdditionalHeaderNameStr(request.getHeaders().keySet(), this.signerParams.getAdditionalHeaderNames());
        if (!additionalHeaderNameStr.isEmpty()) {
            request.addParameter("x-oss-additional-headers", additionalHeaderNameStr);
        }
        Set<String> rawAdditionalHeaderNames = SignV2Utils.buildRawAdditionalHeaderNames(request.getHeaders().keySet(), this.signerParams.getAdditionalHeaderNames());
        String canonicalString = SignV2Utils.buildCanonicalString(request.getMethod().toString(), canonicalResource, request, rawAdditionalHeaderNames);
        String signature = new HmacSHA256Signature().computeSignature(secretAccessKey, canonicalString);
        request.addParameter("x-oss-signature", signature);
    }
}

