/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.utils;

import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogUtils {
    public static final String REQUEST = "{request}";
    public static final String RESPONSE = "{response}";
    public static final String TS = "{ts}";
    public static final String DATE_ISO_8601 = "{date_iso_8601}";
    public static final String DATE_COMMON_LOG = "{date_common_log}";
    public static final String HOST = "{host}";
    public static final String METHOD = "{method}";
    public static final String URI = "{uri}";
    public static final String VERSION = "{version}";
    public static final String TARGET = "{target}";
    public static final String HOSTNAME = "{hostname}";
    public static final String CODE = "{code}";
    public static final String PHRASE = "{phrase}";
    public static final String REQ_HEADERS = "{req_headers}";
    public static final String RES_HEADERS = "{res_headers}";
    public static final String REQ_BODY = "{req_body}";
    public static final String RES_BODY = "{res_body}";
    public static final String PID = "{pid}";
    public static final String COST = "{cost}";
    public static final String START_TIME = "{start_time}";
    public static final String TIME = "{time}";
    public static final String ERROR = "{error}";
    public static final String DEFAULT_LOG_FORMAT = "{method} {uri} HTTP/{version} {code} {cost} {hostname} {pid} {error}";
    public static final Pattern REQ_HEADER_PATTERN = Pattern.compile("\\{req_header_(.*?)\\}");
    public static final Pattern RES_HEADER_PATTERN = Pattern.compile("\\{res_header_(.*?)\\}");

    public static String fillContent(String format, LogUnit logUnit) {
        String headerKey;
        String content = format.replace(REQUEST, logUnit.getHttpRequest().toString()).replace(TS, logUnit.getTs()).replace(DATE_ISO_8601, logUnit.getTs()).replace(DATE_COMMON_LOG, logUnit.getTs()).replace(HOST, logUnit.getHost()).replace(METHOD, logUnit.getMethod()).replace(URI, logUnit.getUrl()).replace(VERSION, logUnit.getVersion()).replace(TARGET, logUnit.getTarget()).replace(HOSTNAME, logUnit.getHostname()).replace(ERROR, logUnit.getError()).replace(REQ_HEADERS, logUnit.getReqHeaders()).replace(RES_HEADERS, logUnit.getResHeaders()).replace(REQ_BODY, logUnit.getReqBody()).replace(PID, logUnit.getPid()).replace(COST, logUnit.getCost()).replace(START_TIME, logUnit.getStartTime()).replace(TIME, logUnit.getTime());
        if (null != logUnit.getHttpResponse()) {
            content = content.replace(RESPONSE, logUnit.getHttpResponse().toString()).replace(RES_BODY, logUnit.getResBody()).replace(PHRASE, logUnit.getPhrase()).replace(CODE, logUnit.getCode());
        }
        Matcher m3 = REQ_HEADER_PATTERN.matcher(content);
        while (m3.find()) {
            headerKey = m3.group(1);
            if (null == logUnit.getHttpRequest().getHeaderValue(headerKey)) continue;
            content = content.replace(m3.group(), logUnit.getHttpRequest().getHeaderValue(headerKey));
        }
        m3 = RES_HEADER_PATTERN.matcher(content);
        while (m3.find()) {
            headerKey = m3.group(1);
            if (null == logUnit.getHttpResponse().getHeaderValue(headerKey)) continue;
            content = content.replace(m3.group(), logUnit.getHttpResponse().getHeaderValue(headerKey));
        }
        return content;
    }

    public static String utcNow() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    public static String localeNow() {
        TimeZone tz = TimeZone.getDefault();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    public static long getCurrentPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "unknown host name";
        }
    }

    public static LogUnit createLogUnit(HttpRequest httpRequest, HttpResponse httpResponse) {
        return new LogUnit(httpRequest, httpResponse);
    }

    public static class LogUnit {
        private HttpRequest httpRequest;
        private HttpResponse httpResponse;
        private String ts;
        private String host;
        private String method;
        private String url;
        private String version = "1.1";
        private String target;
        private String hostname;
        private String code;
        private String phrase;
        private String reqHeaders;
        private String resHeaders;
        private String reqBody;
        private String resBody;
        private String pid;
        private String cost;
        private String startTime;
        private String time;
        private String error;

        public LogUnit(HttpRequest httpRequest, HttpResponse httpResponse) {
            this.httpRequest = httpRequest;
            this.httpResponse = httpResponse;
            this.ts = LogUtils.utcNow();
            try {
                URL url = new URL(httpRequest.getSysUrl());
                this.host = url.getHost();
                this.target = "";
                String path = url.getPath();
                String query = url.getQuery();
                String ref = url.getRef();
                if (null != path) {
                    this.target = this.target + path;
                }
                if (null != query) {
                    this.target = this.target + "?" + query;
                }
                if (null != ref) {
                    this.target = this.target + "#" + ref;
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            this.method = httpRequest.getSysMethod().name();
            this.url = httpRequest.getSysUrl();
            this.hostname = LogUtils.getLocalHostName();
            this.reqHeaders = httpRequest.getSysHeaders().toString();
            try {
                this.reqBody = httpRequest.getHttpContentString();
                if (null != httpResponse) {
                    this.resHeaders = httpResponse.getSysHeaders().toString();
                    this.code = String.valueOf(httpResponse.getStatus());
                    this.phrase = httpResponse.getReasonPhrase() != null ? httpResponse.getReasonPhrase() : "";
                    this.resBody = httpResponse.getHttpContentString();
                }
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
            this.pid = String.valueOf(LogUtils.getCurrentPID());
            this.time = LogUtils.localeNow();
        }

        public HttpRequest getHttpRequest() {
            return this.httpRequest;
        }

        public HttpResponse getHttpResponse() {
            return this.httpResponse;
        }

        public String getTs() {
            return this.ts;
        }

        public String getHost() {
            return this.host;
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getTarget() {
            return this.target;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getCode() {
            return this.code;
        }

        public String getPhrase() {
            return this.phrase;
        }

        public String getReqHeaders() {
            return this.reqHeaders;
        }

        public String getResHeaders() {
            return this.resHeaders;
        }

        public String getReqBody() {
            return this.reqBody;
        }

        public String getResBody() {
            return this.resBody;
        }

        public String getPid() {
            return this.pid;
        }

        public String getCost() {
            return this.cost;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public String getTime() {
            return this.time;
        }

        public String getError() {
            return this.error;
        }

        public void setHttpRequest(HttpRequest httpRequest) {
            this.httpRequest = httpRequest;
        }

        public void setHttpResponse(HttpResponse httpResponse) {
            this.httpResponse = httpResponse;
        }

        public void setTs(String ts) {
            this.ts = ts;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setPhrase(String phrase) {
            this.phrase = phrase;
        }

        public void setReqHeaders(String reqHeaders) {
            this.reqHeaders = reqHeaders;
        }

        public void setResHeaders(String resHeaders) {
            this.resHeaders = resHeaders;
        }

        public void setReqBody(String reqBody) {
            this.reqBody = reqBody;
        }

        public void setResBody(String resBody) {
            this.resBody = resBody;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public void setCost(String cost) {
            this.cost = cost;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}

