/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.ProcessTableFunction;
import org.apache.flink.table.runtime.operators.process.ReadableInternalTimeContext;
import org.apache.flink.table.runtime.operators.process.TimeConverter;
import org.apache.flink.util.Preconditions;

@Internal
class ExternalTimeContext<TimeConversion>
implements ProcessTableFunction.TimeContext<TimeConversion> {
    private final ReadableInternalTimeContext internalTimeContext;
    private final TimeConverter<TimeConversion> timeConverter;

    ExternalTimeContext(ReadableInternalTimeContext internalTimeContext, TimeConverter<TimeConversion> timeConverter) {
        this.internalTimeContext = internalTimeContext;
        this.timeConverter = timeConverter;
    }

    public TimeConversion time() {
        Long internal = this.internalTimeContext.time();
        if (internal == null) {
            return null;
        }
        return this.timeConverter.toExternal(internal);
    }

    public TimeConversion currentWatermark() {
        Long internal = this.internalTimeContext.currentWatermark();
        if (internal == null) {
            return null;
        }
        return this.timeConverter.toExternal(internal);
    }

    public void registerOnTime(String name, TimeConversion time) {
        Preconditions.checkNotNull((Object)name, (String)"Name must not be null.");
        Preconditions.checkNotNull(time, (String)"Time must not be null.");
        this.internalTimeContext.registerOnTime(name, this.timeConverter.toInternal(time));
    }

    public void registerOnTime(TimeConversion time) {
        Preconditions.checkNotNull(time, (String)"Time must not be null.");
        this.internalTimeContext.registerOnTime(this.timeConverter.toInternal(time));
    }

    public void clearTimer(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Name must not be null.");
        this.internalTimeContext.clearTimer(name);
    }

    public void clearTimer(TimeConversion time) {
        Preconditions.checkNotNull(time, (String)"Time must not be null.");
        this.internalTimeContext.clearTimer(this.timeConverter.toInternal(time));
    }

    public void clearAllTimers() {
        this.internalTimeContext.clearAllTimers();
    }
}

