/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.legacy.api.TableColumn;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.api.WatermarkSpec;
import org.apache.flink.table.legacy.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class TableSchemaUtils {
    public static TableSchema getPhysicalSchema(TableSchema tableSchema) {
        return TableSchemaUtils.getTableSchema(tableSchema, TableColumn::isPhysical);
    }

    public static TableSchema getPersistedSchema(TableSchema tableSchema) {
        return TableSchemaUtils.getTableSchema(tableSchema, TableColumn::isPersisted);
    }

    private static TableSchema getTableSchema(TableSchema tableSchema, Function<TableColumn, Boolean> columnFilter) {
        Preconditions.checkNotNull((Object)tableSchema);
        TableSchema.Builder builder = new TableSchema.Builder();
        tableSchema.getTableColumns().forEach(tableColumn -> {
            if (((Boolean)columnFilter.apply((TableColumn)tableColumn)).booleanValue()) {
                builder.field(tableColumn.getName(), tableColumn.getType());
            }
        });
        tableSchema.getPrimaryKey().ifPresent(uniqueConstraint -> builder.primaryKey(uniqueConstraint.getName(), uniqueConstraint.getColumns().toArray(new String[0])));
        return builder.build();
    }

    public static boolean containsPhysicalColumnsOnly(TableSchema schema) {
        Preconditions.checkNotNull((Object)schema);
        return schema.getTableColumns().stream().allMatch(TableColumn::isPhysical);
    }

    public static TableSchema checkOnlyPhysicalColumns(TableSchema schema) {
        Preconditions.checkNotNull((Object)schema);
        if (!TableSchemaUtils.containsPhysicalColumnsOnly(schema)) {
            throw new ValidationException("The given schema contains non-physical columns, schema: \n" + schema.toString());
        }
        return schema;
    }

    public static int[] getPrimaryKeyIndices(TableSchema schema) {
        if (schema.getPrimaryKey().isPresent()) {
            List<String> fieldNames = DataTypeUtils.flattenToNames(schema.toPhysicalRowDataType());
            return schema.getPrimaryKey().get().getColumns().stream().mapToInt(fieldNames::indexOf).toArray();
        }
        return new int[0];
    }

    public static ResolvedSchema removeTimeAttributeFromResolvedSchema(ResolvedSchema resolvedSchema) {
        return new ResolvedSchema(resolvedSchema.getColumns().stream().map(col -> col.copy(DataTypeUtils.removeTimeAttribute(col.getDataType()))).collect(Collectors.toList()), resolvedSchema.getWatermarkSpecs(), resolvedSchema.getPrimaryKey().orElse(null), resolvedSchema.getIndexes());
    }

    public static TableSchema.Builder builderWithGivenSchema(TableSchema oriSchema) {
        TableSchema.Builder builder = TableSchemaUtils.builderWithGivenColumns(oriSchema.getTableColumns());
        for (WatermarkSpec wms : oriSchema.getWatermarkSpecs()) {
            builder.watermark(wms.getRowtimeAttribute(), wms.getWatermarkExpr(), wms.getWatermarkExprOutputType());
        }
        oriSchema.getPrimaryKey().map(pk -> builder.primaryKey(pk.getName(), pk.getColumns().toArray(new String[0])));
        return builder;
    }

    public static TableSchema dropConstraint(TableSchema oriSchema, String constraintName) {
        Optional<UniqueConstraint> uniqueConstraintOpt = oriSchema.getPrimaryKey();
        if (!uniqueConstraintOpt.isPresent() || !uniqueConstraintOpt.get().getName().equals(constraintName)) {
            throw new ValidationException(String.format("Constraint %s to drop does not exist", constraintName));
        }
        TableSchema.Builder builder = TableSchemaUtils.builderWithGivenColumns(oriSchema.getTableColumns());
        for (WatermarkSpec wms : oriSchema.getWatermarkSpecs()) {
            builder.watermark(wms.getRowtimeAttribute(), wms.getWatermarkExpr(), wms.getWatermarkExprOutputType());
        }
        return builder.build();
    }

    private static TableSchema.Builder builderWithGivenColumns(List<TableColumn> originalColumns) {
        TableSchema.Builder builder = TableSchema.builder();
        for (TableColumn column : originalColumns) {
            builder.add(column);
        }
        return builder;
    }
}

