/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NotificationChannelDescriptorName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/notificationChannelDescriptors/{channel_descriptor}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String channelDescriptor;

    public String getProject() {
        return this.project;
    }

    public String getChannelDescriptor() {
        return this.channelDescriptor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private NotificationChannelDescriptorName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.channelDescriptor = Preconditions.checkNotNull(builder.getChannelDescriptor());
    }

    public static NotificationChannelDescriptorName of(String project, String channelDescriptor) {
        return NotificationChannelDescriptorName.newBuilder().setProject(project).setChannelDescriptor(channelDescriptor).build();
    }

    public static String format(String project, String channelDescriptor) {
        return NotificationChannelDescriptorName.newBuilder().setProject(project).setChannelDescriptor(channelDescriptor).build().toString();
    }

    public static NotificationChannelDescriptorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "NotificationChannelDescriptorName.parse: formattedString not in valid format");
        return NotificationChannelDescriptorName.of(matchMap.get("project"), matchMap.get("channel_descriptor"));
    }

    public static List<NotificationChannelDescriptorName> parseList(List<String> formattedStrings) {
        ArrayList<NotificationChannelDescriptorName> list = new ArrayList<NotificationChannelDescriptorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NotificationChannelDescriptorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NotificationChannelDescriptorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NotificationChannelDescriptorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NotificationChannelDescriptorName notificationChannelDescriptorName = this;
            synchronized (notificationChannelDescriptorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put("project", this.project);
                    fieldMapBuilder.put("channelDescriptor", this.channelDescriptor);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate("project", this.project, "channel_descriptor", this.channelDescriptor);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NotificationChannelDescriptorName) {
            NotificationChannelDescriptorName that = (NotificationChannelDescriptorName)o;
            return this.project.equals(that.project) && this.channelDescriptor.equals(that.channelDescriptor);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.project.hashCode();
        h2 *= 1000003;
        return h2 ^= this.channelDescriptor.hashCode();
    }

    public static class Builder {
        private String project;
        private String channelDescriptor;

        public String getProject() {
            return this.project;
        }

        public String getChannelDescriptor() {
            return this.channelDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setChannelDescriptor(String channelDescriptor) {
            this.channelDescriptor = channelDescriptor;
            return this;
        }

        private Builder() {
        }

        private Builder(NotificationChannelDescriptorName notificationChannelDescriptorName) {
            this.project = notificationChannelDescriptorName.project;
            this.channelDescriptor = notificationChannelDescriptorName.channelDescriptor;
        }

        public NotificationChannelDescriptorName build() {
            return new NotificationChannelDescriptorName(this);
        }
    }
}

