/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableMatch;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.TableFunctionCallImplementor;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BinaryExpression;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.CatchBlock;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.runtime.SpatialTypeFunctions;
import org.apache.calcite.schema.FunctionContext;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWindowTableFunction;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.base.CaseFormat;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.locationtech.jts.geom.Geometry;

public class RexToLixTranslator
implements RexVisitor<Result> {
    public static final Map<Method, SqlOperator> JAVA_TO_SQL_METHOD_MAP = ImmutableMap.builder().put(RexToLixTranslator.findMethod(String.class, "toUpperCase", new Class[0]), SqlStdOperatorTable.UPPER).put(BuiltInMethod.SUBSTRING.method, SqlStdOperatorTable.SUBSTRING).put(BuiltInMethod.OCTET_LENGTH.method, SqlStdOperatorTable.OCTET_LENGTH).put(BuiltInMethod.CHAR_LENGTH.method, SqlStdOperatorTable.CHAR_LENGTH).put(BuiltInMethod.TRANSLATE3.method, SqlLibraryOperators.TRANSLATE3).build();
    final JavaTypeFactory typeFactory;
    final RexBuilder builder;
    private final @Nullable RexProgram program;
    final SqlConformance conformance;
    private final Expression root;
    final @Nullable InputGetter inputGetter;
    private final BlockBuilder list;
    private final @Nullable BlockBuilder staticList;
    private final @Nullable Function1<String, InputGetter> correlates;
    private final Map<Expression, Expression> literalMap = new HashMap<Expression, Expression>();
    private final Map<RexCall, List<Result>> callOperandResultMap = new HashMap<RexCall, List<Result>>();
    private final Map<Pair<RexNode, @Nullable Type>, Result> rexWithStorageTypeResultMap = new HashMap<Pair<RexNode, Type>, Result>();
    private final Map<RexNode, Result> rexResultMap = new HashMap<RexNode, Result>();
    private @Nullable Type currentStorageType;

    private static Method findMethod(Class<?> clazz, String name, Class ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private RexToLixTranslator(@Nullable RexProgram program, JavaTypeFactory typeFactory, Expression root, @Nullable InputGetter inputGetter, BlockBuilder list, @Nullable BlockBuilder staticList, RexBuilder builder, SqlConformance conformance, @Nullable Function1<String, InputGetter> correlates) {
        this.program = program;
        this.typeFactory = Objects.requireNonNull(typeFactory, "typeFactory");
        this.conformance = Objects.requireNonNull(conformance, "conformance");
        this.root = Objects.requireNonNull(root, "root");
        this.inputGetter = inputGetter;
        this.list = Objects.requireNonNull(list, "list");
        this.staticList = staticList;
        this.builder = Objects.requireNonNull(builder, "builder");
        this.correlates = correlates;
    }

    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, SqlConformance conformance, BlockBuilder list, @Nullable BlockBuilder staticList, @Nullable PhysType outputPhysType, Expression root, InputGetter inputGetter, @Nullable Function1<String, InputGetter> correlates) {
        ArrayList<Type> storageTypes = null;
        if (outputPhysType != null) {
            RelDataType rowType = outputPhysType.getRowType();
            storageTypes = new ArrayList<Type>(rowType.getFieldCount());
            for (int i = 0; i < rowType.getFieldCount(); ++i) {
                storageTypes.add(outputPhysType.getJavaFieldType(i));
            }
        }
        return new RexToLixTranslator(program, typeFactory, root, inputGetter, list, staticList, new RexBuilder(typeFactory), conformance, null).setCorrelates(correlates).translateList(program.getProjectList(), storageTypes);
    }

    @Deprecated
    public static List<Expression> translateProjects(RexProgram program, JavaTypeFactory typeFactory, SqlConformance conformance, BlockBuilder list, @Nullable PhysType outputPhysType, Expression root, InputGetter inputGetter, @Nullable Function1<String, InputGetter> correlates) {
        return RexToLixTranslator.translateProjects(program, typeFactory, conformance, list, null, outputPhysType, root, inputGetter, correlates);
    }

    public static Expression translateTableFunction(JavaTypeFactory typeFactory, SqlConformance conformance, BlockBuilder list, Expression root, RexCall rexCall, Expression inputEnumerable, PhysType inputPhysType, PhysType outputPhysType) {
        RexToLixTranslator translator = new RexToLixTranslator(null, typeFactory, root, null, list, null, new RexBuilder(typeFactory), conformance, null);
        return translator.translateTableFunction(rexCall, inputEnumerable, inputPhysType, outputPhysType);
    }

    public static RexToLixTranslator forAggregation(JavaTypeFactory typeFactory, BlockBuilder list, @Nullable InputGetter inputGetter, SqlConformance conformance) {
        ParameterExpression root = DataContext.ROOT;
        return new RexToLixTranslator(null, typeFactory, root, inputGetter, list, null, new RexBuilder(typeFactory), conformance, null);
    }

    Expression translate(RexNode expr) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs) {
        return this.translate(expr, nullAs, null);
    }

    Expression translate(RexNode expr, @Nullable Type storageType) {
        RexImpTable.NullAs nullAs = RexImpTable.NullAs.of(this.isNullable(expr));
        return this.translate(expr, nullAs, storageType);
    }

    Expression translate(RexNode expr, RexImpTable.NullAs nullAs, @Nullable Type storageType) {
        this.currentStorageType = storageType;
        Result result = expr.accept(this);
        Expression translated = Objects.requireNonNull(EnumUtils.toInternal(result.valueVariable, storageType));
        if (RexImpTable.NullAs.NOT_POSSIBLE == nullAs && translated.type.equals(storageType)) {
            return translated;
        }
        return nullAs.handle(translated);
    }

    Expression translateCast(RelDataType sourceType, RelDataType targetType, Expression operand) {
        Expression convert = null;
        block0 : switch (targetType.getSqlTypeName()) {
            case ANY: {
                convert = operand;
                break;
            }
            case GEOMETRY: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call(BuiltInMethod.ST_GEOM_FROM_EWKT.method, operand);
                        break block0;
                    }
                }
                break;
            }
            case DATE: {
                convert = this.translateCastToDate(sourceType, operand);
                break;
            }
            case TIME: {
                convert = this.translateCastToTime(sourceType, operand);
                break;
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call(BuiltInMethod.STRING_TO_TIME_WITH_LOCAL_TIME_ZONE.method, operand);
                        break block0;
                    }
                    case TIME: {
                        convert = Expressions.call(BuiltInMethod.TIME_STRING_TO_TIME_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIME_TO_STRING.method, operand)), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break block0;
                    }
                    case TIMESTAMP: {
                        convert = Expressions.call(BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, operand)), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break block0;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME_WITH_LOCAL_TIME_ZONE.method, operand));
                        break block0;
                    }
                }
                break;
            }
            case TIMESTAMP: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call(BuiltInMethod.STRING_TO_TIMESTAMP.method, operand);
                        break block0;
                    }
                    case DATE: {
                        convert = Expressions.multiply(Expressions.convert_(operand, Long.TYPE), Expressions.constant(86400000L));
                        break block0;
                    }
                    case TIME: {
                        convert = Expressions.add(Expressions.multiply(Expressions.convert_(Expressions.call(BuiltInMethod.CURRENT_DATE.method, this.root), Long.TYPE), Expressions.constant(86400000L)), Expressions.convert_(operand, Long.TYPE));
                        break block0;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, Expressions.call(BuiltInMethod.UNIX_DATE_TO_STRING.method, Expressions.call(BuiltInMethod.CURRENT_DATE.method, this.root)), operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                        break block0;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                        break block0;
                    }
                }
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call(BuiltInMethod.STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, operand);
                        break block0;
                    }
                    case DATE: {
                        convert = Expressions.call(BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, Expressions.multiply(Expressions.convert_(operand, Long.TYPE), Expressions.constant(86400000L)))), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break block0;
                    }
                    case TIME: {
                        convert = Expressions.call(BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, Expressions.add(Expressions.multiply(Expressions.convert_(Expressions.call(BuiltInMethod.CURRENT_DATE.method, this.root), Long.TYPE), Expressions.constant(86400000L)), Expressions.convert_(operand, Long.TYPE)))), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break block0;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, Expressions.call(BuiltInMethod.UNIX_DATE_TO_STRING.method, Expressions.call(BuiltInMethod.CURRENT_DATE.method, this.root)), operand));
                        break block0;
                    }
                    case TIMESTAMP: {
                        convert = Expressions.call(BuiltInMethod.TIMESTAMP_STRING_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE.method, RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, operand)), Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root));
                        break block0;
                    }
                }
                break;
            }
            case BOOLEAN: {
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        convert = Expressions.call(BuiltInMethod.STRING_TO_BOOLEAN.method, operand);
                        break block0;
                    }
                }
                break;
            }
            case CHAR: 
            case VARCHAR: {
                SqlIntervalQualifier interval = sourceType.getIntervalQualifier();
                switch (sourceType.getSqlTypeName()) {
                    case DATE: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_DATE_TO_STRING.method, operand));
                        break block0;
                    }
                    case TIME: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIME_TO_STRING.method, operand));
                        break block0;
                    }
                    case TIME_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_STRING.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                        break block0;
                    }
                    case TIMESTAMP: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.UNIX_TIMESTAMP_TO_STRING.method, operand));
                        break block0;
                    }
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_STRING.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                        break block0;
                    }
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method, operand, Expressions.constant((Object)Objects.requireNonNull(interval, (String)"interval").timeUnitRange)));
                        break block0;
                    }
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method, operand, Expressions.constant((Object)Objects.requireNonNull(interval, (String)"interval").timeUnitRange), Expressions.constant(interval.getFractionalSecondPrecision(this.typeFactory.getTypeSystem()))));
                        break block0;
                    }
                    case BOOLEAN: {
                        convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.BOOLEAN_TO_STRING.method, operand));
                        break block0;
                    }
                }
                break;
            }
        }
        if (convert == null) {
            convert = EnumUtils.convert(operand, this.typeFactory.getJavaClass(targetType));
        }
        boolean pad = false;
        boolean truncate = true;
        block47 : switch (targetType.getSqlTypeName()) {
            case CHAR: 
            case BINARY: {
                pad = true;
            }
            case VARCHAR: 
            case VARBINARY: {
                int targetPrecision = targetType.getPrecision();
                if (targetPrecision < 0) break;
                switch (sourceType.getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: 
                    case VARBINARY: {
                        int sourcePrecision = sourceType.getPrecision();
                        if (SqlTypeUtil.comparePrecision(sourcePrecision, targetPrecision) <= 0) {
                            truncate = false;
                        }
                        if (SqlTypeUtil.comparePrecision(sourcePrecision, targetPrecision) < 0) break;
                        pad = false;
                    }
                }
                if (!truncate && !pad) break;
                convert = Expressions.call(pad ? BuiltInMethod.TRUNCATE_OR_PAD.method : BuiltInMethod.TRUNCATE.method, convert, Expressions.constant(targetPrecision));
                break;
            }
            case TIMESTAMP: {
                int targetScale = targetType.getScale();
                if (targetScale == Integer.MIN_VALUE) {
                    targetScale = 0;
                }
                if (targetScale >= sourceType.getScale()) break;
                convert = Expressions.call(BuiltInMethod.ROUND_LONG.method, convert, Expressions.constant((long)Math.pow(10.0, 3 - targetScale)));
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                switch (Objects.requireNonNull(sourceType.getSqlTypeName().getFamily(), () -> "null SqlTypeFamily for " + sourceType + ", SqlTypeName " + (Object)((Object)sourceType.getSqlTypeName()))) {
                    case NUMERIC: {
                        BigDecimal multiplier = targetType.getSqlTypeName().getEndUnit().multiplier;
                        BigDecimal divider = BigDecimal.ONE;
                        convert = RexImpTable.multiplyDivide(convert, multiplier, divider);
                        break block47;
                    }
                }
                break;
            }
        }
        return RexToLixTranslator.scaleIntervalToNumber(sourceType, targetType, convert);
    }

    private @Nullable Expression translateCastToTime(RelDataType sourceType, Expression operand) {
        Expression convert = null;
        switch (sourceType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: {
                convert = Expressions.call(BuiltInMethod.STRING_TO_TIME.method, operand);
                break;
            }
            case TIME_WITH_LOCAL_TIME_ZONE: {
                convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIME_WITH_LOCAL_TIME_ZONE_TO_TIME.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                break;
            }
            case TIMESTAMP: {
                convert = Expressions.convert_(Expressions.call(BuiltInMethod.FLOOR_MOD.method, operand, Expressions.constant(86400000L)), Integer.TYPE);
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                convert = RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
                break;
            }
        }
        return convert;
    }

    private @Nullable Expression translateCastToDate(RelDataType sourceType, Expression operand) {
        switch (sourceType.getSqlTypeName()) {
            case CHAR: 
            case VARCHAR: {
                return Expressions.call(BuiltInMethod.STRING_TO_DATE.method, operand);
            }
            case TIMESTAMP: {
                return Expressions.convert_(Expressions.call(BuiltInMethod.FLOOR_DIV.method, operand, Expressions.constant(86400000L)), Integer.TYPE);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return RexImpTable.optimize2(operand, Expressions.call(BuiltInMethod.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_DATE.method, operand, Expressions.call(BuiltInMethod.TIME_ZONE.method, this.root)));
            }
        }
        return null;
    }

    Expression handleMethodCheckedExceptions(Expression callExpr) {
        ParameterExpression methodCall = Expressions.parameter(callExpr.getType(), this.list.newName("method_call"));
        this.list.add(Expressions.declare(16, methodCall, null));
        Statement st = Expressions.statement(Expressions.assign(methodCall, callExpr));
        ParameterExpression e = Expressions.parameter(0, Exception.class, "e");
        NewExpression uncheckedException = Expressions.new_(RuntimeException.class, new Expression[]{e});
        CatchBlock cb = Expressions.catch_(e, Expressions.throw_(uncheckedException));
        this.list.add(Expressions.tryCatch(st, cb));
        return methodCall;
    }

    public RexNode deref(RexNode expr) {
        if (expr instanceof RexLocalRef) {
            RexLocalRef ref = (RexLocalRef)expr;
            RexNode e2 = Objects.requireNonNull(this.program, "program").getExprList().get(ref.getIndex());
            assert (ref.getType().equals(e2.getType()));
            return e2;
        }
        return expr;
    }

    public static Expression translateLiteral(RexLiteral literal, RelDataType type, JavaTypeFactory typeFactory, RexImpTable.NullAs nullAs) {
        Object value2;
        if (literal.isNull()) {
            switch (nullAs) {
                case TRUE: 
                case IS_NULL: {
                    return RexImpTable.TRUE_EXPR;
                }
                case FALSE: 
                case IS_NOT_NULL: {
                    return RexImpTable.FALSE_EXPR;
                }
                case NOT_POSSIBLE: {
                    throw new ControlFlowException();
                }
            }
            return RexImpTable.NULL_EXPR;
        }
        switch (nullAs) {
            case IS_NOT_NULL: {
                return RexImpTable.TRUE_EXPR;
            }
            case IS_NULL: {
                return RexImpTable.FALSE_EXPR;
            }
        }
        Class<Number> javaClass = typeFactory.getJavaClass(type);
        switch (literal.getType().getSqlTypeName()) {
            case DECIMAL: {
                BigDecimal bd = literal.getValueAs(BigDecimal.class);
                if (javaClass == Float.TYPE) {
                    return Expressions.constant(bd, javaClass);
                }
                if (javaClass == Double.TYPE) {
                    return Expressions.constant(bd, javaClass);
                }
                assert (javaClass == BigDecimal.class);
                return Expressions.new_(BigDecimal.class, new Expression[]{Expressions.constant(Objects.requireNonNull(bd, () -> "value for " + literal).toString())});
            }
            case TIME: 
            case DATE: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                value2 = literal.getValueAs(Integer.class);
                javaClass = Integer.TYPE;
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                value2 = literal.getValueAs(Long.class);
                javaClass = Long.TYPE;
                break;
            }
            case CHAR: 
            case VARCHAR: {
                value2 = literal.getValueAs(String.class);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                return Expressions.new_(ByteString.class, new Expression[]{Expressions.constant(literal.getValueAs(byte[].class), byte[].class)});
            }
            case GEOMETRY: {
                Geometry geom = Objects.requireNonNull(literal.getValueAs(Geometry.class), () -> "getValueAs(Geometries.Geom) for " + literal);
                String wkt = SpatialTypeFunctions.ST_AsWKT(geom);
                return Expressions.call(null, BuiltInMethod.ST_GEOM_FROM_EWKT.method, Expressions.constant(wkt));
            }
            case SYMBOL: {
                value2 = Objects.requireNonNull(literal.getValueAs(Enum.class), () -> "getValueAs(Enum.class) for " + literal);
                javaClass = value2.getClass();
                break;
            }
            default: {
                Primitive primitive = Primitive.ofBoxOr(javaClass);
                Comparable value = literal.getValueAs(Comparable.class);
                value2 = primitive != null && value instanceof Number ? primitive.number((Number)((Object)value)) : value;
            }
        }
        return Expressions.constant(value2, javaClass);
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs) {
        return this.translateList(operandList, nullAs, EnumUtils.internalTypes(operandList));
    }

    public List<Expression> translateList(List<RexNode> operandList, RexImpTable.NullAs nullAs, List<? extends @Nullable Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Pair<RexNode, ? extends Type> e : Pair.zip(operandList, storageTypes)) {
            list.add(this.translate((RexNode)e.left, nullAs, (Type)e.right));
        }
        return list;
    }

    public List<Expression> translateList(List<? extends RexNode> operandList) {
        return this.translateList(operandList, EnumUtils.internalTypes(operandList));
    }

    public List<Expression> translateList(List<? extends RexNode> operandList, @Nullable List<? extends @Nullable Type> storageTypes) {
        ArrayList<Expression> list = new ArrayList<Expression>(operandList.size());
        for (int i = 0; i < operandList.size(); ++i) {
            RexNode rex = operandList.get(i);
            Type desiredType = null;
            if (storageTypes != null) {
                desiredType = storageTypes.get(i);
            }
            Expression translate = this.translate(rex, desiredType);
            list.add(translate);
            if (desiredType == null && !this.isNullable(rex)) assert (!Primitive.isBox(translate.getType())) : "Not-null boxed primitive should come back as primitive: " + rex + ", " + translate.getType();
        }
        return list;
    }

    private Expression translateTableFunction(RexCall rexCall, Expression inputEnumerable, PhysType inputPhysType, PhysType outputPhysType) {
        assert (rexCall.getOperator() instanceof SqlWindowTableFunction);
        TableFunctionCallImplementor implementor = RexImpTable.INSTANCE.get((SqlWindowTableFunction)rexCall.getOperator());
        if (implementor == null) {
            throw Util.needToImplement("implementor of " + rexCall.getOperator().getName());
        }
        return implementor.implement(this, inputEnumerable, rexCall, inputPhysType, outputPhysType);
    }

    public static Expression translateCondition(RexProgram program, JavaTypeFactory typeFactory, BlockBuilder list, InputGetter inputGetter, Function1<String, InputGetter> correlates, SqlConformance conformance) {
        RexLocalRef condition = program.getCondition();
        if (condition == null) {
            return RexImpTable.TRUE_EXPR;
        }
        ParameterExpression root = DataContext.ROOT;
        RexToLixTranslator translator = new RexToLixTranslator(program, typeFactory, root, inputGetter, list, null, new RexBuilder(typeFactory), conformance, null);
        translator = translator.setCorrelates(correlates);
        return translator.translate((RexNode)condition, RexImpTable.NullAs.FALSE);
    }

    public boolean isNullable(RexNode e) {
        return e.getType().isNullable();
    }

    public RexToLixTranslator setBlock(BlockBuilder list) {
        if (list == this.list) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, list, this.staticList, this.builder, this.conformance, this.correlates);
    }

    public RexToLixTranslator setCorrelates(@Nullable Function1<String, InputGetter> correlates) {
        if (this.correlates == correlates) {
            return this;
        }
        return new RexToLixTranslator(this.program, this.typeFactory, this.root, this.inputGetter, this.list, this.staticList, this.builder, this.conformance, correlates);
    }

    public Expression getRoot() {
        return this.root;
    }

    private static Expression scaleIntervalToNumber(RelDataType sourceType, RelDataType targetType, Expression operand) {
        switch (Objects.requireNonNull(targetType.getSqlTypeName().getFamily(), () -> "SqlTypeFamily for " + targetType)) {
            case NUMERIC: {
                switch (sourceType.getSqlTypeName()) {
                    case INTERVAL_YEAR: 
                    case INTERVAL_YEAR_MONTH: 
                    case INTERVAL_MONTH: 
                    case INTERVAL_DAY: 
                    case INTERVAL_DAY_HOUR: 
                    case INTERVAL_DAY_MINUTE: 
                    case INTERVAL_DAY_SECOND: 
                    case INTERVAL_HOUR: 
                    case INTERVAL_HOUR_MINUTE: 
                    case INTERVAL_HOUR_SECOND: 
                    case INTERVAL_MINUTE: 
                    case INTERVAL_MINUTE_SECOND: 
                    case INTERVAL_SECOND: {
                        BigDecimal multiplier = BigDecimal.ONE;
                        BigDecimal divider = sourceType.getSqlTypeName().getEndUnit().multiplier;
                        return RexImpTable.multiplyDivide(operand, multiplier, divider);
                    }
                }
                break;
            }
        }
        return operand;
    }

    @Override
    public Result visitInputRef(RexInputRef inputRef) {
        Pair<RexInputRef, @Nullable Type> key = Pair.of(inputRef, this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        Expression valueExpression = Objects.requireNonNull(this.inputGetter, "inputGetter").field(this.list, inputRef.getIndex(), this.currentStorageType);
        ParameterExpression valueVariable = Expressions.parameter(valueExpression.getType(), this.list.newName("input_value"));
        this.list.add(Expressions.declare(16, valueVariable, valueExpression));
        Expression isNullExpression = this.checkNull(valueVariable);
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, this.list.newName("input_isNull"));
        this.list.add(Expressions.declare(16, isNullVariable, isNullExpression));
        Result result = new Result(isNullVariable, valueVariable);
        if (!(this.inputGetter instanceof EnumerableMatch.PrevInputGetter)) {
            this.rexWithStorageTypeResultMap.put(key, result);
        }
        return new Result(isNullVariable, valueVariable);
    }

    @Override
    public Result visitLocalRef(RexLocalRef localRef) {
        return this.deref(localRef).accept(this);
    }

    @Override
    public Result visitLiteral(RexLiteral literal) {
        ParameterExpression valueVariable;
        if (this.rexResultMap.containsKey(literal)) {
            return this.rexResultMap.get(literal);
        }
        Expression valueExpression = literal.isNull() ? this.getTypedNullLiteral(literal) : RexToLixTranslator.translateLiteral(literal, literal.getType(), this.typeFactory, RexImpTable.NullAs.NOT_POSSIBLE);
        Expression literalValue = this.appendConstant("literal_value", valueExpression);
        if (literalValue instanceof ParameterExpression) {
            valueVariable = (ParameterExpression)literalValue;
        } else {
            valueVariable = Expressions.parameter(valueExpression.getType(), this.list.newName("literal_value"));
            this.list.add(Expressions.declare(16, valueVariable, valueExpression));
        }
        ConstantExpression isNullExpression = literal.isNull() ? RexImpTable.TRUE_EXPR : RexImpTable.FALSE_EXPR;
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, this.list.newName("literal_isNull"));
        this.list.add(Expressions.declare(16, isNullVariable, (Expression)isNullExpression));
        this.literalMap.put(valueVariable, valueExpression);
        Result result = new Result(isNullVariable, valueVariable);
        this.rexResultMap.put(literal, result);
        return result;
    }

    private ConstantExpression getTypedNullLiteral(RexLiteral literal) {
        assert (literal.isNull());
        Class<Long> javaClass = this.typeFactory.getJavaClass(literal.getType());
        switch (literal.getType().getSqlTypeName()) {
            case TIME: 
            case DATE: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                javaClass = Integer.class;
                break;
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                javaClass = Long.class;
                break;
            }
        }
        return javaClass == null || javaClass == Void.class ? RexImpTable.NULL_EXPR : Expressions.constant(null, javaClass);
    }

    @Override
    public Result visitCall(RexCall call) {
        if (this.rexResultMap.containsKey(call)) {
            return this.rexResultMap.get(call);
        }
        SqlOperator operator = call.getOperator();
        if (operator == SqlStdOperatorTable.PREV) {
            return this.implementPrev(call);
        }
        if (operator == SqlStdOperatorTable.CASE) {
            return this.implementCaseWhen(call);
        }
        if (operator == SqlStdOperatorTable.SEARCH) {
            return RexUtil.expandSearch(this.builder, this.program, call).accept(this);
        }
        RexImpTable.RexCallImplementor implementor = RexImpTable.INSTANCE.get(operator);
        if (implementor == null) {
            throw new RuntimeException("cannot translate call " + call);
        }
        List<RexNode> operandList = call.getOperands();
        List<@Nullable Type> storageTypes = EnumUtils.internalTypes(operandList);
        ArrayList<Result> operandResults = new ArrayList<Result>();
        for (int i = 0; i < operandList.size(); ++i) {
            Result operandResult = RexToLixTranslator.implementCallOperand(operandList.get(i), storageTypes.get(i), this);
            operandResults.add(operandResult);
        }
        this.callOperandResultMap.put(call, operandResults);
        Result result = implementor.implement(this, call, operandResults);
        this.rexResultMap.put(call, result);
        return result;
    }

    private static Result implementCallOperand(RexNode operand, @Nullable Type storageType, RexToLixTranslator translator) {
        Type originalStorageType = translator.currentStorageType;
        translator.currentStorageType = storageType;
        Result operandResult = operand.accept(translator);
        if (storageType != null) {
            operandResult = translator.toInnerStorageType(operandResult, storageType);
        }
        translator.currentStorageType = originalStorageType;
        return operandResult;
    }

    private static Expression implementCallOperand2(RexNode operand, @Nullable Type storageType, RexToLixTranslator translator) {
        Type originalStorageType = translator.currentStorageType;
        translator.currentStorageType = storageType;
        Expression result = translator.translate(operand);
        translator.currentStorageType = originalStorageType;
        return result;
    }

    private Result implementPrev(RexCall call) {
        RexNode node = call.getOperands().get(0);
        RexNode offset = call.getOperands().get(1);
        BinaryExpression offs = Expressions.multiply(this.translate(offset), Expressions.constant(-1));
        Objects.requireNonNull((EnumerableMatch.PrevInputGetter)this.inputGetter, "inputGetter").setOffset(offs);
        return node.accept(this);
    }

    private Result implementCaseWhen(RexCall call) {
        Type returnType = this.typeFactory.getJavaClass(call.getType());
        ParameterExpression valueVariable = Expressions.parameter(returnType, this.list.newName("case_when_value"));
        this.list.add(Expressions.declare(0, valueVariable, null));
        List<RexNode> operandList = call.getOperands();
        RexToLixTranslator.implementRecursively(this, operandList, valueVariable, 0);
        Expression isNullExpression = this.checkNull(valueVariable);
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, this.list.newName("case_when_isNull"));
        this.list.add(Expressions.declare(16, isNullVariable, isNullExpression));
        Result result = new Result(isNullVariable, valueVariable);
        this.rexResultMap.put(call, result);
        return result;
    }

    private static void implementRecursively(RexToLixTranslator currentTranslator, List<RexNode> operandList, ParameterExpression valueVariable, int pos) {
        BlockBuilder currentBlockBuilder = currentTranslator.getBlockBuilder();
        List<@Nullable Type> storageTypes = EnumUtils.internalTypes(operandList);
        if (pos == operandList.size() - 1) {
            Expression res = RexToLixTranslator.implementCallOperand2(operandList.get(pos), storageTypes.get(pos), currentTranslator);
            currentBlockBuilder.add(Expressions.statement(Expressions.assign(valueVariable, EnumUtils.convert(res, valueVariable.getType()))));
            return;
        }
        RexNode testerNode = operandList.get(pos);
        Result testerResult = RexToLixTranslator.implementCallOperand(testerNode, storageTypes.get(pos), currentTranslator);
        BinaryExpression tester = Expressions.andAlso(Expressions.not(testerResult.isNullVariable), testerResult.valueVariable);
        RexNode ifTrueNode = operandList.get(pos + 1);
        BlockBuilder ifTrueBlockBuilder = new BlockBuilder(true, currentBlockBuilder);
        RexToLixTranslator ifTrueTranslator = currentTranslator.setBlock(ifTrueBlockBuilder);
        Expression ifTrueRes = RexToLixTranslator.implementCallOperand2(ifTrueNode, storageTypes.get(pos + 1), ifTrueTranslator);
        ifTrueBlockBuilder.add(Expressions.statement(Expressions.assign(valueVariable, EnumUtils.convert(ifTrueRes, valueVariable.getType()))));
        BlockStatement ifTrue = ifTrueBlockBuilder.toBlock();
        if (pos + 1 == operandList.size() - 1) {
            currentBlockBuilder.add(Expressions.ifThen(tester, ifTrue));
            return;
        }
        BlockBuilder ifFalseBlockBuilder = new BlockBuilder(true, currentBlockBuilder);
        RexToLixTranslator ifFalseTranslator = currentTranslator.setBlock(ifFalseBlockBuilder);
        RexToLixTranslator.implementRecursively(ifFalseTranslator, operandList, valueVariable, pos + 2);
        BlockStatement ifFalse = ifFalseBlockBuilder.toBlock();
        currentBlockBuilder.add(Expressions.ifThenElse((Expression)tester, (Node)ifTrue, (Node)ifFalse));
    }

    private Result toInnerStorageType(Result result, Type storageType) {
        Expression valueExpression = EnumUtils.toInternal(result.valueVariable, storageType);
        if (valueExpression.equals(result.valueVariable)) {
            return result;
        }
        ParameterExpression valueVariable = Expressions.parameter(valueExpression.getType(), this.list.newName(result.valueVariable.name + "_inner_type"));
        this.list.add(Expressions.declare(16, valueVariable, valueExpression));
        ParameterExpression isNullVariable = result.isNullVariable;
        return new Result(isNullVariable, valueVariable);
    }

    @Override
    public Result visitDynamicParam(RexDynamicParam dynamicParam) {
        Pair<RexDynamicParam, @Nullable Type> key = Pair.of(dynamicParam, this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        Type storageType = this.currentStorageType != null ? this.currentStorageType : this.typeFactory.getJavaClass(dynamicParam.getType());
        Expression valueExpression = EnumUtils.convert(Expressions.call(this.root, BuiltInMethod.DATA_CONTEXT_GET.method, Expressions.constant("?" + dynamicParam.getIndex())), storageType);
        ParameterExpression valueVariable = Expressions.parameter(valueExpression.getType(), this.list.newName("value_dynamic_param"));
        this.list.add(Expressions.declare(16, valueVariable, valueExpression));
        ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, this.list.newName("isNull_dynamic_param"));
        this.list.add(Expressions.declare(16, isNullVariable, this.checkNull(valueVariable)));
        Result result = new Result(isNullVariable, valueVariable);
        this.rexWithStorageTypeResultMap.put(key, result);
        return result;
    }

    @Override
    public Result visitFieldAccess(RexFieldAccess fieldAccess) {
        Pair<RexFieldAccess, @Nullable Type> key = Pair.of(fieldAccess, this.currentStorageType);
        if (this.rexWithStorageTypeResultMap.containsKey(key)) {
            return this.rexWithStorageTypeResultMap.get(key);
        }
        RexNode target = this.deref(fieldAccess.getReferenceExpr());
        int fieldIndex = fieldAccess.getField().getIndex();
        String fieldName = fieldAccess.getField().getName();
        switch (target.getKind()) {
            case CORREL_VARIABLE: {
                if (this.correlates == null) {
                    throw new RuntimeException("Cannot translate " + fieldAccess + " since correlate variables resolver is not defined");
                }
                InputGetter getter = this.correlates.apply(((RexCorrelVariable)target).getName());
                Expression input = getter.field(this.list, fieldIndex, this.currentStorageType);
                Expression condition = this.checkNull(input);
                ParameterExpression valueVariable = Expressions.parameter(input.getType(), this.list.newName("corInp_value"));
                this.list.add(Expressions.declare(16, valueVariable, input));
                ParameterExpression isNullVariable = Expressions.parameter(Boolean.TYPE, this.list.newName("corInp_isNull"));
                Expression isNullExpression = Expressions.condition(condition, RexImpTable.TRUE_EXPR, this.checkNull(valueVariable));
                this.list.add(Expressions.declare(16, isNullVariable, isNullExpression));
                Result result1 = new Result(isNullVariable, valueVariable);
                this.rexWithStorageTypeResultMap.put(key, result1);
                return result1;
            }
        }
        RexNode rxIndex = this.builder.makeLiteral(fieldIndex, this.typeFactory.createType(Integer.TYPE), true);
        RexNode rxName = this.builder.makeLiteral(fieldName, this.typeFactory.createType((Type)((Object)String.class)), true);
        RexCall accessCall = (RexCall)this.builder.makeCall(fieldAccess.getType(), SqlStdOperatorTable.STRUCT_ACCESS, ImmutableList.of(target, rxIndex, rxName));
        Result result2 = accessCall.accept(this);
        this.rexWithStorageTypeResultMap.put(key, result2);
        return result2;
    }

    @Override
    public Result visitOver(RexOver over) {
        throw new RuntimeException("cannot translate expression " + over);
    }

    @Override
    public Result visitCorrelVariable(RexCorrelVariable correlVariable) {
        throw new RuntimeException("Cannot translate " + correlVariable + ". Correlated variables should always be referenced by field access");
    }

    @Override
    public Result visitRangeRef(RexRangeRef rangeRef) {
        throw new RuntimeException("cannot translate expression " + rangeRef);
    }

    @Override
    public Result visitSubQuery(RexSubQuery subQuery) {
        throw new RuntimeException("cannot translate expression " + subQuery);
    }

    @Override
    public Result visitTableInputRef(RexTableInputRef fieldRef) {
        throw new RuntimeException("cannot translate expression " + fieldRef);
    }

    @Override
    public Result visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        return this.visitInputRef(fieldRef);
    }

    Expression checkNull(Expression expr) {
        if (Primitive.flavor(expr.getType()) == Primitive.Flavor.PRIMITIVE) {
            return RexImpTable.FALSE_EXPR;
        }
        return Expressions.equal(expr, RexImpTable.NULL_EXPR);
    }

    Expression checkNotNull(Expression expr) {
        if (Primitive.flavor(expr.getType()) == Primitive.Flavor.PRIMITIVE) {
            return RexImpTable.TRUE_EXPR;
        }
        return Expressions.notEqual(expr, RexImpTable.NULL_EXPR);
    }

    BlockBuilder getBlockBuilder() {
        return this.list;
    }

    Expression getLiteral(Expression literalVariable) {
        return Objects.requireNonNull(this.literalMap.get(literalVariable), () -> "literalMap.get(literalVariable) for " + literalVariable);
    }

    @Nullable Object getLiteralValue(@Nullable Expression expr) {
        if (expr instanceof ParameterExpression) {
            Expression constantExpr = this.literalMap.get(expr);
            return this.getLiteralValue(constantExpr);
        }
        if (expr instanceof ConstantExpression) {
            return ((ConstantExpression)expr).value;
        }
        return null;
    }

    List<Result> getCallOperandResult(RexCall call) {
        return Objects.requireNonNull(this.callOperandResultMap.get(call), () -> "callOperandResultMap.get(call) for " + call);
    }

    Expression functionInstance(RexCall call, Method method) {
        RexCallBinding callBinding = RexCallBinding.create(this.typeFactory, call, this.program, ImmutableList.of());
        Expression target = this.getInstantiationExpression(method, callBinding);
        return this.appendConstant("f", target);
    }

    private Expression getInstantiationExpression(Method method, RexCallBinding callBinding) {
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            Constructor<?> constructor = declaringClass.getConstructor(FunctionContext.class);
            ArrayList constantArgs = new ArrayList();
            Ord.forEach(method.getParameterTypes(), (parameterType, i) -> constantArgs.add(callBinding.isOperandLiteral(i, true) ? this.appendConstant("_arg", Expressions.constant(callBinding.getOperandLiteralValue(i, Primitive.box(parameterType)))) : Expressions.constant(null)));
            MethodCallExpression context = Expressions.call(BuiltInMethod.FUNCTION_CONTEXTS_OF.method, DataContext.ROOT, Expressions.newArrayInit(Object.class, constantArgs));
            return Expressions.new_(constructor, context);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Expressions.new_(declaringClass);
        }
    }

    private Expression appendConstant(String name, Expression e) {
        if (this.staticList != null) {
            String upperName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
            return this.staticList.append(upperName, e);
        }
        return this.list.append(name, e);
    }

    public static class Result {
        final ParameterExpression isNullVariable;
        final ParameterExpression valueVariable;

        public Result(ParameterExpression isNullVariable, ParameterExpression valueVariable) {
            this.isNullVariable = isNullVariable;
            this.valueVariable = valueVariable;
        }
    }

    public static class InputGetterImpl
    implements InputGetter {
        private final ImmutableMap<Expression, PhysType> inputs;

        @Deprecated
        public InputGetterImpl(List<Pair<Expression, PhysType>> inputs) {
            this(InputGetterImpl.mapOf(inputs));
        }

        public InputGetterImpl(Expression e, PhysType physType) {
            this(ImmutableMap.of(e, physType));
        }

        public InputGetterImpl(Map<Expression, PhysType> inputs) {
            this.inputs = ImmutableMap.copyOf(inputs);
        }

        private static <K, V> Map<K, V> mapOf(Iterable<? extends Map.Entry<K, V>> entries) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            Pair.forEach(entries, b::put);
            return b.build();
        }

        @Override
        public Expression field(BlockBuilder list, int index, @Nullable Type storageType) {
            int offset = 0;
            for (Map.Entry input : this.inputs.entrySet()) {
                PhysType physType = (PhysType)input.getValue();
                int fieldCount = physType.getRowType().getFieldCount();
                if (index >= offset + fieldCount) {
                    offset += fieldCount;
                    continue;
                }
                Expression left = list.append("current", (Expression)input.getKey());
                return physType.fieldReference(left, index - offset, storageType);
            }
            throw new IllegalArgumentException("Unable to find field #" + index);
        }
    }

    public static interface InputGetter {
        public Expression field(BlockBuilder var1, int var2, @Nullable Type var3);
    }
}

