/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptSchemaWithSampling;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.schema.CustomColumnResolvingTable;
import org.apache.calcite.schema.ExtensibleTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlScopedShuttle;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlValidatorUtil {
    public static final Suggester EXPR_SUGGESTER = (original, attempt, size) -> Util.first(original, "EXPR$") + attempt;
    public static final Suggester F_SUGGESTER = (original, attempt, size) -> Util.first(original, "$f") + Math.max(size, attempt);
    public static final Suggester ATTEMPT_SUGGESTER = (original, attempt, size) -> Util.first(original, "$") + attempt;

    private SqlValidatorUtil() {
    }

    public static @Nullable RelOptTable getRelOptTable(SqlValidatorNamespace namespace, @Nullable Prepare.CatalogReader catalogReader, @Nullable String datasetName, boolean @Nullable [] usedDataset) {
        SqlValidatorImpl.DmlNamespace dmlNamespace;
        SqlValidatorNamespace resolvedNamespace;
        if (namespace.isWrapperFor(TableNamespace.class)) {
            TableNamespace tableNamespace = namespace.unwrap(TableNamespace.class);
            return SqlValidatorUtil.getRelOptTable(tableNamespace, Objects.requireNonNull(catalogReader, "catalogReader"), datasetName, usedDataset, tableNamespace.extendedFields);
        }
        if (namespace.isWrapperFor(SqlValidatorImpl.DmlNamespace.class) && (resolvedNamespace = (dmlNamespace = namespace.unwrap(SqlValidatorImpl.DmlNamespace.class)).resolve()).isWrapperFor(TableNamespace.class)) {
            TableNamespace tableNamespace = resolvedNamespace.unwrap(TableNamespace.class);
            SqlValidatorTable validatorTable = tableNamespace.getTable();
            ImmutableList<RelDataTypeField> extendedFields = dmlNamespace.extendList == null ? ImmutableList.of() : SqlValidatorUtil.getExtendedColumns(namespace.getValidator(), validatorTable, dmlNamespace.extendList);
            return SqlValidatorUtil.getRelOptTable(tableNamespace, Objects.requireNonNull(catalogReader, "catalogReader"), datasetName, usedDataset, extendedFields);
        }
        return null;
    }

    private static @Nullable RelOptTable getRelOptTable(TableNamespace tableNamespace, Prepare.CatalogReader catalogReader, @Nullable String datasetName, boolean @Nullable [] usedDataset, List<RelDataTypeField> extendedFields) {
        RelOptTable table;
        List<String> names = tableNamespace.getTable().getQualifiedName();
        if (datasetName != null && catalogReader instanceof RelOptSchemaWithSampling) {
            RelOptSchemaWithSampling reader = (RelOptSchemaWithSampling)((Object)catalogReader);
            table = reader.getTableForMember(names, datasetName, usedDataset);
        } else {
            table = catalogReader.getTableForMember((List)names);
        }
        if (table != null && !extendedFields.isEmpty()) {
            table = table.extend(extendedFields);
        }
        return table;
    }

    public static List<RelDataTypeField> getExtendedColumns(SqlValidator validator, SqlValidatorTable table, SqlNodeList extendedColumns) {
        ImmutableList.Builder extendedFields = ImmutableList.builder();
        ExtensibleTable extTable = table.unwrap(ExtensibleTable.class);
        int extendedFieldOffset = extTable == null ? table.getRowType().getFieldCount() : extTable.getExtendedColumnOffset();
        for (Pair<SqlIdentifier, SqlDataTypeSpec> pair : SqlValidatorUtil.pairs(extendedColumns)) {
            SqlIdentifier identifier = (SqlIdentifier)pair.left;
            SqlDataTypeSpec type = (SqlDataTypeSpec)pair.right;
            extendedFields.add(new RelDataTypeFieldImpl(identifier.toString(), extendedFieldOffset++, type.deriveType(Objects.requireNonNull(validator, "validator"))));
        }
        return extendedFields.build();
    }

    private static List<Pair<SqlIdentifier, SqlDataTypeSpec>> pairs(SqlNodeList extendedColumns) {
        return Util.pairs(extendedColumns);
    }

    public static ImmutableMap<Integer, RelDataTypeField> getIndexToFieldMap(List<RelDataTypeField> sourceFields, RelDataType targetFields) {
        ImmutableMap.Builder<Integer, RelDataTypeField> output = ImmutableMap.builder();
        for (RelDataTypeField source : sourceFields) {
            RelDataTypeField target = targetFields.getField(source.getName(), true, false);
            if (target == null) continue;
            output.put(source.getIndex(), target);
        }
        return output.build();
    }

    public static ImmutableBitSet getOrdinalBitSet(RelDataType sourceRowType, RelDataType targetRowType) {
        ImmutableMap<Integer, RelDataTypeField> indexToField = SqlValidatorUtil.getIndexToFieldMap(sourceRowType.getFieldList(), targetRowType);
        return SqlValidatorUtil.getOrdinalBitSet(sourceRowType, indexToField);
    }

    public static ImmutableBitSet getOrdinalBitSet(RelDataType sourceRowType, Map<Integer, RelDataTypeField> indexToField) {
        ImmutableBitSet source = ImmutableBitSet.of(Util.transform(sourceRowType.getFieldList(), RelDataTypeField::getIndex));
        ImmutableBitSet target = ImmutableBitSet.of(indexToField.keySet());
        return source.intersect(target);
    }

    public static Map<String, Integer> mapNameToIndex(List<RelDataTypeField> fields) {
        ImmutableMap.Builder<String, Integer> output = ImmutableMap.builder();
        for (RelDataTypeField field : fields) {
            output.put(field.getName(), field.getIndex());
        }
        return output.build();
    }

    @Deprecated
    public static @Nullable RelDataTypeField lookupField(boolean caseSensitive, RelDataType rowType, String columnName) {
        return rowType.getField(columnName, caseSensitive, false);
    }

    public static void checkCharsetAndCollateConsistentIfCharType(RelDataType type) {
        Charset colCharset;
        Charset strCharset;
        if (!SqlTypeUtil.inCharFamily(type) || !(strCharset = NonNullableAccessors.getCharset(type)).equals(colCharset = NonNullableAccessors.getCollation(type).getCharset())) {
            // empty if block
        }
    }

    static void checkIdentifierListForDuplicates(List<? extends @Nullable SqlNode> columnList, SqlValidatorImpl.ValidationErrorFunction validationErrorFunction) {
        List<List> names = Util.transform(columnList, node -> ((SqlIdentifier)Objects.requireNonNull(node, (String)"node")).names);
        int i = Util.firstDuplicate(names);
        if (i >= 0) {
            throw validationErrorFunction.apply(Objects.requireNonNull(columnList.get(i), () -> columnList + ".get(" + i + ")"), Static.RESOURCE.duplicateNameInColumnList((String)Util.last(names.get(i))));
        }
    }

    public static SqlNode addAlias(SqlNode expr, String alias) {
        SqlParserPos pos = expr.getParserPosition();
        SqlIdentifier id = new SqlIdentifier(alias, pos);
        return SqlStdOperatorTable.AS.createCall(pos, expr, id);
    }

    public static String alias(SqlNode node, int ordinal) {
        Preconditions.checkArgument(ordinal >= 0);
        return Objects.requireNonNull(SqlValidatorUtil.alias_(node, ordinal), "alias");
    }

    public static @Nullable String alias(SqlNode node) {
        return SqlValidatorUtil.alias_(node, -1);
    }

    @Deprecated
    public static @Nullable String getAlias(SqlNode node, int ordinal) {
        return SqlValidatorUtil.alias_(node, ordinal);
    }

    private static @Nullable String alias_(SqlNode node, int ordinal) {
        switch (node.getKind()) {
            case AS: {
                return ((SqlNode)((SqlCall)node).operand(1)).toString();
            }
            case OVER: {
                return SqlValidatorUtil.getAlias(((SqlCall)node).operand(0), ordinal);
            }
            case IDENTIFIER: {
                return Util.last(((SqlIdentifier)node).names);
            }
        }
        if (ordinal < 0) {
            return null;
        }
        return SqlUtil.deriveAliasFromOrdinal(ordinal);
    }

    public static SqlValidatorWithHints newValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlValidator.Config config) {
        return new SqlValidatorImpl(opTab, catalogReader, typeFactory, config);
    }

    @Deprecated
    public static SqlValidatorWithHints newValidator(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory) {
        return SqlValidatorUtil.newValidator(opTab, catalogReader, typeFactory, SqlValidator.Config.DEFAULT);
    }

    public static String uniquify(@Nullable String name, Set<String> usedNames, Suggester suggester) {
        if (name != null && usedNames.add(name)) {
            return name;
        }
        String originalName = name;
        int j = 0;
        while (!usedNames.add(name = suggester.apply(originalName, j, usedNames.size()))) {
            ++j;
        }
        return name;
    }

    @Deprecated
    public static List<String> uniquify(List<String> nameList) {
        return SqlValidatorUtil.uniquify(nameList, EXPR_SUGGESTER, true);
    }

    @Deprecated
    public static List<String> uniquify(List<String> nameList, Suggester suggester) {
        return SqlValidatorUtil.uniquify(nameList, suggester, true);
    }

    public static List<String> uniquify(List<String> nameList, boolean caseSensitive) {
        return SqlValidatorUtil.uniquify(nameList, EXPR_SUGGESTER, caseSensitive);
    }

    public static List<String> uniquify(List<? extends @Nullable String> nameList, Suggester suggester, boolean caseSensitive) {
        LinkedHashSet<String> used = caseSensitive ? new LinkedHashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        int changeCount = 0;
        ArrayList<? extends String> newNameList = new ArrayList<String>();
        for (String name : nameList) {
            String uniqueName = SqlValidatorUtil.uniquify(name, used, suggester);
            if (!uniqueName.equals(name)) {
                ++changeCount;
            }
            newNameList.add(uniqueName);
        }
        return changeCount == 0 ? nameList : newNameList;
    }

    public static RelDataType deriveJoinRowType(RelDataType leftType, @Nullable RelDataType rightType, JoinRelType joinType, RelDataTypeFactory typeFactory, @Nullable List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        assert (systemFieldList != null);
        switch (joinType) {
            case LEFT: {
                rightType = typeFactory.createTypeWithNullability(Objects.requireNonNull(rightType, "rightType"), true);
                break;
            }
            case RIGHT: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                break;
            }
            case FULL: {
                leftType = typeFactory.createTypeWithNullability(leftType, true);
                rightType = typeFactory.createTypeWithNullability(Objects.requireNonNull(rightType, "rightType"), true);
                break;
            }
            case SEMI: 
            case ANTI: {
                rightType = null;
                break;
            }
        }
        return SqlValidatorUtil.createJoinType(typeFactory, leftType, rightType, fieldNameList, systemFieldList);
    }

    public static RelDataType createJoinType(RelDataTypeFactory typeFactory, RelDataType leftType, @Nullable RelDataType rightType, @Nullable List<String> fieldNameList, List<RelDataTypeField> systemFieldList) {
        assert (fieldNameList == null || fieldNameList.size() == systemFieldList.size() + leftType.getFieldCount() + (rightType == null ? 0 : rightType.getFieldCount()));
        List<String> nameList = new ArrayList<String>();
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        HashSet<String> uniqueNameList = typeFactory.getTypeSystem().isSchemaCaseSensitive() ? new HashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        SqlValidatorUtil.addFields(systemFieldList, typeList, nameList, uniqueNameList);
        SqlValidatorUtil.addFields(leftType.getFieldList(), typeList, nameList, uniqueNameList);
        if (rightType != null) {
            SqlValidatorUtil.addFields(rightType.getFieldList(), typeList, nameList, uniqueNameList);
        }
        if (fieldNameList != null) {
            assert (fieldNameList.size() == nameList.size());
            nameList = fieldNameList;
        }
        return typeFactory.createStructType(typeList, nameList);
    }

    private static void addFields(List<RelDataTypeField> fieldList, List<RelDataType> typeList, List<String> nameList, Set<String> uniqueNames) {
        for (RelDataTypeField field : fieldList) {
            String name = field.getName();
            if (uniqueNames.contains(name)) {
                String nameBase = name;
                int j = 0;
                while (uniqueNames.contains(name = nameBase + j)) {
                    ++j;
                }
            }
            nameList.add(name);
            uniqueNames.add(name);
            typeList.add(field.getType());
        }
    }

    public static @Nullable RelDataTypeField getTargetField(RelDataType rowType, RelDataTypeFactory typeFactory, SqlIdentifier id, SqlValidatorCatalogReader catalogReader, @Nullable RelOptTable table) {
        Table t;
        Table table2 = t = table == null ? null : table.unwrap(Table.class);
        if (!(t instanceof CustomColumnResolvingTable)) {
            SqlNameMatcher nameMatcher = catalogReader.nameMatcher();
            return nameMatcher.field(rowType, id.getSimple());
        }
        List<Pair<RelDataTypeField, List<String>>> entries = ((CustomColumnResolvingTable)t).resolveColumn(rowType, typeFactory, id.names);
        switch (entries.size()) {
            case 1: {
                if (!entries.get(0).getValue().isEmpty()) {
                    return null;
                }
                return entries.get(0).getKey();
            }
        }
        return null;
    }

    public static SqlValidatorNamespace lookup(SqlValidatorScope scope, List<String> names) {
        assert (names.size() > 0);
        SqlNameMatcher nameMatcher = scope.getValidator().getCatalogReader().nameMatcher();
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        scope.resolve(ImmutableList.of(names.get(0)), nameMatcher, false, resolved);
        assert (resolved.count() == 1);
        SqlValidatorNamespace namespace = resolved.only().namespace;
        for (String name : Util.skip(names)) {
            namespace = namespace.lookupChild(name);
            assert (namespace != null);
        }
        return namespace;
    }

    public static void getSchemaObjectMonikers(SqlValidatorCatalogReader catalogReader, List<String> names, List<SqlMoniker> hints) {
        List<String> subNames = Util.skipLast(names);
        for (List<String> x : catalogReader.getSchemaPaths()) {
            ImmutableCollection names2 = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(x)).addAll(subNames)).build();
            hints.addAll(catalogReader.getAllSchemaObjectNames((List<String>)((Object)names2)));
        }
    }

    public static @Nullable SelectScope getEnclosingSelectScope(@Nullable SqlValidatorScope scope) {
        while (scope instanceof DelegatingScope) {
            if (scope instanceof SelectScope) {
                return (SelectScope)scope;
            }
            scope = ((DelegatingScope)scope).getParent();
        }
        return null;
    }

    public static @Nullable AggregatingSelectScope getEnclosingAggregateSelectScope(SqlValidatorScope scope) {
        while (scope instanceof DelegatingScope) {
            if (scope instanceof AggregatingSelectScope) {
                return (AggregatingSelectScope)scope;
            }
            scope = ((DelegatingScope)scope).getParent();
        }
        return null;
    }

    public static List<String> deriveNaturalJoinColumnList(SqlNameMatcher nameMatcher, RelDataType leftRowType, RelDataType rightRowType) {
        ImmutableList.Builder naturalColumnNames = ImmutableList.builder();
        Set<String> rightSet = nameMatcher.createSet();
        rightSet.addAll(rightRowType.getFieldNames());
        Set<String> leftSet = nameMatcher.createSet();
        for (String leftName : leftRowType.getFieldNames()) {
            if (!leftSet.add(leftName) || !rightSet.contains(leftName)) continue;
            naturalColumnNames.add(leftName);
        }
        return naturalColumnNames.build();
    }

    public static RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList, RelDataTypeFactory typeFactory, boolean caseSensitive) {
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>(columnNameList.size());
        for (String name : columnNameList) {
            RelDataTypeField field = type.getField(name, caseSensitive, false);
            assert (field != null) : "field " + name + (caseSensitive ? " (caseSensitive)" : "") + " is not found in " + type;
            fields.add(type.getFieldList().get(field.getIndex()));
        }
        return typeFactory.createStructType(fields);
    }

    public static void analyzeGroupItem(SqlValidatorScope scope, GroupAnalyzer groupAnalyzer, ImmutableList.Builder<ImmutableList<ImmutableBitSet>> topBuilder, SqlNode groupExpr) {
        switch (groupExpr.getKind()) {
            case ROLLUP: 
            case CUBE: {
                List<ImmutableBitSet> bitSets = SqlValidatorUtil.analyzeGroupTuple(scope, groupAnalyzer, ((SqlCall)groupExpr).getOperandList());
                switch (groupExpr.getKind()) {
                    case ROLLUP: {
                        topBuilder.add((Object)SqlValidatorUtil.rollup(bitSets));
                        return;
                    }
                }
                topBuilder.add((Object)SqlValidatorUtil.cube(bitSets));
                return;
            }
            case OTHER: {
                if (!(groupExpr instanceof SqlNodeList)) break;
                SqlNodeList list = (SqlNodeList)groupExpr;
                for (SqlNode node : list) {
                    SqlValidatorUtil.analyzeGroupItem(scope, groupAnalyzer, topBuilder, node);
                }
                return;
            }
        }
        ImmutableList.Builder<ImmutableBitSet> builder = ImmutableList.builder();
        SqlValidatorUtil.convertGroupSet(scope, groupAnalyzer, builder, groupExpr);
        topBuilder.add(builder.build());
    }

    private static void convertGroupSet(SqlValidatorScope scope, GroupAnalyzer groupAnalyzer, ImmutableList.Builder<ImmutableBitSet> builder, SqlNode groupExpr) {
        switch (groupExpr.getKind()) {
            case GROUPING_SETS: {
                SqlCall call = (SqlCall)groupExpr;
                for (SqlNode node : call.getOperandList()) {
                    SqlValidatorUtil.convertGroupSet(scope, groupAnalyzer, builder, node);
                }
                return;
            }
            case ROW: {
                List<ImmutableBitSet> bitSets = SqlValidatorUtil.analyzeGroupTuple(scope, groupAnalyzer, ((SqlCall)groupExpr).getOperandList());
                builder.add((Object)ImmutableBitSet.union(bitSets));
                return;
            }
            case ROLLUP: 
            case CUBE: {
                List<ImmutableBitSet> operandBitSet = SqlValidatorUtil.analyzeGroupTuple(scope, groupAnalyzer, ((SqlCall)groupExpr).getOperandList());
                switch (groupExpr.getKind()) {
                    case ROLLUP: {
                        builder.addAll(SqlValidatorUtil.rollup(operandBitSet));
                        return;
                    }
                }
                builder.addAll(SqlValidatorUtil.cube(operandBitSet));
                return;
            }
        }
        builder.add((Object)SqlValidatorUtil.analyzeGroupExpr(scope, groupAnalyzer, groupExpr));
    }

    private static List<ImmutableBitSet> analyzeGroupTuple(SqlValidatorScope scope, GroupAnalyzer groupAnalyzer, List<SqlNode> operandList) {
        ArrayList<ImmutableBitSet> list = new ArrayList<ImmutableBitSet>();
        for (SqlNode operand : operandList) {
            list.add(SqlValidatorUtil.analyzeGroupExpr(scope, groupAnalyzer, operand));
        }
        return list;
    }

    private static ImmutableBitSet analyzeGroupExpr(SqlValidatorScope scope, GroupAnalyzer groupAnalyzer, SqlNode groupExpr) {
        SqlNode expandedGroupExpr = scope.getValidator().expand(groupExpr, scope);
        switch (expandedGroupExpr.getKind()) {
            case ROW: {
                return ImmutableBitSet.union(SqlValidatorUtil.analyzeGroupTuple(scope, groupAnalyzer, ((SqlCall)expandedGroupExpr).getOperandList()));
            }
            case OTHER: {
                if (!(expandedGroupExpr instanceof SqlNodeList) || ((SqlNodeList)expandedGroupExpr).size() != 0) break;
                return ImmutableBitSet.of();
            }
        }
        int ref = SqlValidatorUtil.lookupGroupExpr(groupAnalyzer, expandedGroupExpr);
        if (expandedGroupExpr instanceof SqlIdentifier) {
            SqlIdentifier expr = (SqlIdentifier)expandedGroupExpr;
            assert (expr.names.size() >= 2);
            String originalRelName = (String)expr.names.get(0);
            String originalFieldName = (String)expr.names.get(1);
            SqlNameMatcher nameMatcher = scope.getValidator().getCatalogReader().nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            scope.resolve(ImmutableList.of(originalRelName), nameMatcher, false, resolved);
            assert (resolved.count() == 1);
            SqlValidatorScope.Resolve resolve = resolved.only();
            RelDataType rowType = resolve.rowType();
            int childNamespaceIndex = resolve.path.steps().get((int)0).i;
            int namespaceOffset = 0;
            if (childNamespaceIndex > 0) {
                SqlValidatorScope ancestorScope = resolve.scope;
                assert (ancestorScope instanceof ListScope);
                List<SqlValidatorNamespace> children = ((ListScope)ancestorScope).getChildren();
                for (int j = 0; j < childNamespaceIndex; ++j) {
                    namespaceOffset += children.get(j).getRowType().getFieldCount();
                }
            }
            RelDataTypeField field = Objects.requireNonNull(nameMatcher.field(rowType, originalFieldName), () -> "field " + originalFieldName + " is not found in " + rowType + " with " + nameMatcher);
            int origPos = namespaceOffset + field.getIndex();
            groupAnalyzer.groupExprProjection.put(origPos, ref);
        }
        return ImmutableBitSet.of(ref);
    }

    private static int lookupGroupExpr(GroupAnalyzer groupAnalyzer, SqlNode expr) {
        for (Ord<SqlNode> node : Ord.zip(groupAnalyzer.groupExprs)) {
            if (!((SqlNode)node.e).equalsDeep(expr, Litmus.IGNORE)) continue;
            return node.i;
        }
        switch (expr.getKind()) {
            case HOP: 
            case TUMBLE: 
            case SESSION: {
                groupAnalyzer.extraExprs.add(expr);
                break;
            }
        }
        groupAnalyzer.groupExprs.add(expr);
        return groupAnalyzer.groupExprs.size() - 1;
    }

    @VisibleForTesting
    public static ImmutableList<ImmutableBitSet> rollup(List<ImmutableBitSet> bitSets) {
        LinkedHashSet<ImmutableBitSet> builder = new LinkedHashSet<ImmutableBitSet>();
        while (true) {
            ImmutableBitSet union = ImmutableBitSet.union(bitSets);
            builder.add(union);
            if (union.isEmpty()) break;
            bitSets = bitSets.subList(0, bitSets.size() - 1);
        }
        return ImmutableList.copyOf(builder);
    }

    @VisibleForTesting
    public static ImmutableList<ImmutableBitSet> cube(List<ImmutableBitSet> bitSets) {
        LinkedHashSet<List<ImmutableBitSet>> builder = new LinkedHashSet<List<ImmutableBitSet>>();
        for (ImmutableBitSet bitSet : bitSets) {
            builder.add(Arrays.asList(bitSet, ImmutableBitSet.of()));
        }
        LinkedHashSet<ImmutableBitSet> flattenedBitSets = new LinkedHashSet<ImmutableBitSet>();
        for (List o : Linq4j.product(builder)) {
            flattenedBitSets.add(ImmutableBitSet.union(o));
        }
        return ImmutableList.copyOf(flattenedBitSets);
    }

    public static @Nullable CalciteSchema.TypeEntry getTypeEntry(CalciteSchema rootSchema, SqlIdentifier typeName) {
        String name;
        List<Object> path;
        if (typeName.isSimple()) {
            path = ImmutableList.of();
            name = typeName.getSimple();
        } else {
            path = Util.skipLast(typeName.names);
            name = Util.last(typeName.names);
        }
        CalciteSchema schema = rootSchema;
        for (String string : path) {
            if (schema == rootSchema && SqlNameMatchers.withCaseSensitive(true).matches(string, schema.getName()) || (schema = schema.getSubSchema(string, true)) != null) continue;
            return null;
        }
        return schema.getType(name, false);
    }

    public static @Nullable CalciteSchema.TableEntry getTableEntry(SqlValidatorCatalogReader catalogReader, List<String> names) {
        for (List<String> schemaPath : catalogReader.getSchemaPaths()) {
            CalciteSchema.TableEntry entry;
            CalciteSchema schema = SqlValidatorUtil.getSchema(catalogReader.getRootSchema(), Iterables.concat(schemaPath, Util.skipLast(names)), catalogReader.nameMatcher());
            if (schema == null || (entry = SqlValidatorUtil.getTableEntryFrom(schema, Util.last(names), catalogReader.nameMatcher().isCaseSensitive())) == null) continue;
            return entry;
        }
        return null;
    }

    public static @Nullable CalciteSchema getSchema(CalciteSchema rootSchema, Iterable<String> schemaPath, SqlNameMatcher nameMatcher) {
        CalciteSchema schema = rootSchema;
        for (String schemaName : schemaPath) {
            if (schema == rootSchema && nameMatcher.matches(schemaName, schema.getName()) || (schema = schema.getSubSchema(schemaName, nameMatcher.isCaseSensitive())) != null) continue;
            return null;
        }
        return schema;
    }

    private static @Nullable CalciteSchema.TableEntry getTableEntryFrom(CalciteSchema schema, String name, boolean caseSensitive) {
        CalciteSchema.TableEntry entry = schema.getTable(name, caseSensitive);
        if (entry == null) {
            entry = schema.getTableBasedOnNullaryFunction(name, caseSensitive);
        }
        return entry;
    }

    public static boolean containsMonotonic(SqlValidatorScope scope) {
        for (SqlValidatorNamespace ns : SqlValidatorUtil.children(scope)) {
            ns = ns.resolve();
            for (String field : ns.getRowType().getFieldNames()) {
                SqlMonotonicity monotonicity = ns.getMonotonicity(field);
                if (monotonicity == null || monotonicity.mayRepeat()) continue;
                return true;
            }
        }
        return false;
    }

    private static List<SqlValidatorNamespace> children(SqlValidatorScope scope) {
        return scope instanceof ListScope ? ((ListScope)scope).getChildren() : ImmutableList.of();
    }

    static boolean containsMonotonic(SelectScope scope, SqlNodeList nodes) {
        for (SqlNode node : nodes) {
            if (scope.getMonotonicity(node).mayRepeat()) continue;
            return true;
        }
        return false;
    }

    public static @Nullable SqlOperator lookupSqlFunctionByID(SqlOperatorTable opTab, SqlIdentifier funName, @Nullable SqlFunctionCategory funcType) {
        if (funName.isSimple()) {
            ArrayList<SqlOperator> list = new ArrayList<SqlOperator>();
            opTab.lookupOperatorOverloads(funName, funcType, SqlSyntax.FUNCTION, list, SqlNameMatchers.withCaseSensitive(funName.isComponentQuoted(0)));
            if (list.size() == 1) {
                return (SqlOperator)list.get(0);
            }
        }
        return null;
    }

    public static Pair<SqlNode, RelDataType> validateExprWithRowType(boolean caseSensitive, SqlOperatorTable operatorTable, RelDataTypeFactory typeFactory, RelDataType rowType, SqlNode expr) {
        String tableName = "_table_";
        SqlSelect select0 = new SqlSelect(SqlParserPos.ZERO, null, new SqlNodeList(Collections.singletonList(expr), SqlParserPos.ZERO), new SqlIdentifier("_table_", SqlParserPos.ZERO), null, null, null, null, null, null, null, null, null);
        CalciteCatalogReader catalogReader = SqlValidatorUtil.createSingleTableCatalogReader(caseSensitive, "_table_", typeFactory, rowType);
        SqlValidatorWithHints validator = SqlValidatorUtil.newValidator(operatorTable, catalogReader, typeFactory, SqlValidator.Config.DEFAULT);
        SqlSelect select = (SqlSelect)validator.validate(select0);
        SqlNodeList selectList = select.getSelectList();
        assert (selectList.size() == 1) : "Expression " + expr + " should be atom expression";
        SqlNode node = selectList.get(0);
        RelDataType nodeType = validator.getValidatedNodeType(select).getFieldList().get(0).getType();
        return Pair.of(node, nodeType);
    }

    public static CalciteCatalogReader createSingleTableCatalogReader(boolean caseSensitive, String tableName, RelDataTypeFactory typeFactory, RelDataType rowType) {
        Properties properties = new Properties();
        properties.put(CalciteConnectionProperty.CASE_SENSITIVE.camelName(), String.valueOf(caseSensitive));
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(properties);
        ExplicitRowTypeTable table = new ExplicitRowTypeTable(rowType);
        Map<String, Table> tableMap = Collections.singletonMap(tableName, table);
        CalciteSchema schema = CalciteSchema.createRootSchema(false, false, "", new ExplicitTableSchema(tableMap));
        return new CalciteCatalogReader(schema, new ArrayList<String>(new ArrayList()), typeFactory, connectionConfig);
    }

    public static FlatAggregate flatten(SqlCall call) {
        return SqlValidatorUtil.flattenRecurse(null, null, null, call);
    }

    private static FlatAggregate flattenRecurse(@Nullable SqlCall filterCall, @Nullable SqlCall distinctCall, @Nullable SqlCall orderCall, SqlCall call) {
        switch (call.getKind()) {
            case FILTER: {
                assert (filterCall == null);
                return SqlValidatorUtil.flattenRecurse(call, distinctCall, orderCall, (SqlCall)call.operand(0));
            }
            case WITHIN_DISTINCT: {
                assert (distinctCall == null);
                return SqlValidatorUtil.flattenRecurse(filterCall, call, orderCall, (SqlCall)call.operand(0));
            }
            case WITHIN_GROUP: {
                assert (orderCall == null);
                return SqlValidatorUtil.flattenRecurse(filterCall, distinctCall, call, (SqlCall)call.operand(0));
            }
        }
        return new FlatAggregate(call, filterCall, distinctCall, orderCall);
    }

    public static boolean isMeasure(SqlNode selectItem) {
        return SqlValidatorUtil.getMeasure(selectItem) != null;
    }

    public static @Nullable SqlNode getMeasure(SqlNode selectItem) {
        return null;
    }

    public static class FlatAggregate {
        public final SqlCall aggregateCall;
        public final @Nullable SqlCall filterCall;
        public final @Nullable SqlNode filter;
        public final @Nullable SqlCall distinctCall;
        public final @Nullable SqlNodeList distinctList;
        public final @Nullable SqlCall orderCall;
        public final @Nullable SqlNodeList orderList;

        FlatAggregate(SqlCall aggregateCall, @Nullable SqlCall filterCall, @Nullable SqlCall distinctCall, @Nullable SqlCall orderCall) {
            this.aggregateCall = Objects.requireNonNull(aggregateCall, "aggregateCall");
            Preconditions.checkArgument(filterCall == null || filterCall.getKind() == SqlKind.FILTER);
            Preconditions.checkArgument(distinctCall == null || distinctCall.getKind() == SqlKind.WITHIN_DISTINCT);
            Preconditions.checkArgument(orderCall == null || orderCall.getKind() == SqlKind.WITHIN_GROUP);
            this.filterCall = filterCall;
            this.filter = filterCall == null ? null : filterCall.operand(1);
            this.distinctCall = distinctCall;
            this.distinctList = distinctCall == null ? null : (SqlNodeList)distinctCall.operand(1);
            this.orderCall = orderCall;
            this.orderList = orderCall == null ? null : (SqlNodeList)orderCall.operand(1);
        }
    }

    private static class ExplicitTableSchema
    extends AbstractSchema {
        private final Map<String, Table> tableMap;

        ExplicitTableSchema(Map<String, Table> tableMap) {
            this.tableMap = Objects.requireNonNull(tableMap, "tableMap");
        }

        @Override
        protected Map<String, Table> getTableMap() {
            return this.tableMap;
        }
    }

    private static class ExplicitRowTypeTable
    extends AbstractTable {
        private final RelDataType rowType;

        ExplicitRowTypeTable(RelDataType rowType) {
            this.rowType = Objects.requireNonNull(rowType, "rowType");
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return this.rowType;
        }
    }

    static class GroupAnalyzer {
        final List<SqlNode> extraExprs = new ArrayList<SqlNode>();
        final List<SqlNode> measureExprs = new ArrayList<SqlNode>();
        final List<SqlNode> groupExprs = new ArrayList<SqlNode>();
        final Map<Integer, Integer> groupExprProjection = new HashMap<Integer, Integer>();
        final List<ImmutableBitSet> flatGroupSets = new ArrayList<ImmutableBitSet>();

        GroupAnalyzer() {
        }

        AggregatingSelectScope.Resolved finish() {
            return new AggregatingSelectScope.Resolved(this.extraExprs, this.measureExprs, this.groupExprs, this.flatGroupSets, this.groupExprProjection);
        }
    }

    public static interface Suggester {
        public String apply(@Nullable String var1, int var2, int var3);
    }

    @Deprecated
    public static class DeepCopier
    extends SqlScopedShuttle {
        DeepCopier(SqlValidatorScope scope) {
            super(scope);
        }

        public static @Nullable SqlNodeList copy(SqlValidatorScope scope, SqlNodeList list) {
            return (SqlNodeList)list.accept(new DeepCopier(scope));
        }

        @Override
        public SqlNode visit(SqlNodeList list) {
            SqlNodeList copy = new SqlNodeList(list.getParserPosition());
            for (SqlNode node : list) {
                copy.add(node.accept(this));
            }
            return copy;
        }

        @Override
        protected SqlNode visitScoped(SqlCall call) {
            SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler(call, true);
            call.getOperator().acceptCall(this, call, false, argHandler);
            return argHandler.result();
        }

        @Override
        public SqlNode visit(SqlLiteral literal) {
            return SqlNode.clone(literal);
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            SqlValidator validator = this.getScope().getValidator();
            SqlCall call = validator.makeNullaryCall(id);
            if (call != null) {
                return call;
            }
            return this.getScope().fullyQualify((SqlIdentifier)id).identifier;
        }

        @Override
        public SqlNode visit(SqlDataTypeSpec type) {
            return SqlNode.clone(type);
        }

        @Override
        public SqlNode visit(SqlDynamicParam param) {
            return SqlNode.clone(param);
        }

        @Override
        public SqlNode visit(SqlIntervalQualifier intervalQualifier) {
            return SqlNode.clone(intervalQualifier);
        }
    }
}

