/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlRichDescribeFunction
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DESCRIBE FUNCTION", SqlKind.OTHER);
    protected final SqlIdentifier functionNameIdentifier;
    private final boolean isExtended;

    public SqlRichDescribeFunction(SqlParserPos pos, SqlIdentifier functionNameIdentifier, boolean isExtended) {
        super(pos);
        this.functionNameIdentifier = functionNameIdentifier;
        this.isExtended = isExtended;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.functionNameIdentifier);
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public String[] fullFunctionName() {
        return this.functionNameIdentifier.names.toArray(new String[0]);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DESCRIBE FUNCTION");
        if (this.isExtended) {
            writer.keyword("EXTENDED");
        }
        this.functionNameIdentifier.unparse(writer, leftPrec, rightPrec);
    }
}

