/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch.runtimefilter;

import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ProjectionCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.typeutils.RowTypeUtils;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.operators.runtimefilter.LocalRuntimeFilterBuilderOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecLocalRuntimeFilterBuilder
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData> {
    private final int[] buildIndices;
    private final int estimatedRowCount;
    private final int maxRowCount;

    public BatchExecLocalRuntimeFilterBuilder(ReadableConfig tableConfig, List<InputProperty> inputProperties, LogicalType outputType, String description, int[] buildIndices, int estimatedRowCount, int maxRowCount) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecLocalRuntimeFilterBuilder.class), ExecNodeContext.newPersistedConfig(BatchExecLocalRuntimeFilterBuilder.class, tableConfig), inputProperties, outputType, description);
        this.buildIndices = buildIndices;
        this.estimatedRowCount = estimatedRowCount;
        this.maxRowCount = maxRowCount;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType buildType = (RowType)inputEdge.getOutputType();
        GeneratedProjection inputProj = ProjectionCodeGenerator.generateProjection(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), "LocalRuntimeFilterBuilderProjection", buildType, RowTypeUtils.projectRowType(buildType, this.buildIndices), this.buildIndices);
        SimpleOperatorFactory factory = SimpleOperatorFactory.of((StreamOperator)new LocalRuntimeFilterBuilderOperator(inputProj, this.estimatedRowCount, this.maxRowCount));
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationName(config), this.createTransformationDescription(config), factory, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), 0L, false);
    }
}

