/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.async.AsyncWaitOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.codegen.AsyncCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AsyncScalarUtil;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtils;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.calc.async.AsyncFunctionRunner;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecAsyncCalc
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    public static final String ASYNC_CALC_TRANSFORMATION = "async-calc";
    public static final String FIELD_NAME_PROJECTION = "projection";
    @JsonProperty(value="projection")
    private final List<RexNode> projection;

    public CommonExecAsyncCalc(int id, ExecNodeContext context, ReadableConfig persistedConfig, List<RexNode> projection, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.projection = (List)Preconditions.checkNotNull(projection);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        return this.createAsyncOneInputTransformation(inputTransform, config, planner.getFlinkContext().getClassLoader());
    }

    private OneInputTransformation<RowData, RowData> createAsyncOneInputTransformation(Transformation<RowData> inputTransform, ExecNodeConfig config, ClassLoader classLoader) {
        List asyncRexCalls = this.projection.stream().filter(x -> x instanceof RexCall).map(x -> (RexCall)x).collect(Collectors.toList());
        List forwardedFields = this.projection.stream().filter(x -> x instanceof RexInputRef).map(x -> ((RexInputRef)x).getIndex()).collect(Collectors.toList());
        ExecEdge inputEdge = this.getInputEdges().get(0);
        RowType inputRowType = RowType.of((LogicalType[])inputEdge.getOutputType().getChildren().toArray(new LogicalType[0]));
        List forwardedFieldsLogicalTypes = forwardedFields.stream().map(inputRowType.getChildren()::get).collect(Collectors.toList());
        List asyncCallLogicalTypes = asyncRexCalls.stream().map(node -> FlinkTypeFactory.toLogicalType(node.getType())).collect(Collectors.toList());
        ArrayList fieldsLogicalTypes = new ArrayList();
        fieldsLogicalTypes.addAll(forwardedFieldsLogicalTypes);
        fieldsLogicalTypes.addAll(asyncCallLogicalTypes);
        InternalTypeInfo asyncOperatorResultTypeInfo = InternalTypeInfo.ofFields((LogicalType[])fieldsLogicalTypes.toArray(new LogicalType[0]));
        OneInputStreamOperatorFactory<RowData, RowData> factory = this.getAsyncFunctionOperator(config, classLoader, inputRowType);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(ASYNC_CALC_TRANSFORMATION, config), factory, asyncOperatorResultTypeInfo, inputTransform.getParallelism(), false);
    }

    private OneInputStreamOperatorFactory<RowData, RowData> getAsyncFunctionOperator(ExecNodeConfig config, ClassLoader classLoader, RowType inputRowType) {
        RowType resultTypeInfo = RowType.of((LogicalType[])((LogicalType[])this.projection.stream().map(node -> FlinkTypeFactory.toLogicalType(node.getType())).toArray(LogicalType[]::new)));
        GeneratedFunction<AsyncFunction<RowData, RowData>> generatedFunction = AsyncCodeGenerator.generateFunction("AsyncScalarFunction", inputRowType, resultTypeInfo, this.projection, true, config, classLoader);
        AsyncFunctionRunner func = new AsyncFunctionRunner(generatedFunction);
        FunctionCallUtils.AsyncOptions options = AsyncScalarUtil.getAsyncOptions(config);
        return new AsyncWaitOperatorFactory((AsyncFunction)func, options.asyncTimeout, options.asyncBufferCapacity, options.asyncOutputMode, AsyncScalarUtil.getResultRetryStrategy(config));
    }
}

