/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.SessionWindowSpec;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecWindowTableFunction;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.WindowTableFunctionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.groupwindow.assigners.GroupWindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.operator.UnalignedWindowTableFunctionOperator;
import org.apache.flink.table.runtime.operators.window.tvf.operator.WindowTableFunctionOperatorBase;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-window-table-function", version=1, consumedOptions={"table.local-time-zone"}, producedTransformations={"window"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecWindowTableFunction
extends CommonExecWindowTableFunction
implements StreamExecNode<RowData> {
    public StreamExecWindowTableFunction(ReadableConfig tableConfig, TimeAttributeWindowingStrategy windowingStrategy, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecWindowTableFunction.class), ExecNodeContext.newPersistedConfig(StreamExecWindowTableFunction.class, tableConfig), windowingStrategy, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecWindowTableFunction(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="windowing") TimeAttributeWindowingStrategy windowingStrategy, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, windowingStrategy, inputProperties, outputType, description);
    }

    @Override
    protected Transformation<RowData> translateWithUnalignedWindow(PlannerBase planner, ExecNodeConfig config, RowType inputRowType, Transformation<RowData> inputTransform) {
        WindowTableFunctionOperatorBase windowTableFunctionOperator = this.createUnalignedWindowTableFunctionOperator(config, inputRowType);
        OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta("window", config), windowTableFunctionOperator, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism(), false);
        int[] partitionKeys = this.extractPartitionKeys(this.windowingStrategy.getWindow());
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), partitionKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)inputRowType));
        transform.setStateKeySelector((KeySelector)selector);
        transform.setStateKeyType((TypeInformation)selector.getProducedType());
        return transform;
    }

    private int[] extractPartitionKeys(WindowSpec window) {
        Preconditions.checkState((boolean)(window instanceof SessionWindowSpec), (Object)"Only support unaligned window with session window now.");
        return ((SessionWindowSpec)window).getPartitionKeyIndices();
    }

    private WindowTableFunctionOperatorBase createUnalignedWindowTableFunctionOperator(ExecNodeConfig config, RowType inputRowType) {
        GroupWindowAssigner<TimeWindow> windowAssigner = WindowTableFunctionUtil.createWindowAssigner(this.windowingStrategy);
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone((LogicalType)this.windowingStrategy.getTimeAttributeType(), (ZoneId)TableConfigUtils.getLocalTimeZone(config));
        return new UnalignedWindowTableFunctionOperator(windowAssigner, windowAssigner.getWindowSerializer(new ExecutionConfig()), (TypeSerializer)new RowDataSerializer(inputRowType), this.windowingStrategy.getTimeAttributeIndex(), shiftTimeZone);
    }
}

