/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sinks;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.legacy.table.sinks.RetractStreamTableSink;
import org.apache.flink.legacy.table.sinks.StreamTableSink;
import org.apache.flink.legacy.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.DefaultSqlFactory;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.legacy.api.TableSchema;
import org.apache.flink.table.legacy.api.Types;
import org.apache.flink.table.legacy.sinks.OverwritableTableSink;
import org.apache.flink.table.legacy.sinks.PartitionableTableSink;
import org.apache.flink.table.legacy.sinks.TableSink;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.table.utils.TypeMappingUtils;
import org.apache.flink.types.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TableSinkUtils$ {
    public static TableSinkUtils$ MODULE$;

    static {
        new TableSinkUtils$();
    }

    public void validateTableSink(SinkModifyOperation sinkOperation, ObjectIdentifier sinkIdentifier, TableSink<?> sink, Seq<String> partitionKeys) {
        TableSink<?> tableSink;
        Map staticPartitions;
        if (partitionKeys.nonEmpty()) {
            TableSink<?> tableSink2 = sink;
            if (tableSink2 instanceof PartitionableTableSink) {
            } else {
                throw new ValidationException(new StringBuilder(67).append("We need PartitionableTableSink to write data to").append(" partitioned table: ").append(sinkIdentifier).toString());
            }
        }
        if ((staticPartitions = sinkOperation.getStaticPartitions()) != null && !staticPartitions.isEmpty()) {
            ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(staticPartitions).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)p -> {
                TableSinkUtils$.$anonfun$validateTableSink$2(partitionKeys, sinkIdentifier, p);
                return BoxedUnit.UNIT;
            });
        }
        if ((tableSink = sink) instanceof OverwritableTableSink) {
            OverwritableTableSink overwritableTableSink = (OverwritableTableSink)tableSink;
            overwritableTableSink.setOverwrite(sinkOperation.isOverwrite());
            return;
        }
        Predef$.MODULE$.assert(!sinkOperation.isOverwrite(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("INSERT OVERWRITE requires ").append(OverwritableTableSink.class.getSimpleName()).append(" but actually got ").append(sink.getClass().getName()).toString());
    }

    public TableSchema inferSinkPhysicalSchema(RowType queryLogicalType, TableSink<?> sink) {
        boolean bl;
        TableSink<?> tableSink = sink;
        if (tableSink instanceof RetractStreamTableSink ? true : tableSink instanceof UpsertStreamTableSink) {
            bl = true;
        } else if (tableSink instanceof StreamTableSink) {
            bl = false;
        } else if (tableSink instanceof DataStreamTableSink) {
            DataStreamTableSink dataStreamTableSink = (DataStreamTableSink)tableSink;
            bl = dataStreamTableSink.withChangeFlag();
        } else {
            throw new MatchError(tableSink);
        }
        boolean withChangeFlag = bl;
        return this.inferSinkPhysicalSchema(sink.getConsumedDataType(), queryLogicalType, withChangeFlag);
    }

    public TableSchema inferSinkPhysicalSchema(DataType consumedDataType, RowType queryLogicalType, boolean withChangeFlag) {
        DataType requestedOutputType = this.inferSinkPhysicalDataType(consumedDataType, queryLogicalType, withChangeFlag);
        if (LogicalTypeChecks.isCompositeType((LogicalType)requestedOutputType.getLogicalType())) {
            TypeInformation typeInformation = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)requestedOutputType);
            if (typeInformation instanceof PojoTypeInfo) {
                PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
                return this.expandPojoTypeToSchema(pojoTypeInfo, queryLogicalType);
            }
            return TableSchema.fromResolvedSchema((ResolvedSchema)DataTypeUtils.expandCompositeTypeToSchema((DataType)requestedOutputType), (SqlFactory)DefaultSqlFactory.INSTANCE);
        }
        return TableSchema.builder().field("f0", requestedOutputType).build();
    }

    private TableSchema expandPojoTypeToSchema(PojoTypeInfo<?> pojo, RowType queryLogicalType) {
        List fieldNames = queryLogicalType.getFieldNames();
        Buffer reorderedFields = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldNames).map((Function1 & Serializable & scala.Serializable)name -> {
            DataType dataType;
            int index = pojo.getFieldIndex(name);
            if (index < 0) {
                throw new TableException(new StringBuilder(17).append((String)name).append(" is not found in ").append(pojo.toString()).toString());
            }
            TypeInformation fieldTypeInfo = pojo.getPojoFieldAt(index).getTypeInformation();
            TypeInformation typeInformation = fieldTypeInfo;
            if (typeInformation instanceof PojoTypeInfo) {
                PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
                RowType nestedLogicalType = (RowType)((RowType.RowField)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(queryLogicalType.getFields()).apply(index)).getType();
                dataType = MODULE$.expandPojoTypeToSchema(pojoTypeInfo, nestedLogicalType).toRowDataType();
            } else {
                dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)fieldTypeInfo);
            }
            DataType fieldDataType = dataType;
            return DataTypes.FIELD((String)name, (DataType)fieldDataType);
        }, Buffer$.MODULE$.canBuildFrom());
        return TableSchema.fromResolvedSchema((ResolvedSchema)DataTypeUtils.expandCompositeTypeToSchema((DataType)DataTypes.ROW((DataTypes.Field[])((DataTypes.Field[])reorderedFields.toArray(ClassTag$.MODULE$.apply(DataTypes.Field.class))))), (SqlFactory)DefaultSqlFactory.INSTANCE);
    }

    /*
     * Unable to fully structure code
     */
    public DataType inferSinkPhysicalDataType(DataType consumedDataType, RowType queryLogicalType, boolean withChangeFlag) {
        block11: {
            block10: {
                var8_4 = consumedDataType.getLogicalType();
                if (var8_4 instanceof LegacyTypeInformationType) {
                    var9_5 = (LegacyTypeInformationType)var8_4;
                    v0 = new Some((Object)var9_5.getTypeInformation());
                } else {
                    v0 = consumedTypeInfo = None$.MODULE$;
                }
                if (consumedTypeInfo.isEmpty()) {
                    return consumedDataType;
                }
                if (!withChangeFlag) ** GOTO lbl33
                var11_7 = (TypeInformation)consumedTypeInfo.get();
                if (!(var11_7 instanceof TypeInformation) || !(var11_7 instanceof CaseClassTypeInfo)) break block10;
                var12_8 = (CaseClassTypeInfo)var11_7;
                v1 = var12_8.getTypeClass();
                var13_9 = scala.Tuple2.class;
                if (v1 != null ? v1.equals(var13_9) == false : var13_9 != null) break block10;
                v2 = var12_8.getTypeAt(0);
                var14_10 = Types.BOOLEAN();
                if (v2 != null ? v2.equals(var14_10) == false : var14_10 != null) break block10;
                v3 = var12_8.getTypeAt(1);
                break block11;
            }
            if (!(var11_7 instanceof TypeInformation) || !(var11_7 instanceof TupleTypeInfo)) ** GOTO lbl-1000
            var15_11 = (TupleTypeInfo)var11_7;
            v4 = var15_11.getTypeClass();
            var16_12 = Tuple2.class;
            if (v4 != null ? v4.equals(var16_12) == false : var16_12 != null) ** GOTO lbl-1000
            v5 = var15_11.getTypeAt(0);
            var17_13 = Types.BOOLEAN();
            if (!(v5 != null ? v5.equals(var17_13) == false : var17_13 != null)) {
                v3 = var15_11.getTypeAt(1);
            } else lbl-1000:
            // 3 sources

            {
                throw new TableException(new StringBuilder(46).append("Don't support ").append(consumedDataType).append(" conversion for the retract sink").toString());
lbl33:
                // 1 sources

                v3 = (TypeInformation)consumedTypeInfo.get();
            }
        }
        requestedTypeInfo = v3;
        var18_15 = false;
        var19_16 = null;
        var20_17 = requestedTypeInfo;
        if (var20_17 instanceof GenericTypeInfo) {
            var18_15 = true;
            var19_16 = (GenericTypeInfo)var20_17;
            v6 = var19_16.getTypeClass();
            var21_18 = Row.class;
            if (!(v6 != null ? v6.equals(var21_18) == false : var21_18 != null)) {
                return (DataType)TypeConversions.fromLogicalToDataType((LogicalType)queryLogicalType).bridgedTo(Row.class);
            }
        }
        if (var18_15) {
            v7 = var19_16.getTypeClass();
            var22_19 = RowData.class;
            if (!(v7 != null ? v7.equals(var22_19) == false : var22_19 != null)) {
                return (DataType)TypeConversions.fromLogicalToDataType((LogicalType)queryLogicalType).bridgedTo(RowData.class);
            }
        }
        if (var20_17 instanceof InternalTypeInfo) {
            var23_20 = (InternalTypeInfo)var20_17;
            fields = (DataTypes.Field[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])var23_20.toRowFieldNames())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])var23_20.toRowFieldTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.Tuple2.class))))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$inferSinkPhysicalDataType$1(scala.Tuple2 ), (Lscala/Tuple2;)Lorg/apache/flink/table/api/DataTypes$Field;)(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataTypes.Field.class)));
            return (DataType)DataTypes.ROW((DataTypes.Field[])fields).bridgedTo(RowData.class);
        }
        return TypeConversions.fromLegacyInfoToDataType((TypeInformation)requestedTypeInfo);
    }

    public void validateLogicalPhysicalTypesCompatible(CatalogTable catalogTable, TableSink<?> sink, RowType queryLogicalType) {
        TableSchema logicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)catalogTable.getSchema());
        TableSchema physicalSchema = this.inferSinkPhysicalSchema(queryLogicalType, sink);
        if (logicalSchema.getFieldCount() != physicalSchema.getFieldCount()) {
            throw new ValidationException(new StringBuilder(151).append("The field count of logical schema of the table does not match with the field count of physical schema\n. ").append("The logical schema: [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logicalSchema.getFieldDataTypes())).mkString(",")).append("]\n").append("The physical schema: [").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])physicalSchema.getFieldDataTypes())).mkString(",")).append("].").toString());
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), logicalSchema.getFieldCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            DataType logicalFieldType = DataTypeUtils.transform((DataType)logicalSchema.getFieldDataTypes()[i], (TypeTransformation[])new TypeTransformation[]{TypeTransformations.toNullable()});
            String logicalFieldName = logicalSchema.getFieldNames()[i];
            DataType physicalFieldType = DataTypeUtils.transform((DataType)physicalSchema.getFieldDataTypes()[i], (TypeTransformation[])new TypeTransformation[]{TypeTransformations.toNullable()});
            String physicalFieldName = physicalSchema.getFieldNames()[i];
            TypeMappingUtils.checkPhysicalLogicalTypeCompatible((LogicalType)physicalFieldType.getLogicalType(), (LogicalType)logicalFieldType.getLogicalType(), (String)physicalFieldName, (String)logicalFieldName, (boolean)false);
        });
    }

    public static final /* synthetic */ void $anonfun$validateTableSink$2(Seq partitionKeys$1, ObjectIdentifier sinkIdentifier$1, String p) {
        if (!partitionKeys$1.contains((Object)p)) {
            throw new ValidationException(new StringBuilder(77).append("Static partition column ").append(p).append(" should be in the partition").append(" fields list ").append(partitionKeys$1).append(" for Table(").append(sinkIdentifier$1).append(").").toString());
        }
    }

    public static final /* synthetic */ DataTypes.Field $anonfun$inferSinkPhysicalDataType$1(scala.Tuple2 x0$1) {
        scala.Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String n = (String)tuple2._1();
            LogicalType t = (LogicalType)tuple2._2();
            return DataTypes.FIELD((String)n, (DataType)TypeConversions.fromLogicalToDataType((LogicalType)t));
        }
        throw new MatchError((Object)tuple2);
    }

    private TableSinkUtils$() {
        MODULE$ = this;
    }
}

