/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.node;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.node.ValueNode;

public final class BooleanNode
extends ValueNode {
    public static final BooleanNode TRUE = new BooleanNode();
    public static final BooleanNode FALSE = new BooleanNode();

    private BooleanNode() {
    }

    public static BooleanNode getTrue() {
        return TRUE;
    }

    public static BooleanNode getFalse() {
        return FALSE;
    }

    public static BooleanNode valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public JsonToken asToken() {
        return this == TRUE ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public boolean getBooleanValue() {
        return this == TRUE;
    }

    @Override
    public String asText() {
        return this == TRUE ? "true" : "false";
    }

    @Override
    public boolean asBoolean() {
        return this == TRUE;
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return this == TRUE;
    }

    @Override
    public int asInt(int defaultValue) {
        return this == TRUE ? 1 : 0;
    }

    @Override
    public long asLong(long defaultValue) {
        return this == TRUE ? 1L : 0L;
    }

    @Override
    public double asDouble(double defaultValue) {
        return this == TRUE ? 1.0 : 0.0;
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
        jg.writeBoolean(this == TRUE);
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }
}

