/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import java.io.Serializable;
import java.util.Optional;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.functions.TableSemantics;
import org.apache.flink.table.runtime.operators.process.RuntimeChangelogMode;
import org.apache.flink.table.types.DataType;

public class RuntimeTableSemantics
implements TableSemantics,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String argName;
    private final int inputIndex;
    private final DataType dataType;
    private final int[] partitionByColumns;
    private final RuntimeChangelogMode consumedChangelogMode;
    private final boolean passColumnsThrough;
    private final boolean hasSetSemantics;
    private final int timeColumn;
    private transient ChangelogMode changelogMode;

    public RuntimeTableSemantics(String argName, int inputIndex, DataType dataType, int[] partitionByColumns, RuntimeChangelogMode consumedChangelogMode, boolean passColumnsThrough, boolean hasSetSemantics, int timeColumn) {
        this.argName = argName;
        this.inputIndex = inputIndex;
        this.dataType = dataType;
        this.partitionByColumns = partitionByColumns;
        this.consumedChangelogMode = consumedChangelogMode;
        this.passColumnsThrough = passColumnsThrough;
        this.hasSetSemantics = hasSetSemantics;
        this.timeColumn = timeColumn;
    }

    public String getArgName() {
        return this.argName;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public boolean passColumnsThrough() {
        return this.passColumnsThrough;
    }

    public boolean hasSetSemantics() {
        return this.hasSetSemantics;
    }

    public ChangelogMode getChangelogMode() {
        if (this.changelogMode == null) {
            this.changelogMode = this.consumedChangelogMode.deserialize();
        }
        return this.changelogMode;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public int[] partitionByColumns() {
        return this.partitionByColumns;
    }

    public int[] orderByColumns() {
        return new int[0];
    }

    public int timeColumn() {
        return this.timeColumn;
    }

    public Optional<ChangelogMode> changelogMode() {
        return Optional.of(this.getChangelogMode());
    }
}

