/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.functions;

import java.time.LocalDate;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.examples.java.functions.InternalRowMergerFunction;
import org.apache.flink.table.examples.java.functions.LastDatedValueFunction;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.types.Row;

public class AdvancedFunctionsExample {
    public static void main(String[] args) throws Exception {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)settings);
        AdvancedFunctionsExample.executeLastDatedValueFunction(env);
        AdvancedFunctionsExample.executeInternalRowMergerFunction(env);
    }

    private static void executeLastDatedValueFunction(TableEnvironment env) {
        Table customers = env.fromValues((AbstractDataType)DataTypes.of((String)"ROW<name STRING, order_date DATE, item_count INT>"), new Object[]{Row.of((Object[])new Object[]{"Guillermo Smith", LocalDate.parse("2020-12-01"), 3}), Row.of((Object[])new Object[]{"Guillermo Smith", LocalDate.parse("2020-12-05"), 5}), Row.of((Object[])new Object[]{"Valeria Mendoza", LocalDate.parse("2020-03-23"), 4}), Row.of((Object[])new Object[]{"Valeria Mendoza", LocalDate.parse("2020-06-02"), 10}), Row.of((Object[])new Object[]{"Leann Holloway", LocalDate.parse("2020-05-26"), 9}), Row.of((Object[])new Object[]{"Leann Holloway", LocalDate.parse("2020-05-27"), null}), Row.of((Object[])new Object[]{"Brandy Sanders", LocalDate.parse("2020-10-14"), 1}), Row.of((Object[])new Object[]{"John Turner", LocalDate.parse("2020-10-02"), 12}), Row.of((Object[])new Object[]{"Ellen Ortega", LocalDate.parse("2020-06-18"), 100})});
        env.createTemporaryView("customers", customers);
        env.createTemporarySystemFunction("LastDatedValueFunction", LastDatedValueFunction.class);
        env.executeSql("SELECT name, LastDatedValueFunction(item_count, order_date) FROM customers GROUP BY name").print();
        env.dropTemporaryView("customers");
    }

    private static void executeInternalRowMergerFunction(TableEnvironment env) {
        Table customers = env.fromValues((AbstractDataType)DataTypes.of((String)"ROW<name STRING, data1 ROW<birth_date DATE>, data2 ROW<city STRING, phone STRING>>"), new Object[]{Row.of((Object[])new Object[]{"Guillermo Smith", Row.of((Object[])new Object[]{LocalDate.parse("1992-12-12")}), Row.of((Object[])new Object[]{"New Jersey", "816-443-8010"})}), Row.of((Object[])new Object[]{"Valeria Mendoza", Row.of((Object[])new Object[]{LocalDate.parse("1970-03-28")}), Row.of((Object[])new Object[]{"Los Angeles", "928-264-9662"})}), Row.of((Object[])new Object[]{"Leann Holloway", Row.of((Object[])new Object[]{LocalDate.parse("1989-05-21")}), Row.of((Object[])new Object[]{"Eugene", "614-889-6038"})})});
        env.createTemporaryView("customers", customers);
        env.createTemporarySystemFunction("InternalRowMergerFunction", InternalRowMergerFunction.class);
        env.executeSql("SELECT name, InternalRowMergerFunction(data1, data2) FROM customers").print();
        env.dropTemporaryView("customers");
    }
}

