/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.ArgumentTrait;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.annotation.StateHint;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.DataTypeTemplate;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.types.Row;

@Internal
final class FunctionTemplate {
    @Nullable
    private final FunctionSignatureTemplate signatureTemplate;
    @Nullable
    private final FunctionResultTemplate.FunctionStateTemplate stateTemplate;
    @Nullable
    private final FunctionResultTemplate.FunctionOutputTemplate outputTemplate;

    private FunctionTemplate(@Nullable FunctionSignatureTemplate signatureTemplate, @Nullable FunctionResultTemplate.FunctionStateTemplate stateTemplate, @Nullable FunctionResultTemplate.FunctionOutputTemplate outputTemplate) {
        this.signatureTemplate = signatureTemplate;
        this.stateTemplate = stateTemplate;
        this.outputTemplate = outputTemplate;
    }

    static FunctionTemplate fromAnnotation(DataTypeFactory typeFactory, FunctionHint hint) {
        return new FunctionTemplate(FunctionTemplate.createSignatureTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::input), FunctionTemplate.defaultAsNull(hint, FunctionHint::argumentNames), FunctionTemplate.defaultAsNull(hint, FunctionHint::argument), FunctionTemplate.defaultAsNull(hint, FunctionHint::arguments), hint.isVarArgs()), FunctionTemplate.createStateTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::accumulator), FunctionTemplate.defaultAsNull(hint, FunctionHint::state)), FunctionTemplate.createOutputTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::output)));
    }

    static FunctionTemplate fromAnnotation(DataTypeFactory typeFactory, ProcedureHint hint) {
        return new FunctionTemplate(FunctionTemplate.createSignatureTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, ProcedureHint::input), FunctionTemplate.defaultAsNull(hint, ProcedureHint::argumentNames), FunctionTemplate.defaultAsNull(hint, ProcedureHint::argument), FunctionTemplate.defaultAsNull(hint, ProcedureHint::arguments), hint.isVarArgs()), FunctionTemplate.createStateTemplate(typeFactory, null, null), FunctionTemplate.createOutputTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, ProcedureHint::output)));
    }

    @Nullable
    static FunctionResultTemplate.FunctionOutputTemplate createOutputTemplate(DataTypeFactory typeFactory, @Nullable DataTypeHint hint) {
        DataTypeTemplate template;
        if (hint == null) {
            return null;
        }
        try {
            template = DataTypeTemplate.fromAnnotation(typeFactory, hint);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in data type hint annotation.", new Object[0]);
        }
        if (template.dataType != null) {
            return FunctionResultTemplate.ofOutput(template.dataType);
        }
        throw ExtractionUtils.extractionError("Data type hint does not specify a data type for use as function result.", new Object[0]);
    }

    @Nullable
    static FunctionResultTemplate.FunctionStateTemplate createStateTemplate(DataTypeFactory typeFactory, @Nullable DataTypeHint accumulatorHint, @Nullable StateHint[] stateHints) {
        if (accumulatorHint == null && stateHints == null) {
            return null;
        }
        if (accumulatorHint != null && stateHints != null) {
            throw ExtractionUtils.extractionError("State hints and accumulator cannot be declared in the same function hint. Use either one or the other.", new Object[0]);
        }
        LinkedHashMap<String, FunctionResultTemplate.FunctionStateTemplate.StateInfoTemplate> state = new LinkedHashMap<String, FunctionResultTemplate.FunctionStateTemplate.StateInfoTemplate>();
        if (accumulatorHint != null) {
            state.put("acc", FunctionResultTemplate.FunctionStateTemplate.StateInfoTemplate.of(FunctionTemplate.createStateDataType(typeFactory, accumulatorHint, "accumulator"), null));
            return FunctionResultTemplate.ofState(state);
        }
        IntStream.range(0, stateHints.length).forEach(pos -> {
            StateHint hint = stateHints[pos];
            state.put(hint.name(), FunctionResultTemplate.FunctionStateTemplate.StateInfoTemplate.of(FunctionTemplate.createStateDataType(typeFactory, hint.type(), "state entry"), hint));
        });
        return FunctionResultTemplate.ofState(state);
    }

    @Nullable
    FunctionSignatureTemplate getSignatureTemplate() {
        return this.signatureTemplate;
    }

    @Nullable
    FunctionResultTemplate getStateTemplate() {
        return this.stateTemplate;
    }

    @Nullable
    FunctionResultTemplate getOutputTemplate() {
        return this.outputTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionTemplate template = (FunctionTemplate)o;
        return Objects.equals(this.signatureTemplate, template.signatureTemplate) && Objects.equals(this.stateTemplate, template.stateTemplate) && Objects.equals(this.outputTemplate, template.outputTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.signatureTemplate, this.stateTemplate, this.outputTemplate);
    }

    private static <H extends Annotation> H getDefaultAnnotation(Class<H> hClass) {
        return DefaultAnnotationHelper.class.getAnnotation(hClass);
    }

    private static <T> T defaultAsNull(FunctionHint hint, Function<FunctionHint, T> accessor) {
        return FunctionTemplate.defaultAsNull(hint, FunctionTemplate.getDefaultAnnotation(FunctionHint.class), accessor);
    }

    private static <T> T defaultAsNull(ProcedureHint hint, Function<ProcedureHint, T> accessor) {
        return FunctionTemplate.defaultAsNull(hint, FunctionTemplate.getDefaultAnnotation(ProcedureHint.class), accessor);
    }

    private static <T> T defaultAsNull(ArgumentHint hint, Function<ArgumentHint, T> accessor) {
        return FunctionTemplate.defaultAsNull(hint, FunctionTemplate.getDefaultAnnotation(ArgumentHint.class), accessor);
    }

    private static <T, H extends Annotation> T defaultAsNull(H hint, H defaultHint, Function<H, T> accessor) {
        T actualValue;
        T defaultValue = accessor.apply(defaultHint);
        if (Objects.deepEquals(defaultValue, actualValue = accessor.apply(hint))) {
            return null;
        }
        return actualValue;
    }

    @Nullable
    private static FunctionSignatureTemplate createSignatureTemplate(DataTypeFactory typeFactory, @Nullable DataTypeHint[] inputs, @Nullable String[] argumentNames, @Nullable ArgumentHint[] singularArgumentHints, @Nullable ArgumentHint[] pluralArgumentHints, boolean isVarArg) {
        String[] argumentHintNames;
        ArgumentTrait[][] argumentTraits;
        boolean[] argumentOptionals;
        DataTypeHint[] argumentHintTypes;
        if (singularArgumentHints != null && pluralArgumentHints != null) {
            throw ExtractionUtils.extractionError("Argument hints should only be defined once in the same function hint.", new Object[0]);
        }
        ArgumentHint[] argumentHints = singularArgumentHints != null ? singularArgumentHints : pluralArgumentHints;
        if (argumentHints != null && inputs != null) {
            throw ExtractionUtils.extractionError("Argument and input hints cannot be declared in the same function hint. Use either one or the other.", new Object[0]);
        }
        if (argumentHints != null) {
            argumentHintTypes = new DataTypeHint[argumentHints.length];
            argumentOptionals = new boolean[argumentHints.length];
            argumentTraits = new ArgumentTrait[argumentHints.length][];
            argumentHintNames = new String[argumentHints.length];
            boolean allArgumentNamesNotSet = true;
            for (int i2 = 0; i2 < argumentHints.length; ++i2) {
                ArgumentHint argumentHint = argumentHints[i2];
                argumentHintNames[i2] = FunctionTemplate.defaultAsNull(argumentHint, ArgumentHint::name);
                argumentHintTypes[i2] = FunctionTemplate.defaultAsNull(argumentHint, ArgumentHint::type);
                argumentOptionals[i2] = argumentHint.isOptional();
                argumentTraits[i2] = argumentHint.value();
                if (argumentHintNames[i2] != null) {
                    allArgumentNamesNotSet = false;
                    continue;
                }
                if (allArgumentNamesNotSet) continue;
                throw ExtractionUtils.extractionError("Argument names in function hint must be either fully set or not set at all.", new Object[0]);
            }
            if (allArgumentNamesNotSet) {
                argumentHintNames = null;
            }
        } else if (inputs != null) {
            argumentHintTypes = inputs;
            argumentHintNames = argumentNames;
            argumentOptionals = new boolean[inputs.length];
            argumentTraits = new ArgumentTrait[inputs.length][];
            Arrays.fill((Object[])argumentTraits, new ArgumentTrait[]{ArgumentTrait.SCALAR});
        } else {
            return null;
        }
        List<FunctionArgumentTemplate> argumentTemplates = IntStream.range(0, argumentHintTypes.length).mapToObj(i -> FunctionTemplate.createArgumentTemplate(typeFactory, i, argumentHintTypes[i], argumentTraits[i])).collect(Collectors.toList());
        return FunctionSignatureTemplate.of(argumentTemplates, isVarArg, (EnumSet[])Arrays.stream(argumentTraits).map(t -> {
            List traits = Arrays.stream(t).map(ArgumentTrait::toStaticTrait).collect(Collectors.toList());
            return EnumSet.copyOf(traits);
        }).toArray(EnumSet[]::new), argumentHintNames, argumentOptionals);
    }

    private static FunctionArgumentTemplate createArgumentTemplate(DataTypeFactory typeFactory, int pos, @Nullable DataTypeHint hint, ArgumentTrait[] argumentTraits) {
        Set rootTrait = Arrays.stream(argumentTraits).filter(ArgumentTrait::isRoot).collect(Collectors.toSet());
        if (rootTrait.size() != 1) {
            throw ExtractionUtils.extractionError("Incorrect argument kind at position %d. Argument kind must be one of: %s", pos, Arrays.stream(ArgumentTrait.values()).filter(ArgumentTrait::isRoot).collect(Collectors.toList()));
        }
        if (rootTrait.contains((Object)ArgumentTrait.SCALAR)) {
            if (hint != null) {
                DataTypeTemplate template;
                try {
                    template = DataTypeTemplate.fromAnnotation(typeFactory, hint);
                }
                catch (Throwable t) {
                    throw ExtractionUtils.extractionError(t, "Error in data type hint annotation for argument at position %s.", pos);
                }
                if (template.dataType != null) {
                    return FunctionArgumentTemplate.ofDataType(template.dataType);
                }
                if (template.inputGroup != null) {
                    return FunctionArgumentTemplate.ofInputGroup(template.inputGroup);
                }
            }
            throw ExtractionUtils.extractionError("Data type missing for scalar argument at position %s.", pos);
        }
        if (rootTrait.contains((Object)ArgumentTrait.ROW_SEMANTIC_TABLE) || rootTrait.contains((Object)ArgumentTrait.SET_SEMANTIC_TABLE)) {
            try {
                DataTypeTemplate template = DataTypeTemplate.fromAnnotation(typeFactory, hint);
                if (template.dataType != null) {
                    return FunctionArgumentTemplate.ofDataType(template.dataType);
                }
                if (template.inputGroup != null) {
                    throw ExtractionUtils.extractionError("Input groups are not supported for table argument at position %s.", pos);
                }
                return FunctionArgumentTemplate.ofTable(Row.class);
            }
            catch (Throwable t) {
                Class argClass;
                Class clazz = argClass = hint == null ? Row.class : hint.bridgedTo();
                if (argClass == Row.class || argClass == RowData.class) {
                    return FunctionArgumentTemplate.ofTable(argClass);
                }
                throw t;
            }
        }
        throw ExtractionUtils.extractionError("Unknown argument kind.", new Object[0]);
    }

    private static DataType createStateDataType(DataTypeFactory typeFactory, DataTypeHint dataTypeHint, String description) {
        DataTypeTemplate template;
        try {
            template = DataTypeTemplate.fromAnnotation(typeFactory, dataTypeHint);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in data type hint annotation.", new Object[0]);
        }
        if (template.dataType != null) {
            return template.dataType;
        }
        throw ExtractionUtils.extractionError("Data type hint does not specify a data type for use as %s.", description);
    }

    @ProcedureHint
    @FunctionHint
    @ArgumentHint
    private static class DefaultAnnotationHelper {
        private DefaultAnnotationHelper() {
        }
    }
}

