/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CollectorCodeGenerator$;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.ExternalGeneratedExpression;
import org.apache.flink.table.planner.codegen.ExternalGeneratedExpression$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.runtime.collector.WrappingCollector;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.operators.correlate.async.DelegatingAsyncTableResultFuture;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeInferenceUtil;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class BridgingFunctionGenUtil$ {
    public static BridgingFunctionGenUtil$ MODULE$;

    static {
        new BridgingFunctionGenUtil$();
    }

    public GeneratedExpression generateFunctionAwareCall(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType, TypeInference inference, CallContext callContext, UserDefinedFunction udf, String functionName, boolean skipIfArgsNull) {
        Tuple2<GeneratedExpression, DataType> tuple2 = this.generateFunctionAwareCallWithDataType(ctx, operands, returnType, inference, callContext, udf, functionName, skipIfArgsNull);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        GeneratedExpression call = (GeneratedExpression)tuple2._1();
        GeneratedExpression call2 = call;
        return call2;
    }

    public Tuple2<GeneratedExpression, DataType> generateFunctionAwareCallWithDataType(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType returnType, TypeInference inference, CallContext callContext, UserDefinedFunction udf, String functionName, boolean skipIfArgsNull) {
        CallContext castCallContext = TypeInferenceUtil.castArguments((TypeInference)inference, (CallContext)callContext, null);
        Seq enrichedArgumentDataTypes = JavaScalaConversionUtil$.MODULE$.toScala(castCallContext.getArgumentDataTypes());
        this.verifyArgumentTypes((Seq<LogicalType>)((Seq)operands.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.resultType(), Seq$.MODULE$.canBuildFrom())), enrichedArgumentDataTypes);
        DataType enrichedOutputDataType = TypeInferenceUtil.inferOutputType((CallContext)castCallContext, (TypeStrategy)inference.getOutputTypeStrategy());
        this.verifyFunctionAwareOutputType(returnType, enrichedOutputDataType, udf);
        this.verifyFunctionAwareImplementation(enrichedArgumentDataTypes, enrichedOutputDataType, udf, functionName);
        GeneratedExpression call = this.generateFunctionAwareCall(ctx, operands, enrichedArgumentDataTypes, enrichedOutputDataType, returnType, udf, skipIfArgsNull, (Option<String>)None$.MODULE$);
        return new Tuple2((Object)call, (Object)enrichedOutputDataType);
    }

    private GeneratedExpression generateFunctionAwareCall(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, Seq<DataType> argumentDataTypes, DataType outputDataType, LogicalType returnType, UserDefinedFunction udf, boolean skipIfArgsNull, Option<String> contextTerm) {
        Seq<GeneratedExpression> externalOperands;
        String functionTerm;
        block6: {
            block5: {
                functionTerm = ctx.addReusableFunction(udf, ctx.addReusableFunction$default$2(), ctx.addReusableFunction$default$3());
                externalOperands = this.prepareExternalOperands(ctx, operands, argumentDataTypes);
                FunctionKind functionKind = udf.getKind();
                FunctionKind functionKind2 = FunctionKind.TABLE;
                if (!(functionKind == null ? functionKind2 != null : !functionKind.equals(functionKind2))) break block5;
                FunctionKind functionKind3 = udf.getKind();
                FunctionKind functionKind4 = FunctionKind.PROCESS_TABLE;
                if (functionKind3 != null ? !functionKind3.equals(functionKind4) : functionKind4 != null) break block6;
            }
            return this.generateTableFunctionCall(ctx, functionTerm, externalOperands, outputDataType, returnType, skipIfArgsNull, contextTerm);
        }
        FunctionKind functionKind = udf.getKind();
        FunctionKind functionKind5 = FunctionKind.ASYNC_TABLE;
        if (!(functionKind != null ? !functionKind.equals(functionKind5) : functionKind5 != null)) {
            return this.generateAsyncTableFunctionCall(functionTerm, externalOperands, returnType, outputDataType, skipIfArgsNull);
        }
        FunctionKind functionKind6 = udf.getKind();
        FunctionKind functionKind7 = FunctionKind.ASYNC_SCALAR;
        if (!(functionKind6 != null ? !functionKind6.equals(functionKind7) : functionKind7 != null)) {
            return this.generateAsyncScalarFunctionCall(ctx, functionTerm, externalOperands, returnType, outputDataType);
        }
        return this.generateScalarFunctionCall(ctx, functionTerm, externalOperands, outputDataType);
    }

    public GeneratedExpression generateTableFunctionCall(CodeGeneratorContext ctx, String functionTerm, Seq<GeneratedExpression> externalOperands, DataType functionOutputDataType, LogicalType outputType, boolean skipIfArgsNull, Option<String> contextTerm) {
        String resultCollectorTerm = this.generateResultCollector(ctx, functionOutputDataType, outputType);
        String setCollectorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n                              |").append(functionTerm).append(".setCollector(").append(resultCollectorTerm).append(");\n                              |").toString())).stripMargin();
        ctx.addReusableOpenStatement(setCollectorCode);
        String contextOperand = (String)contextTerm.map((Function1 & Serializable & scala.Serializable)c -> new StringBuilder(2).append((String)c).append(", ").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String functionCallCode = skipIfArgsNull ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(112).append("\n         |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |if (").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(") {\n         |  // skip\n         |} else {\n         |  ").append(functionTerm).append(".eval(").append(contextOperand).append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.resultTerm(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n         |}\n         |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(functionTerm).append(".eval(").append(contextOperand).append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.resultTerm(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultCollectorTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), functionCallCode, outputType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public Option<String> generateTableFunctionCall$default$7() {
        return None$.MODULE$;
    }

    private GeneratedExpression generateAsyncTableFunctionCall(String functionTerm, Seq<GeneratedExpression> externalOperands, LogicalType returnType, DataType outputDataType, boolean skipIfArgsNull) {
        String DELEGATE_ASYNC_TABLE = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(DelegatingAsyncTableResultFuture.class));
        LogicalType outputType = outputDataType.getLogicalType();
        boolean needsWrapping = !LogicalTypeChecks.isCompositeType((LogicalType)outputType);
        boolean isInternal = DataTypeUtils.isInternal((DataType)outputDataType);
        Seq arguments = (Seq)((TraversableLike)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("\n         |delegates.getCompletableFuture()\n         |")).stripMargin(), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.resultTerm(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq anyNull = (Seq)((TraversableLike)externalOperands.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.nullTerm(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)"false", (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        String functionCallCode = skipIfArgsNull ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(221).append("\n           |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n           |if (").append(anyNull.mkString(" || ")).append(") {\n           |  ").append(CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM()).append(".complete(java.util.Collections.emptyList());\n           |} else {\n           |  ").append(DELEGATE_ASYNC_TABLE).append(" delegates = new ").append(DELEGATE_ASYNC_TABLE).append("(").append(CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM()).append(",\n           |      ").append(needsWrapping).append(", ").append(isInternal).append(");\n           |  ").append(functionTerm).append(".eval(").append(arguments.mkString(", ")).append(");\n           |}\n           |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append("\n           |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n           |").append(DELEGATE_ASYNC_TABLE).append(" delegates = new ").append(DELEGATE_ASYNC_TABLE).append("(").append(CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM()).append(",\n           |      ").append(needsWrapping).append(", ").append(isInternal).append(");\n           |  ").append(functionTerm).append(".eval(").append(arguments.mkString(", ")).append(");\n           |").toString())).stripMargin();
        return new GeneratedExpression(GeneratedExpression$.MODULE$.NO_CODE(), GeneratedExpression$.MODULE$.NEVER_NULL(), functionCallCode, returnType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateAsyncScalarFunctionCall(CodeGeneratorContext ctx, String functionTerm, Seq<GeneratedExpression> externalOperands, LogicalType outputType, DataType outputDataType) {
        String converterTerm = ctx.addReusableConverter(outputDataType, ctx.addReusableConverter$default$2());
        String functionCallCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(194).append("\n         |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |if (").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(") {\n         |  ").append("f").append(".createAsyncFuture(").append(converterTerm).append(").complete(null);\n         |} else {\n         |  ").append(functionTerm).append(".eval(\n         |    ").append("f").append(".createAsyncFuture(").append(converterTerm).append("),\n         |    ").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.resultTerm(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n         |}\n         |").toString())).stripMargin();
        return new GeneratedExpression(GeneratedExpression$.MODULE$.NO_CODE(), GeneratedExpression$.MODULE$.NEVER_NULL(), functionCallCode, outputType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public String generateResultCollector(CodeGeneratorContext ctx, DataType outputDataType, LogicalType returnType) {
        String string;
        LogicalType outputType = outputDataType.getLogicalType();
        CodeGeneratorContext collectorCtx = new CodeGeneratorContext(ctx.tableConfig(), ctx.classLoader(), ctx);
        String externalResultTerm = CodeGenUtils$.MODULE$.newName(ctx, "externalResult");
        if (!LogicalTypeChecks.isCompositeType((LogicalType)outputType)) {
            ExprCodeGenerator qual$1 = new ExprCodeGenerator(collectorCtx, outputType.isNullable());
            LogicalType x$1 = outputType;
            String x$2 = externalResultTerm;
            Option<int[]> x$3 = qual$1.bindInput$default$3();
            ExprCodeGenerator resultGenerator = qual$1.bindInput(x$1, x$2, x$3);
            GeneratedExpression wrappedResult = resultGenerator.generateConverterResultExpression((RowType)returnType, GenericRowData.class, resultGenerator.generateConverterResultExpression$default$3(), resultGenerator.generateConverterResultExpression$default$4(), resultGenerator.generateConverterResultExpression$default$5(), resultGenerator.generateConverterResultExpression$default$6(), resultGenerator.generateConverterResultExpression$default$7());
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append("\n         |").append(wrappedResult.code()).append("\n         |outputResult(").append(wrappedResult.resultTerm()).append(");\n         |").toString())).stripMargin();
        } else {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append("\n         |if (").append(externalResultTerm).append(" != null) {\n         |  outputResult(").append(externalResultTerm).append(");\n         |}\n         |").toString())).stripMargin();
        }
        String collectorCode = string;
        GeneratedCollector<WrappingCollector<?>> resultCollector = CollectorCodeGenerator$.MODULE$.generateWrappingCollector(collectorCtx, "TableFunctionResultConverterCollector", outputType, externalResultTerm, CodeGenUtils$.MODULE$.genToInternalConverter(ctx, outputDataType), collectorCode);
        String resultCollectorTerm = CodeGenUtils$.MODULE$.newName(ctx, "resultConverterCollector");
        CollectorCodeGenerator$.MODULE$.addToContext(ctx, resultCollectorTerm, resultCollector);
        return resultCollectorTerm;
    }

    private GeneratedExpression generateScalarFunctionCall(CodeGeneratorContext ctx, String functionTerm, Seq<GeneratedExpression> externalOperands, DataType outputDataType) {
        Class externalResultClass = outputDataType.getConversionClass();
        String externalResultTypeTerm = CodeGenUtils$.MODULE$.typeTerm(externalResultClass);
        Class externalResultClassBoxed = ExtractionUtils.primitiveToWrapper((Class)externalResultClass);
        Class clazz = externalResultClass;
        Class clazz2 = externalResultClassBoxed;
        String externalResultCasting = !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? new StringBuilder(2).append("(").append(externalResultTypeTerm).append(")").toString() : new StringBuilder(5).append("(").append(externalResultTypeTerm).append(") (").append(CodeGenUtils$.MODULE$.typeTerm(externalResultClassBoxed)).append(")").toString();
        String externalResultTerm = ctx.addReusableLocalVariable(externalResultTypeTerm, "externalResult");
        String externalCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(58).append("\n         |").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(externalResultTerm).append(" = ").append(externalResultCasting).append(" ").append(functionTerm).append("\n         |  .").append("eval").append("(").append(((TraversableOnce)externalOperands.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.resultTerm(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(");\n         |").toString())).stripMargin();
        GeneratedExpression internalExpr = CodeGenUtils$.MODULE$.genToInternalConverterAll(ctx, outputDataType, externalResultTerm);
        String x$1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n                                           |").append(externalCode).append("\n                                           |").append(internalExpr.code()).append("\n                                           |").toString())).stripMargin();
        String x$2 = internalExpr.copy$default$1();
        String x$3 = internalExpr.copy$default$2();
        LogicalType x$4 = internalExpr.copy$default$4();
        Option<Object> x$5 = internalExpr.copy$default$5();
        GeneratedExpression copy = internalExpr.copy(x$2, x$3, x$1, x$4, x$5);
        return ExternalGeneratedExpression$.MODULE$.fromGeneratedExpression(outputDataType, externalResultTerm, externalCode, copy);
    }

    public Seq<GeneratedExpression> prepareExternalOperands(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, Seq<DataType> argumentDataTypes) {
        return (Seq)((TraversableLike)operands.zip(argumentDataTypes, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                GeneratedExpression operand = (GeneratedExpression)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                GeneratedExpression generatedExpression = operand;
                if (generatedExpression instanceof ExternalGeneratedExpression) {
                    ExternalGeneratedExpression externalGeneratedExpression = (ExternalGeneratedExpression)generatedExpression;
                    if (!DataTypeUtils.isInternal((DataType)dataType)) {
                        DataType dataType2 = externalGeneratedExpression.getDataType();
                        DataType dataType3 = dataType;
                        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                            String x$1 = externalGeneratedExpression.getExternalTerm();
                            String x$2 = externalGeneratedExpression.getExternalCode();
                            String x$3 = operand.copy$default$2();
                            LogicalType x$4 = operand.copy$default$4();
                            Option<Object> x$5 = operand.copy$default$5();
                            return operand.copy(x$1, x$3, x$2, x$4, x$5);
                        }
                    }
                }
                return operand.copy(CodeGenUtils$.MODULE$.genToExternalConverterAll(ctx, dataType, operand), operand.copy$default$2(), operand.copy$default$3(), operand.copy$default$4(), operand.copy$default$5());
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void verifyArgumentTypes(Seq<LogicalType> operandTypes, Seq<DataType> enrichedDataTypes) {
        Seq enrichedTypes = (Seq)enrichedDataTypes.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.getLogicalType(), Seq$.MODULE$.canBuildFrom());
        ((IterableLike)operandTypes.zip((GenIterable)enrichedTypes, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BridgingFunctionGenUtil$.$anonfun$verifyArgumentTypes$2(x0$1);
            return BoxedUnit.UNIT;
        });
        enrichedDataTypes.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            BridgingFunctionGenUtil$.$anonfun$verifyArgumentTypes$3(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyFunctionAwareOutputType(LogicalType returnType, DataType enrichedDataType, UserDefinedFunction udf) {
        block10: {
            block9: {
                block8: {
                    LogicalType enrichedType;
                    block7: {
                        enrichedType = enrichedDataType.getLogicalType();
                        FunctionKind functionKind = udf.getKind();
                        FunctionKind functionKind2 = FunctionKind.TABLE;
                        if (!(functionKind == null ? functionKind2 != null : !functionKind.equals(functionKind2))) break block7;
                        FunctionKind functionKind3 = udf.getKind();
                        FunctionKind functionKind4 = FunctionKind.ASYNC_TABLE;
                        if (!(functionKind3 == null ? functionKind4 != null : !functionKind3.equals(functionKind4))) break block7;
                        FunctionKind functionKind5 = udf.getKind();
                        FunctionKind functionKind6 = FunctionKind.PROCESS_TABLE;
                        if (functionKind5 != null ? !functionKind5.equals(functionKind6) : functionKind6 != null) break block8;
                    }
                    if (!LogicalTypeChecks.isCompositeType((LogicalType)enrichedType)) {
                        Preconditions.checkState((returnType.is(LogicalTypeRoot.ROW) && returnType.getChildren().size() == 1 ? 1 : 0) != 0, (String)"Logical output type of function call should be a ROW wrapping an atomic type.", (Object[])ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Nil$.MODULE$).toArray(ClassTag$.MODULE$.Any())));
                        LogicalType atomicOutputType = (LogicalType)((RowType)returnType).getChildren().get(0);
                        this.verifyOutputType(atomicOutputType, enrichedDataType);
                        return;
                    }
                }
                FunctionKind functionKind = udf.getKind();
                FunctionKind functionKind7 = FunctionKind.TABLE;
                if (!(functionKind == null ? functionKind7 != null : !functionKind.equals(functionKind7))) break block9;
                FunctionKind functionKind8 = udf.getKind();
                FunctionKind functionKind9 = FunctionKind.PROCESS_TABLE;
                if (!(functionKind8 == null ? functionKind9 != null : !functionKind8.equals(functionKind9))) break block9;
                FunctionKind functionKind10 = udf.getKind();
                FunctionKind functionKind11 = FunctionKind.ASYNC_TABLE;
                if (functionKind10 != null ? !functionKind10.equals(functionKind11) : functionKind11 != null) break block10;
            }
            this.verifyOutputType(returnType.copy(true), enrichedDataType);
            return;
        }
        this.verifyOutputType(returnType, enrichedDataType);
    }

    private void verifyOutputType(LogicalType returnType, DataType enrichedDataType) {
        LogicalType enrichedType = enrichedDataType.getLogicalType();
        if (!LogicalTypeCasts.supportsAvoidingCast((LogicalType)enrichedType, (LogicalType)returnType)) {
            throw new CodeGenException(new StringBuilder(71).append("Mismatch of expected output data type '").append(returnType).append("' and function's ").append("output type '").append(enrichedType).append("'.").toString());
        }
        DataTypeUtils.validateInputDataType((DataType)enrichedDataType);
    }

    public void verifyFunctionAwareImplementation(Seq<DataType> argumentDataTypes, DataType outputDataType, UserDefinedFunction udf, String functionName) {
        FunctionKind functionKind = udf.getKind();
        FunctionKind functionKind2 = FunctionKind.TABLE;
        if (!(functionKind != null ? !functionKind.equals(functionKind2) : functionKind2 != null)) {
            this.verifyImplementation("eval", argumentDataTypes, (Option<DataType>)None$.MODULE$, udf, functionName);
            return;
        }
        FunctionKind functionKind3 = udf.getKind();
        FunctionKind functionKind4 = FunctionKind.ASYNC_TABLE;
        if (!(functionKind3 != null ? !functionKind3.equals(functionKind4) : functionKind4 != null)) {
            DataType dataType = (DataType)DataTypes.NULL().bridgedTo(CompletableFuture.class);
            this.verifyImplementation("eval", (Seq<DataType>)((Seq)argumentDataTypes.$plus$colon((Object)dataType, Seq$.MODULE$.canBuildFrom())), (Option<DataType>)None$.MODULE$, udf, functionName);
            return;
        }
        FunctionKind functionKind5 = udf.getKind();
        FunctionKind functionKind6 = FunctionKind.SCALAR;
        if (!(functionKind5 != null ? !functionKind5.equals(functionKind6) : functionKind6 != null)) {
            this.verifyImplementation("eval", argumentDataTypes, (Option<DataType>)new Some((Object)outputDataType), udf, functionName);
            return;
        }
        FunctionKind functionKind7 = udf.getKind();
        FunctionKind functionKind8 = FunctionKind.ASYNC_SCALAR;
        if (!(functionKind7 != null ? !functionKind7.equals(functionKind8) : functionKind8 != null)) {
            DataType dataType = (DataType)DataTypes.NULL().bridgedTo(CompletableFuture.class);
            this.verifyImplementation("eval", (Seq<DataType>)((Seq)argumentDataTypes.$plus$colon((Object)dataType, Seq$.MODULE$.canBuildFrom())), (Option<DataType>)None$.MODULE$, udf, functionName);
            return;
        }
        throw new CodeGenException(new StringBuilder(45).append("Unsupported function kind '").append(udf.getKind()).append("' for function '").append(functionName).append("'.").toString());
    }

    private void verifyImplementation(String methodName, Seq<DataType> argumentDataTypes, Option<DataType> outputDataType, UserDefinedFunction udf, String functionName) {
        Class[] argumentClasses = (Class[])((TraversableOnce)argumentDataTypes.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.getConversionClass(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class));
        Class outputClass = (Class)outputDataType.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.getConversionClass()).getOrElse((Function0 & Serializable & scala.Serializable)() -> BoxedUnit.TYPE);
        UserDefinedFunctionHelper.validateClassForRuntime((Class)udf.getClass(), (String)methodName, (Class[])argumentClasses, (Class)outputClass, (String)functionName);
    }

    public static final /* synthetic */ void $anonfun$verifyArgumentTypes$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            LogicalType enrichedType;
            LogicalType operandType = (LogicalType)tuple2._1();
            if (!LogicalTypeCasts.supportsAvoidingCast((LogicalType)operandType, (LogicalType)(enrichedType = (LogicalType)tuple2._2()))) {
                throw new CodeGenException(new StringBuilder(73).append("Mismatch of function's argument data type '").append(enrichedType).append("' and actual ").append("argument type '").append(operandType).append("'.").toString());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$verifyArgumentTypes$3(DataType x$1) {
        DataTypeUtils.validateOutputDataType((DataType)x$1);
    }

    private BridgingFunctionGenUtil$() {
        MODULE$ = this;
    }
}

