/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.api.configuration;

import java.util.Objects;

public class ConfigOption<T> {
    private final String key;
    private final Class<T> type;
    private final T defaultValue;

    public ConfigOption(String key, Class<T> type, T defaultValue) {
        this.key = Objects.requireNonNull(key);
        this.type = Objects.requireNonNull(type);
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.getTypeName();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigOption that = (ConfigOption)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "ConfigOption{key='" + this.key + "', type=" + this.type.getName() + ", defaultValue=" + String.valueOf(this.defaultValue) + "}";
    }
}

