/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Arrays;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Projection;

public class ProjectedRow
implements InternalRow {
    protected final int[] indexMapping;
    protected InternalRow row;

    protected ProjectedRow(int[] indexMapping) {
        this.indexMapping = indexMapping;
    }

    public ProjectedRow replaceRow(InternalRow row) {
        this.row = row;
        return this;
    }

    @Override
    public int getFieldCount() {
        return this.indexMapping.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    @Override
    public boolean isNullAt(int pos) {
        if (this.indexMapping[pos] < 0) {
            return true;
        }
        return this.row.isNullAt(this.indexMapping[pos]);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.row.getBoolean(this.indexMapping[pos]);
    }

    @Override
    public byte getByte(int pos) {
        return this.row.getByte(this.indexMapping[pos]);
    }

    @Override
    public short getShort(int pos) {
        return this.row.getShort(this.indexMapping[pos]);
    }

    @Override
    public int getInt(int pos) {
        return this.row.getInt(this.indexMapping[pos]);
    }

    @Override
    public long getLong(int pos) {
        return this.row.getLong(this.indexMapping[pos]);
    }

    @Override
    public float getFloat(int pos) {
        return this.row.getFloat(this.indexMapping[pos]);
    }

    @Override
    public double getDouble(int pos) {
        return this.row.getDouble(this.indexMapping[pos]);
    }

    @Override
    public BinaryString getString(int pos) {
        return this.row.getString(this.indexMapping[pos]);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return this.row.getDecimal(this.indexMapping[pos], precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(this.indexMapping[pos], precision);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.row.getBinary(this.indexMapping[pos]);
    }

    @Override
    public Variant getVariant(int pos) {
        return this.row.getVariant(this.indexMapping[pos]);
    }

    @Override
    public InternalArray getArray(int pos) {
        return this.row.getArray(this.indexMapping[pos]);
    }

    @Override
    public InternalMap getMap(int pos) {
        return this.row.getMap(this.indexMapping[pos]);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return this.row.getRow(this.indexMapping[pos], numFields);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Projected row data cannot be compared");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Projected row data cannot be hashed");
    }

    public String toString() {
        return this.row.getRowKind().shortString() + "{indexMapping=" + Arrays.toString(this.indexMapping) + ", mutableRow=" + this.row + '}';
    }

    public static ProjectedRow from(int[][] projection) throws IllegalArgumentException {
        return new ProjectedRow(Arrays.stream(projection).mapToInt(arr -> {
            if (((int[])arr).length != 1) {
                throw new IllegalArgumentException("ProjectedRowData doesn't support nested projections");
            }
            return arr[0];
        }).toArray());
    }

    public static ProjectedRow from(int[] projection) {
        return new ProjectedRow(projection);
    }

    public static ProjectedRow from(RowType readType, RowType tableType) {
        return new ProjectedRow(readType.getFields().stream().mapToInt(field -> tableType.getFieldIndexByFieldId(field.id())).toArray());
    }

    public static ProjectedRow from(Projection projection) {
        return new ProjectedRow(projection.toTopLevelIndexes());
    }
}

