/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lineage.sink;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.openlineage.server.OpenLineage;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.lineage.sink.LineageSinkEventListener;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.EventListenerManager;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.EventWrapper;

public class LineageSinkManager
implements Closeable {
    private EventBus eventBus;
    private final EventListenerManager eventListenerManager = new EventListenerManager();

    public void initialize(List<String> sinks, Map<String, String> LineageConfigs) {
        Map<String, String> eventListenerConfigs = LineageSinkManager.transformToEventListenerConfigs(sinks, LineageConfigs);
        this.eventListenerManager.init(eventListenerConfigs);
        this.eventBus = this.eventListenerManager.createEventBus();
        this.eventListenerManager.start();
    }

    public boolean isHighWatermark() {
        return this.eventBus.isHighWatermark();
    }

    @VisibleForTesting
    static Map<String, String> transformToEventListenerConfigs(List<String> sinks, Map<String, String> lineageConfigs) {
        HashMap<String, String> eventListenerConfigs = new HashMap<String, String>();
        eventListenerConfigs.putAll(LineageSinkManager.generateEventListenerConfigs(sinks, lineageConfigs));
        eventListenerConfigs.putAll(lineageConfigs);
        return eventListenerConfigs;
    }

    private static Map<String, String> generateEventListenerConfigs(List<String> sinks, Map<String, String> lineageConfigs) {
        HashMap<String, String> eventListenerConfigs = new HashMap<String, String>();
        if (sinks.isEmpty()) {
            return eventListenerConfigs;
        }
        String queueCapacity = lineageConfigs.get("sinkQueueCapacity");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)queueCapacity), (Object)"Lineage sink queue capacity is not set");
        int capacityPerSink = Integer.valueOf(queueCapacity) / sinks.size();
        eventListenerConfigs.put("names", String.join((CharSequence)",", sinks));
        sinks.forEach(sinkName -> {
            eventListenerConfigs.put(sinkName + ".class", LineageSinkEventListener.class.getName());
            eventListenerConfigs.put(sinkName + ".queueCapacity", String.valueOf(capacityPerSink));
        });
        return eventListenerConfigs;
    }

    public void sink(OpenLineage.RunEvent runEvent) {
        this.eventBus.dispatchEvent((BaseEvent)new EventWrapper((Object)runEvent));
    }

    @Override
    public void close() {
        if (this.eventListenerManager != null) {
            this.eventListenerManager.stop();
        }
    }

    @VisibleForTesting
    EventBus eventBus() {
        return this.eventBus;
    }
}

