/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import com.google.common.base.Joiner;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.TableCommand;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.rel.Column;

public class ListColumns
extends TableCommand {
    protected final String schema;
    protected final String table;

    public ListColumns(CommandContext context, String metalake, String catalog, String schema, String table) {
        super(context, metalake, catalog);
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void handle() {
        Column[] columns = null;
        try {
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            columns = this.tableCatalog().loadTable(name).columns();
        }
        catch (NoSuchTableException noSuchTableException) {
            this.exitWithError("Unknown table name." + Joiner.on(".").join(this.metalake, this.catalog, this.schema, this.table));
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printResults(columns);
    }
}

