/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.seq;

import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.Range;
import com.googlecode.aviator.utils.ArrayUtils;
import java.util.Collection;
import java.util.Map;

public class SeqCountFunction
extends AbstractFunction {
    private static final long serialVersionUID = 4640528586873392060L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        Object value = arg1.getValue(env);
        if (value == null) {
            return AviatorLong.valueOf(0L);
        }
        Class<?> clazz = value.getClass();
        int size = -1;
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection col = (Collection)value;
            size = col.size();
        } else if (Map.class.isAssignableFrom(clazz)) {
            size = ((Map)value).size();
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            size = ((CharSequence)value).length();
        } else if (clazz.isArray()) {
            size = ArrayUtils.getLength(value);
        } else if (Range.class.isAssignableFrom(clazz)) {
            size = ((Range)value).size();
        } else {
            size = 0;
            for (Object e : RuntimeUtils.seq(value, env)) {
                ++size;
            }
        }
        return AviatorLong.valueOf(size);
    }

    @Override
    public String getName() {
        return "count";
    }
}

