/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.utils;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.Feature;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.function.internal.ReducerResult;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.Range;
import com.googlecode.aviator.utils.ArrayHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Env
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -7793716992176999689L;
    private final Map<String, Object> mDefaults;
    private transient AviatorEvaluatorInstance instance;
    private Map<String, Object> mOverrides;
    private Expression expression;
    private List<String> importedSymbols;
    private List<String> importedPackages;
    private transient Map<String, Class<?>> resolvedClasses;
    public static final Map<String, Object> EMPTY_ENV = Collections.emptyMap();
    private long startNs = -1L;
    private transient IntCounter checkPoints = null;
    private static final IdentityHashMap<String, GetValueTask> INTERNAL_VARIABLES = new IdentityHashMap();

    public Env() {
        this(EMPTY_ENV);
    }

    public Env(Map<String, Object> defaults) {
        this.mDefaults = defaults;
    }

    public Env(Map<String, Object> defaults, Map<String, Object> overrides) {
        this.mDefaults = defaults;
        this.mOverrides = overrides;
    }

    public void setmOverrides(Map<String, Object> mOverrides) {
        this.mOverrides = mOverrides;
    }

    public long getStartNs() {
        return this.startNs;
    }

    public int incExecCheckpointsAndGet() {
        if (this.checkPoints == null) {
            this.checkPoints = new IntCounter();
        }
        return ++this.checkPoints.n;
    }

    public IntCounter getCheckPoints() {
        return this.checkPoints;
    }

    public List<String> getImportedSymbols() {
        return this.importedSymbols;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Map<String, Object> getDefaults() {
        return this.mDefaults;
    }

    public String addSymbol(String sym) {
        if (this.importedSymbols == null) {
            this.importedSymbols = new ArrayList<String>();
        }
        this.importedSymbols.add(sym);
        this.invalidateCache();
        return sym;
    }

    public String addPackageSymbol(String sym) {
        if (this.importedPackages == null) {
            this.importedPackages = new ArrayList<String>();
        }
        this.importedPackages.add(sym);
        this.invalidateCache();
        return sym;
    }

    private void invalidateCache() {
        if (this.resolvedClasses != null) {
            this.resolvedClasses.clear();
        }
    }

    public AviatorEvaluatorInstance getInstance() {
        return this.instance;
    }

    public void setInstance(AviatorEvaluatorInstance instance) {
        this.instance = instance;
    }

    public void configure(AviatorEvaluatorInstance instance, Expression exp, long startNs, IntCounter checkPoints) {
        this.instance = instance;
        this.expression = exp;
        this.setStats(startNs, checkPoints);
    }

    private void setStats(long startNs, IntCounter checkPoints) {
        if (this.startNs == -1L && startNs > 0L) {
            this.startNs = startNs;
            this.checkPoints = checkPoints;
        }
    }

    private String findSymbol(String name) throws ClassNotFoundException {
        String postfix = "." + name;
        String targetSym = null;
        if (this.importedSymbols != null) {
            for (String sym : this.importedSymbols) {
                if (!sym.endsWith(postfix)) continue;
                targetSym = sym;
                break;
            }
        }
        return targetSym;
    }

    public Class<?> resolveClassSymbol(String name) throws ClassNotFoundException {
        return this.resolveClassSymbol(name, true);
    }

    public Class<?> resolveClassSymbol(String name, boolean checkIfAllow) throws ClassNotFoundException {
        Class<?> clazz = this.retrieveFromCache(name);
        if (clazz == NullClass.class) {
            throw new ClassNotFoundException(name);
        }
        if (clazz == null) {
            if (name.contains(".")) {
                clazz = this.classForName(name);
            } else {
                clazz = this.classForName("java.lang." + name);
                if (clazz == null) {
                    clazz = this.resolveFromImportedPackages(name);
                }
                if (clazz == null) {
                    clazz = this.resolveFromImportedSymbols(name, clazz);
                }
                if (clazz == null && this.mDefaults instanceof Env) {
                    clazz = ((Env)this.mDefaults).resolveClassSymbol(name, checkIfAllow);
                }
            }
        }
        if (clazz == null) {
            this.put2cache(name, NullClass.class);
            throw new ClassNotFoundException(name);
        }
        this.put2cache(name, clazz);
        return this.instance.checkIfClassIsAllowed(checkIfAllow, clazz);
    }

    private Class<?> resolveFromImportedPackages(String name) {
        Class<?> clazz = null;
        if (this.importedPackages != null) {
            for (String pkg : this.importedPackages) {
                clazz = this.classForName(pkg + name);
                if (clazz == null) continue;
                return clazz;
            }
        }
        return clazz;
    }

    private Class<?> resolveFromImportedSymbols(String name, Class<?> clazz) throws ClassNotFoundException {
        String classSym = this.findSymbol(name);
        if (classSym != null) {
            clazz = this.classForName(classSym);
        }
        return clazz;
    }

    private void put2cache(String name, Class<?> ret) {
        if (this.resolvedClasses == null) {
            this.resolvedClasses = new HashMap();
        }
        this.resolvedClasses.put(name, ret);
    }

    private Class<?> retrieveFromCache(String name) {
        return this.resolvedClasses != null ? this.resolvedClasses.get(name) : null;
    }

    private Class<?> classForName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public void clear() {
        if (this.mDefaults != EMPTY_ENV) {
            this.mDefaults.clear();
        }
        if (this.mOverrides != null && this.mOverrides != EMPTY_ENV) {
            this.mOverrides.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Map<String, Object> overrides = this.getmOverrides(true);
        return overrides.containsKey(key) || this.mDefaults != overrides && this.mDefaults.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getmOverrides(true).containsValue(value) || this.mDefaults.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> ret = new HashSet<Map.Entry<String, Object>>(this.mDefaults.entrySet());
        ret.addAll(this.getmOverrides(true).entrySet());
        return ret;
    }

    @Override
    public Object get(Object key) {
        GetValueTask task = INTERNAL_VARIABLES.get(key);
        if (task != null) {
            return task.call(this);
        }
        Map<String, Object> overrides = this.getmOverrides(true);
        Object ret = null;
        ret = overrides.containsKey(key) ? overrides.get(key) : this.mDefaults.get(key);
        return ret;
    }

    @Override
    public boolean isEmpty() {
        return this.getmOverrides(true).isEmpty() && this.mDefaults.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> ret = new HashSet<String>(this.mDefaults.keySet());
        ret.addAll(this.getmOverrides(true).keySet());
        return ret;
    }

    public Object override(String key, Object value) {
        Object prior;
        Map<String, Object> overrides = this.getmOverrides(false);
        if (overrides.containsKey(key)) {
            prior = overrides.put(key, value);
        } else {
            overrides.put(key, value);
            prior = this.mDefaults != null ? this.mDefaults.get(key) : null;
        }
        return prior;
    }

    @Override
    public Object put(String key, Object value) {
        Object prior = null;
        Map<String, Object> overrides = this.getmOverrides(false);
        if (overrides.containsKey(key)) {
            prior = overrides.put(key, value);
        } else if (this.mDefaults.containsKey(key)) {
            prior = this.mDefaults.put(key, value);
        } else {
            overrides.put(key, value);
        }
        return prior;
    }

    @Override
    public void putAll(Map map) {
        this.getmOverrides(false).putAll(map);
    }

    @Override
    public Object remove(Object key) {
        if (this.getmOverrides(true).containsKey(key)) {
            return this.getmOverrides(false).remove(key);
        }
        return this.mDefaults.remove(key);
    }

    public Object forgot(Object key) {
        Map<String, Object> overrides = this.getmOverrides(true);
        if (overrides != this.mDefaults && overrides.containsKey(key)) {
            return this.getmOverrides(false).remove(key);
        }
        return null;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (String key : this.keySet()) {
            vals.add(this.get(key));
        }
        return vals;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32 * this.size());
        buf.append(super.toString()).append("{").append("__instance__").append("=").append(this.instance).append(", ").append("__exp__").append("=").append(this.expression).append(", ").append("__env__").append("=").append("<this>");
        Iterator<String> it = this.keySet().iterator();
        boolean hasNext = it.hasNext();
        if (hasNext) {
            buf.append(", ");
        }
        while (hasNext) {
            String key = it.next();
            Object value = this.get(key);
            buf.append(key).append('=').append(value == this ? "<this>" : value);
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(',').append(' ');
        }
        buf.append('}');
        return buf.toString();
    }

    private Map<String, Object> getmOverrides(boolean readOnly) {
        if (this.mOverrides == null) {
            if (readOnly) {
                return EMPTY_ENV;
            }
            this.mOverrides = new ArrayHashMap<String, Object>();
        }
        return this.mOverrides;
    }

    static {
        INTERNAL_VARIABLES.put("__reducer_loop", new TargetObjectTask(Range.LOOP));
        INTERNAL_VARIABLES.put("__reducer_empty", new TargetObjectTask(ReducerResult.withEmpty(AviatorNil.NIL)));
        INTERNAL_VARIABLES.put("__env__", new GetValueTask(){

            @Override
            public Object call(Env env) {
                env.instance.ensureFeatureEnabled(Feature.InternalVars);
                return env;
            }
        });
        INTERNAL_VARIABLES.put("__args__", new GetValueTask(){

            @Override
            public Object call(Env env) {
                env.instance.ensureFeatureEnabled(Feature.InternalVars);
                return FunctionUtils.getFunctionArguments(env);
            }
        });
        INTERNAL_VARIABLES.put("__instance__", new GetValueTask(){

            @Override
            public Object call(Env env) {
                env.instance.ensureFeatureEnabled(Feature.InternalVars);
                return env.instance;
            }
        });
        INTERNAL_VARIABLES.put("__exp__", new GetValueTask(){

            @Override
            public Object call(Env env) {
                env.instance.ensureFeatureEnabled(Feature.InternalVars);
                return env.expression;
            }
        });
    }

    static class NullClass {
        NullClass() {
        }
    }

    static interface GetValueTask {
        public Object call(Env var1);
    }

    static class TargetObjectTask
    implements GetValueTask {
        Object target;

        public TargetObjectTask(Object target) {
            this.target = target;
        }

        @Override
        public Object call(Env env) {
            return this.target;
        }
    }

    public static class IntCounter {
        transient int n = 0;
    }
}

