/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;

class Delegates {
    private Delegates() {
    }

    static <F extends ContentFile<F>> F suppressFirstRowId(F file) {
        if (file instanceof DataFile && null != file.firstRowId()) {
            return (F)new DelegatingDataFile((DataFile)file){

                @Override
                public Long firstRowId() {
                    return null;
                }
            };
        }
        return file;
    }

    static DeleteFile pendingDeleteFile(DeleteFile file, Long dataSequenceNumber) {
        return new PendingDeleteFile(file, dataSequenceNumber);
    }

    static class PendingDeleteFile
    extends DelegatingDeleteFile {
        private final Long dataSequenceNumber;

        PendingDeleteFile(DeleteFile file, Long dataSequenceNumber) {
            super(file);
            this.dataSequenceNumber = dataSequenceNumber;
        }

        @Override
        DeleteFile wrap(DeleteFile file) {
            return new PendingDeleteFile(file, this.dataSequenceNumber);
        }

        @Override
        public Long dataSequenceNumber() {
            return this.dataSequenceNumber;
        }
    }

    static class DelegatingContentFile<F extends ContentFile<F>>
    implements ContentFile<F> {
        protected ContentFile<F> wrapped;

        DelegatingContentFile(F wrapped) {
            this.wrapped = wrapped;
        }

        protected void setWrapped(F wrapped) {
            this.wrapped = wrapped;
        }

        public String manifestLocation() {
            return this.wrapped.manifestLocation();
        }

        public Long pos() {
            return this.wrapped.pos();
        }

        public int specId() {
            return this.wrapped.specId();
        }

        public FileContent content() {
            return this.wrapped.content();
        }

        public CharSequence path() {
            return this.wrapped.location();
        }

        public String location() {
            return this.wrapped.location();
        }

        public FileFormat format() {
            return this.wrapped.format();
        }

        public StructLike partition() {
            return this.wrapped.partition();
        }

        public long recordCount() {
            return this.wrapped.recordCount();
        }

        public long fileSizeInBytes() {
            return this.wrapped.fileSizeInBytes();
        }

        public Map<Integer, Long> columnSizes() {
            return this.wrapped.columnSizes();
        }

        public Map<Integer, Long> valueCounts() {
            return this.wrapped.valueCounts();
        }

        public Map<Integer, Long> nullValueCounts() {
            return this.wrapped.nullValueCounts();
        }

        public Map<Integer, Long> nanValueCounts() {
            return this.wrapped.nanValueCounts();
        }

        public Map<Integer, ByteBuffer> lowerBounds() {
            return this.wrapped.lowerBounds();
        }

        public Map<Integer, ByteBuffer> upperBounds() {
            return this.wrapped.upperBounds();
        }

        public ByteBuffer keyMetadata() {
            return this.wrapped.keyMetadata();
        }

        public List<Long> splitOffsets() {
            return this.wrapped.splitOffsets();
        }

        public List<Integer> equalityFieldIds() {
            return this.wrapped.equalityFieldIds();
        }

        public Integer sortOrderId() {
            return this.wrapped.sortOrderId();
        }

        public Long dataSequenceNumber() {
            return this.wrapped.dataSequenceNumber();
        }

        public Long fileSequenceNumber() {
            return this.wrapped.fileSequenceNumber();
        }

        public Long firstRowId() {
            return this.wrapped.firstRowId();
        }

        public F copy() {
            throw new IllegalArgumentException("Cannot copy wrapped DataFile");
        }

        public F copyWithStats(Set<Integer> requestedColumnIds) {
            throw new IllegalArgumentException("Cannot copy wrapped DataFile");
        }

        public F copyWithoutStats() {
            throw new IllegalArgumentException("Cannot copy wrapped DataFile");
        }
    }

    static class DelegatingDeleteFile
    extends DelegatingContentFile<DeleteFile>
    implements DeleteFile {
        private DeleteFile wrappedAsDeleteFile;

        DelegatingDeleteFile(DeleteFile wrapped) {
            super(wrapped);
            this.wrappedAsDeleteFile = wrapped;
        }

        DeleteFile wrap(DeleteFile file) {
            this.setWrapped(file);
            this.wrappedAsDeleteFile = file;
            return this;
        }

        public String referencedDataFile() {
            return this.wrappedAsDeleteFile.referencedDataFile();
        }

        public Long contentOffset() {
            return this.wrappedAsDeleteFile.contentOffset();
        }

        public Long contentSizeInBytes() {
            return this.wrappedAsDeleteFile.contentSizeInBytes();
        }

        @Override
        public DeleteFile copy() {
            return this.wrap((DeleteFile)this.wrappedAsDeleteFile.copy());
        }

        @Override
        public DeleteFile copyWithStats(Set<Integer> requestedColumnIds) {
            return this.wrap((DeleteFile)this.wrappedAsDeleteFile.copyWithStats(requestedColumnIds));
        }

        @Override
        public DeleteFile copyWithoutStats() {
            return this.wrap((DeleteFile)this.wrappedAsDeleteFile.copyWithoutStats());
        }

        public DeleteFile copy(boolean withStats) {
            return this.wrap((DeleteFile)this.wrappedAsDeleteFile.copy(withStats));
        }
    }

    static class DelegatingDataFile
    extends DelegatingContentFile<DataFile>
    implements DataFile {
        private DataFile wrappedAsDataFile;

        DelegatingDataFile(DataFile wrapped) {
            super(wrapped);
            this.wrappedAsDataFile = wrapped;
        }

        DataFile wrap(DataFile file) {
            this.setWrapped(file);
            this.wrappedAsDataFile = file;
            return this;
        }

        @Override
        public DataFile copy() {
            return this.wrap((DataFile)this.wrappedAsDataFile.copy());
        }

        @Override
        public DataFile copyWithStats(Set<Integer> requestedColumnIds) {
            return this.wrap((DataFile)this.wrappedAsDataFile.copyWithStats(requestedColumnIds));
        }

        @Override
        public DataFile copyWithoutStats() {
            return this.wrap((DataFile)this.wrappedAsDataFile.copyWithoutStats());
        }

        public DataFile copy(boolean withStats) {
            return this.wrap((DataFile)this.wrappedAsDataFile.copy(withStats));
        }
    }
}

