/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantValue;

public class VariantConversion
extends Conversion<Variant> {
    public Class<Variant> getConvertedType() {
        return Variant.class;
    }

    public String getLogicalTypeName() {
        return "variant";
    }

    public Variant fromRecord(IndexedRecord record, Schema schema, LogicalType type) {
        int metadataPos = schema.getField("metadata").pos();
        int valuePos = schema.getField("value").pos();
        VariantMetadata metadata = VariantMetadata.from((ByteBuffer)((ByteBuffer)record.get(metadataPos)));
        VariantValue value = VariantValue.from((VariantMetadata)metadata, (ByteBuffer)((ByteBuffer)record.get(valuePos)));
        return Variant.of((VariantMetadata)metadata, (VariantValue)value);
    }

    public IndexedRecord toRecord(Variant variant, Schema schema, LogicalType type) {
        int metadataPos = schema.getField("metadata").pos();
        int valuePos = schema.getField("value").pos();
        GenericData.Record record = new GenericData.Record(schema);
        ByteBuffer metadataBuffer = ByteBuffer.allocate(variant.metadata().sizeInBytes()).order(ByteOrder.LITTLE_ENDIAN);
        variant.metadata().writeTo(metadataBuffer, 0);
        record.put(metadataPos, (Object)metadataBuffer);
        ByteBuffer valueBuffer = ByteBuffer.allocate(variant.value().sizeInBytes()).order(ByteOrder.LITTLE_ENDIAN);
        variant.value().writeTo(valueBuffer, 0);
        record.put(valuePos, (Object)valueBuffer);
        return record;
    }
}

