/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MultiValuedColumnVector;

public class MapColumnVector
extends MultiValuedColumnVector {
    public ColumnVector keys;
    public ColumnVector values;

    public MapColumnVector() {
        this(1024, null, null);
    }

    public MapColumnVector(int len, ColumnVector keys, ColumnVector values) {
        super(len);
        this.keys = keys;
        this.values = values;
    }

    @Override
    protected void childFlatten(boolean useSelected, int[] selected, int size) {
        this.keys.flatten(useSelected, selected, size);
        this.values.flatten(useSelected, selected, size);
    }

    @Override
    public void setElement(int outElementNum, int inputElementNum, ColumnVector inputVector) {
        if (inputVector.isRepeating) {
            inputElementNum = 0;
        }
        if (!inputVector.noNulls && inputVector.isNull[inputElementNum]) {
            this.isNull[outElementNum] = true;
            this.noNulls = false;
        } else {
            MapColumnVector input = (MapColumnVector)inputVector;
            this.isNull[outElementNum] = false;
            int offset = this.childCount;
            int length = (int)input.lengths[inputElementNum];
            int inputOffset = (int)input.offsets[inputElementNum];
            this.offsets[outElementNum] = offset;
            this.childCount += length;
            this.lengths[outElementNum] = length;
            this.keys.ensureSize(this.childCount, true);
            this.values.ensureSize(this.childCount, true);
            for (int i = 0; i < length; ++i) {
                this.keys.setElement(i + offset, inputOffset + i, input.keys);
                this.values.setElement(i + offset, inputOffset + i, input.values);
            }
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append('[');
            boolean isFirst = true;
            for (long i = this.offsets[row]; i < this.offsets[row] + this.lengths[row]; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append("{\"key\": ");
                this.keys.stringifyValue(buffer, (int)i);
                buffer.append(", \"value\": ");
                this.values.stringifyValue(buffer, (int)i);
                buffer.append('}');
            }
            buffer.append(']');
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void init() {
        super.init();
        this.keys.init();
        this.values.init();
    }

    @Override
    public void reset() {
        super.reset();
        this.keys.reset();
        this.values.reset();
    }

    @Override
    public void unFlatten() {
        super.unFlatten();
        if (!this.isRepeating || this.noNulls || !this.isNull[0]) {
            this.keys.unFlatten();
            this.values.unFlatten();
        }
    }
}

