/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.TagMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.TagPO;
import org.apache.ibatis.annotations.Param;

public class TagMetaPostgreSQLProvider
extends TagMetaBaseSQLProvider {
    @Override
    public String softDeleteTagMetaByMetalakeAndTagName(String metalakeName, String tagName) {
        return "UPDATE tag_meta tm SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE tm.metalake_id IN ( SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND tm.tag_name = #{tagName} AND tm.deleted_at = 0";
    }

    @Override
    public String softDeleteTagMetasByMetalakeId(Long metalakeId) {
        return "UPDATE tag_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String insertTagMetaOnDuplicateKeyUpdate(TagPO tagPO) {
        return "INSERT INTO tag_meta (tag_id, tag_name, metalake_id, tag_comment, properties, audit_info, current_version, last_version, deleted_at) VALUES ( #{tagMeta.tagId}, #{tagMeta.tagName}, #{tagMeta.metalakeId}, #{tagMeta.comment}, #{tagMeta.properties}, #{tagMeta.auditInfo}, #{tagMeta.currentVersion}, #{tagMeta.lastVersion}, #{tagMeta.deletedAt} ) ON CONFLICT(tag_id) DO UPDATE SET tag_name = #{tagMeta.tagName}, metalake_id = #{tagMeta.metalakeId}, tag_comment = #{tagMeta.comment}, properties = #{tagMeta.properties}, audit_info = #{tagMeta.auditInfo}, current_version = #{tagMeta.currentVersion}, last_version = #{tagMeta.lastVersion}, deleted_at = #{tagMeta.deletedAt}";
    }

    @Override
    public String updateTagMeta(@Param(value="newTagMeta") TagPO newTagPO, @Param(value="oldTagMeta") TagPO oldTagPO) {
        return "UPDATE tag_meta SET tag_name = #{newTagMeta.tagName}, tag_comment = #{newTagMeta.comment}, properties = #{newTagMeta.properties}, audit_info = #{newTagMeta.auditInfo}, current_version = #{newTagMeta.currentVersion}, last_version = #{newTagMeta.lastVersion}, deleted_at = #{newTagMeta.deletedAt} WHERE tag_id = #{oldTagMeta.tagId} AND metalake_id = #{oldTagMeta.metalakeId} AND tag_name = #{oldTagMeta.tagName} AND (tag_comment = #{oldTagMeta.comment}    OR (CAST(tag_comment AS VARCHAR) IS NULL AND CAST(#{oldTagMeta.comment} AS VARCHAR) IS NULL)) AND properties = #{oldTagMeta.properties} AND audit_info = #{oldTagMeta.auditInfo} AND current_version = #{oldTagMeta.currentVersion} AND last_version = #{oldTagMeta.lastVersion} AND deleted_at = 0";
    }

    @Override
    public String deleteTagMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM tag_meta WHERE tag_id IN (SELECT tag_id FROM tag_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

