/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.util;

import com.lancedb.lance.namespace.util.ValidationUtil;
import java.util.List;

public class PageUtil {
    private PageUtil() {
    }

    public static Page splitPage(List<String> items, String pageToken, int pageSize) {
        int left;
        if (!ValidationUtil.isNullOrEmpty(pageToken)) {
            for (left = 0; left < items.size() && items.get(left).compareTo(pageToken) < 0; ++left) {
            }
        }
        int right = pageSize == Integer.MAX_VALUE ? items.size() : Math.min(left + pageSize, items.size());
        List<String> pageItems = items.subList(left, right);
        String nextPageToken = right == items.size() ? null : items.get(right);
        return new Page(pageItems, nextPageToken);
    }

    public static int normalizePageSize(Integer pageSize) {
        if (pageSize == null) {
            return Integer.MAX_VALUE;
        }
        ValidationUtil.checkArgument(pageSize > 0, "Page size must be greater than 0", new Object[0]);
        return pageSize;
    }

    public static class Page {
        private List<String> items;
        private String nextPageToken;

        public Page(List<String> items, String nextPageToken) {
            this.items = items;
            this.nextPageToken = nextPageToken;
        }

        public List<String> items() {
            return this.items;
        }

        public String nextPageToken() {
            return this.nextPageToken;
        }
    }
}

