/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import java.util.HashSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParseException;
import org.apache.hadoop.yarn.server.timelineservice.reader.TimelineParserForEqualityExpr;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineCompareOp;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineFilter;
import org.apache.hadoop.yarn.server.timelineservice.reader.filter.TimelineKeyValuesFilter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class TimelineParserForRelationFilters
extends TimelineParserForEqualityExpr {
    private final String valueDelimiter;

    public TimelineParserForRelationFilters(String expression, char valuesDelim, String valueDelim) {
        super(expression, "Relation Filter", valuesDelim);
        this.valueDelimiter = valueDelim;
    }

    @Override
    protected TimelineFilter createFilter() {
        return new TimelineKeyValuesFilter();
    }

    @Override
    protected void setCompareOpToCurrentFilter(TimelineCompareOp compareOp) {
        ((TimelineKeyValuesFilter)this.getCurrentFilter()).setCompareOp(compareOp);
    }

    @Override
    protected void setValueToCurrentFilter(String value) throws TimelineParseException {
        if (value != null) {
            String[] pairStrs = value.split(this.valueDelimiter);
            if (pairStrs.length < 2) {
                throw new TimelineParseException("Invalid relation filter expression");
            }
            String key = pairStrs[0].trim();
            HashSet<Object> values = new HashSet<Object>();
            for (int i = 1; i < pairStrs.length; ++i) {
                values.add(pairStrs[i].trim());
            }
            ((TimelineKeyValuesFilter)this.getCurrentFilter()).setKeyAndValues(key, values);
        }
    }
}

