/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.comparators;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;

public class UniqueMemberComparator
extends LdapComparator<String> {
    private static final long serialVersionUID = 2L;
    private SchemaManager schemaManager;

    public UniqueMemberComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(String dnstr1, String dnstr2) {
        int dash1 = dnstr1.lastIndexOf(35);
        int dash2 = dnstr2.lastIndexOf(35);
        if (dash1 == -1 && dash2 == -1) {
            try {
                Dn dn1 = this.getDn(dnstr1);
                Dn dn2 = this.getDn(dnstr2);
                if (dn1.equals(dn2)) {
                    return 0;
                }
                return -1;
            }
            catch (LdapInvalidDnException ne) {
                return -1;
            }
        }
        if (dnstr1.indexOf(35) != dash1) {
            return -1;
        }
        if (dnstr2.indexOf(35) != dash1) {
            return 1;
        }
        Dn dn1 = null;
        Dn dn2 = null;
        String uid1 = dnstr1.substring(dash1 + 1);
        if (dash1 > 0) {
            try {
                dn1 = new Dn(dnstr1.substring(0, dash1));
            }
            catch (LdapException ne) {
                return -1;
            }
        } else {
            return -1;
        }
        String uid2 = dnstr2.substring(dash2 + 1);
        if (dash2 > 0) {
            try {
                dn2 = new Dn(dnstr1.substring(0, dash2));
            }
            catch (LdapException ne) {
                return 1;
            }
        } else {
            return 1;
        }
        if (dn1.equals(dn2)) {
            return uid1.compareTo(uid2);
        }
        return -1;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public Dn getDn(Object obj) throws LdapInvalidDnException {
        Dn dn = null;
        if (obj instanceof Dn) {
            dn = (Dn)obj;
            dn = dn.isSchemaAware() ? dn : dn.apply(this.schemaManager);
        } else if (obj instanceof String) {
            dn = new Dn(this.schemaManager, (String)obj);
        } else {
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_04218, (Object[])new Object[]{obj == null ? null : obj.getClass()}));
        }
        return dn;
    }
}

