/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HostConfigManager;
import org.apache.hadoop.hdfs.server.blockmanagement.HostFileManager;
import org.apache.hadoop.hdfs.util.CombinedHostsFileWriter;
import org.junit.Assert;

public class HostsFileWriter {
    private FileSystem localFileSys;
    private Path fullDir;
    private Path excludeFile;
    private Path includeFile;
    private Path combinedFile;
    private boolean isLegacyHostsFile = false;

    public void initialize(Configuration conf, String dir) throws IOException {
        this.localFileSys = FileSystem.getLocal((Configuration)conf);
        Path workingDir = new Path(MiniDFSCluster.getBaseDirectory());
        this.fullDir = new Path(workingDir, dir);
        this.cleanup();
        Assert.assertTrue((boolean)this.localFileSys.mkdirs(this.fullDir));
        if (conf.getClass("dfs.namenode.hosts.provider.classname", HostFileManager.class, HostConfigManager.class).equals(HostFileManager.class)) {
            this.isLegacyHostsFile = true;
        }
        if (this.isLegacyHostsFile) {
            this.excludeFile = new Path(this.fullDir, "exclude");
            this.includeFile = new Path(this.fullDir, "include");
            DFSTestUtil.writeFile(this.localFileSys, this.excludeFile, "");
            DFSTestUtil.writeFile(this.localFileSys, this.includeFile, "");
            conf.set("dfs.hosts.exclude", this.excludeFile.toUri().getPath());
            conf.set("dfs.hosts", this.includeFile.toUri().getPath());
        } else {
            this.combinedFile = new Path(this.fullDir, "all");
            conf.set("dfs.hosts", this.combinedFile.toString());
        }
    }

    public void initExcludeHost(String hostNameAndPort) throws IOException {
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(hostNameAndPort);
        this.initExcludeHosts(nodes);
    }

    public void initExcludeHosts(List<String> hostNameAndPorts) throws IOException {
        this.initOutOfServiceHosts(hostNameAndPorts, null);
    }

    public void initOutOfServiceHosts(List<String> decommissionHostNameAndPorts, Map<String, Long> maintenanceHosts) throws IOException {
        StringBuilder excludeHosts = new StringBuilder();
        if (this.isLegacyHostsFile) {
            if (maintenanceHosts != null && maintenanceHosts.size() > 0) {
                throw new UnsupportedOperationException("maintenance support isn't supported by legacy hosts file");
            }
            for (String hostNameAndPort : decommissionHostNameAndPorts) {
                excludeHosts.append(hostNameAndPort).append("\n");
            }
            DFSTestUtil.writeFile(this.localFileSys, this.excludeFile, excludeHosts.toString());
        } else {
            String[] hostAndPort;
            DatanodeAdminProperties dn;
            HashSet<DatanodeAdminProperties> allDNs = new HashSet<DatanodeAdminProperties>();
            if (decommissionHostNameAndPorts != null) {
                for (String string : decommissionHostNameAndPorts) {
                    dn = new DatanodeAdminProperties();
                    hostAndPort = string.split(":");
                    dn.setHostName(hostAndPort[0]);
                    dn.setPort(Integer.parseInt(hostAndPort[1]));
                    dn.setAdminState(DatanodeInfo.AdminStates.DECOMMISSIONED);
                    allDNs.add(dn);
                }
            }
            if (maintenanceHosts != null) {
                for (Map.Entry entry : maintenanceHosts.entrySet()) {
                    dn = new DatanodeAdminProperties();
                    hostAndPort = ((String)entry.getKey()).split(":");
                    dn.setHostName(hostAndPort[0]);
                    dn.setPort(Integer.parseInt(hostAndPort[1]));
                    dn.setAdminState(DatanodeInfo.AdminStates.IN_MAINTENANCE);
                    dn.setMaintenanceExpireTimeInMS(((Long)entry.getValue()).longValue());
                    allDNs.add(dn);
                }
            }
            CombinedHostsFileWriter.writeFile((String)this.combinedFile.toString(), allDNs);
        }
    }

    public void initIncludeHost(String hostNameAndPort) throws IOException {
        this.initIncludeHosts(new String[]{hostNameAndPort});
    }

    public void initIncludeHosts(String[] hostNameAndPorts) throws IOException {
        StringBuilder includeHosts = new StringBuilder();
        if (this.isLegacyHostsFile) {
            for (String hostNameAndPort : hostNameAndPorts) {
                includeHosts.append(hostNameAndPort).append("\n");
            }
            DFSTestUtil.writeFile(this.localFileSys, this.includeFile, includeHosts.toString());
        } else {
            HashSet<DatanodeAdminProperties> allDNs = new HashSet<DatanodeAdminProperties>();
            for (String hostNameAndPort : hostNameAndPorts) {
                String[] hostAndPort = hostNameAndPort.split(":");
                DatanodeAdminProperties dn = new DatanodeAdminProperties();
                dn.setHostName(hostAndPort[0]);
                dn.setPort(Integer.parseInt(hostAndPort[1]));
                allDNs.add(dn);
            }
            CombinedHostsFileWriter.writeFile((String)this.combinedFile.toString(), allDNs);
        }
    }

    public void initIncludeHosts(DatanodeAdminProperties[] datanodes) throws IOException {
        CombinedHostsFileWriter.writeFile((String)this.combinedFile.toString(), new HashSet<DatanodeAdminProperties>(Arrays.asList(datanodes)));
    }

    public void cleanup() throws IOException {
        if (this.localFileSys.exists(this.fullDir)) {
            FileUtils.deleteQuietly((File)new File(this.fullDir.toUri().getPath()));
        }
    }

    public Path getIncludeFile() {
        return this.includeFile;
    }

    public Path getExcludeFile() {
        return this.excludeFile;
    }
}

