/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerChore;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerManager;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorkQueue;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorker;
import org.apache.hadoop.hbase.master.normalizer.SimpleRegionNormalizer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.zookeeper.RegionNormalizerTracker;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.RateLimiter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionNormalizerManagerConfigurationObserver {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionNormalizerManagerConfigurationObserver.class);
    private static final HBaseTestingUtility testUtil = new HBaseTestingUtility();
    private static final Pattern rateLimitPattern = Pattern.compile("RateLimiter\\[stableRate=(?<rate>.+)qps]");
    private Configuration conf;
    private SimpleRegionNormalizer normalizer;
    @Mock
    private MasterServices masterServices;
    @Mock
    private RegionNormalizerTracker tracker;
    @Mock
    private RegionNormalizerChore chore;
    @Mock
    private RegionNormalizerWorkQueue<TableName> queue;
    private RegionNormalizerWorker worker;
    private ConfigurationManager configurationManager;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.conf = testUtil.getConfiguration();
        this.normalizer = new SimpleRegionNormalizer();
        this.worker = new RegionNormalizerWorker(this.conf, this.masterServices, (RegionNormalizer)this.normalizer, this.queue);
        RegionNormalizerManager normalizerManager = new RegionNormalizerManager(this.tracker, this.chore, this.queue, this.worker);
        this.configurationManager = new ConfigurationManager();
        this.configurationManager.registerObserver((ConfigurationObserver)normalizerManager);
    }

    @Test
    public void test() {
        Assert.assertTrue((boolean)this.normalizer.isMergeEnabled());
        Assert.assertEquals((long)3L, (long)this.normalizer.getMergeMinRegionCount());
        Assert.assertEquals((long)1000000L, (long)TestRegionNormalizerManagerConfigurationObserver.parseConfiguredRateLimit(this.worker.getRateLimiter()));
        Configuration newConf = new Configuration(this.conf);
        newConf.setBoolean("hbase.normalizer.merge.enabled", false);
        newConf.setInt("hbase.normalizer.merge.min.region.count", 100);
        newConf.set("hbase.normalizer.throughput.max_bytes_per_sec", "12g");
        this.configurationManager.notifyAllObservers(newConf);
        Assert.assertFalse((boolean)this.normalizer.isMergeEnabled());
        Assert.assertEquals((long)100L, (long)this.normalizer.getMergeMinRegionCount());
        Assert.assertEquals((long)12884L, (long)TestRegionNormalizerManagerConfigurationObserver.parseConfiguredRateLimit(this.worker.getRateLimiter()));
    }

    private static long parseConfiguredRateLimit(RateLimiter rateLimiter) {
        String val = rateLimiter.toString();
        Matcher matcher = rateLimitPattern.matcher(val);
        Assert.assertTrue((boolean)matcher.matches());
        String parsedRate = matcher.group("rate");
        return (long)Double.parseDouble(parsedRate);
    }
}

