/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSchedulerQueueDeadLock {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSchedulerQueueDeadLock.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"deadlock");
    private WALProcedureStore procStore;
    private ProcedureExecutor<TestEnv> procExec;
    @Rule
    public final TestName name = new TestName();

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        UTIL.cleanupTestDir();
    }

    @Before
    public void setUp() throws IOException {
        UTIL.getConfiguration().setInt("hbase.procedure.worker.stuck.threshold.msec", 6000000);
        this.procStore = ProcedureTestingUtility.createWalStore((Configuration)UTIL.getConfiguration(), (Path)UTIL.getDataTestDir(this.name.getMethodName()));
        this.procStore.start(1);
        MasterProcedureScheduler scheduler = new MasterProcedureScheduler(pid -> null);
        this.procExec = new ProcedureExecutor(UTIL.getConfiguration(), (Object)new TestEnv(scheduler), (ProcedureStore)this.procStore, (ProcedureScheduler)scheduler);
        this.procExec.init(1, false);
    }

    @After
    public void tearDown() {
        this.procExec.stop();
        this.procStore.stop(false);
    }

    @Test
    public void testTableProcedureDeadLockAfterRestarting() throws Exception {
        long procId1 = this.procExec.submitProcedure((Procedure)new TableSharedProcedureWithId());
        long procId2 = this.procExec.submitProcedure((Procedure)new TableExclusiveProcedureWithId());
        this.procExec.startWorkers();
        UTIL.waitFor(10000L, () -> ((TableSharedProcedure)this.procExec.getProcedure(procId1)).latch.hasQueuedThreads());
        ProcedureTestingUtility.restart(this.procExec);
        ((TableSharedProcedure)this.procExec.getProcedure(procId1)).latch.release();
        ((TableExclusiveProcedure)this.procExec.getProcedure(procId2)).latch.release();
        UTIL.waitFor(10000L, () -> this.procExec.isFinished(procId1));
        UTIL.waitFor(10000L, () -> this.procExec.isFinished(procId2));
    }

    @Test
    public void testTableProcedureSubProcedureDeadLock() throws Exception {
        long procId1 = this.procExec.submitProcedure((Procedure)new TableShardParentProcedure());
        long procId2 = this.procExec.submitProcedure((Procedure)new TableExclusiveProcedure());
        this.procExec.startWorkers();
        UTIL.waitFor(10000L, () -> this.procExec.getProcedures().stream().anyMatch(p -> p instanceof TableSharedProcedure));
        this.procExec.getProcedures().stream().filter(p -> p instanceof TableSharedProcedure).map(p -> (TableSharedProcedure)((Object)p)).forEach(p -> ((TableSharedProcedure)p).latch.release());
        ((TableExclusiveProcedure)this.procExec.getProcedure(procId2)).latch.release();
        UTIL.waitFor(10000L, () -> this.procExec.isFinished(procId1));
        UTIL.waitFor(10000L, () -> this.procExec.isFinished(procId2));
    }

    public static final class TableShardParentProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestEnv>
    implements TableProcedureInterface {
        private boolean scheduled;

        protected Procedure<TestEnv>[] execute(TestEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            if (!this.scheduled) {
                this.scheduled = true;
                return new Procedure[]{new TableSharedProcedure()};
            }
            return null;
        }

        protected Procedure.LockState acquireLock(TestEnv env) {
            if (env.getScheduler().waitTableSharedLock((Procedure)this, this.getTableName())) {
                return Procedure.LockState.LOCK_EVENT_WAIT;
            }
            return Procedure.LockState.LOCK_ACQUIRED;
        }

        protected void releaseLock(TestEnv env) {
            env.getScheduler().wakeTableSharedLock((Procedure)this, this.getTableName());
        }

        protected boolean holdLock(TestEnv env) {
            return true;
        }

        public TableName getTableName() {
            return TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.READ;
        }
    }

    public static final class TableExclusiveProcedureWithId
    extends TableExclusiveProcedure {
        protected void setProcId(long procId) {
            super.setProcId(1L);
        }
    }

    public static final class TableSharedProcedureWithId
    extends TableSharedProcedure {
        protected void setProcId(long procId) {
            super.setProcId(2L);
        }
    }

    public static class TableExclusiveProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestEnv>
    implements TableProcedureInterface {
        private final Semaphore latch = new Semaphore(0);

        protected Procedure<TestEnv>[] execute(TestEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            this.latch.acquire();
            return null;
        }

        protected Procedure.LockState acquireLock(TestEnv env) {
            if (env.getScheduler().waitTableExclusiveLock((Procedure)this, this.getTableName())) {
                return Procedure.LockState.LOCK_EVENT_WAIT;
            }
            return Procedure.LockState.LOCK_ACQUIRED;
        }

        protected void releaseLock(TestEnv env) {
            env.getScheduler().wakeTableExclusiveLock((Procedure)this, this.getTableName());
        }

        protected boolean holdLock(TestEnv env) {
            return true;
        }

        public TableName getTableName() {
            return TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.EDIT;
        }
    }

    public static class TableSharedProcedure
    extends ProcedureTestingUtility.NoopProcedure<TestEnv>
    implements TableProcedureInterface {
        private final Semaphore latch = new Semaphore(0);

        protected Procedure<TestEnv>[] execute(TestEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            this.latch.acquire();
            return null;
        }

        protected Procedure.LockState acquireLock(TestEnv env) {
            if (env.getScheduler().waitTableSharedLock((Procedure)this, this.getTableName())) {
                return Procedure.LockState.LOCK_EVENT_WAIT;
            }
            return Procedure.LockState.LOCK_ACQUIRED;
        }

        protected void releaseLock(TestEnv env) {
            env.getScheduler().wakeTableSharedLock((Procedure)this, this.getTableName());
        }

        protected boolean holdLock(TestEnv env) {
            return true;
        }

        public TableName getTableName() {
            return TABLE_NAME;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.READ;
        }
    }

    private static final class TestEnv {
        private final MasterProcedureScheduler scheduler;

        public TestEnv(MasterProcedureScheduler scheduler) {
            this.scheduler = scheduler;
        }

        public MasterProcedureScheduler getScheduler() {
            return this.scheduler;
        }
    }
}

