/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncAdminBuilder;
import org.apache.hadoop.hbase.client.AsyncBufferedMutatorBuilder;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.AsyncTableRegionLocator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.DummyAsyncTable;
import org.apache.hadoop.hbase.client.DummyConnectionRegistry;
import org.apache.hadoop.hbase.client.Hbck;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.ScanResultConsumer;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSink;
import org.apache.hadoop.hbase.replication.regionserver.TestReplicationSink;
import org.apache.hadoop.hbase.replication.regionserver.WALEntrySinkFilter;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestWALEntrySinkFilter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALEntrySinkFilter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationSink.class);
    @Rule
    public TestName name = new TestName();
    static final int BOUNDARY = 5;
    static final AtomicInteger UNFILTERED = new AtomicInteger();
    static final AtomicInteger FILTERED = new AtomicInteger();
    private static Stoppable STOPPABLE = new Stoppable(){
        private final AtomicBoolean stop = new AtomicBoolean(false);

        public boolean isStopped() {
            return this.stop.get();
        }

        public void stop(String why) {
            LOG.info("STOPPING BECAUSE: " + why);
            this.stop.set(true);
        }
    };

    @Test
    public void testWALEntryFilter() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.setClass("hbase.client.registry.impl", DevNullConnectionRegistry.class, DummyConnectionRegistry.class);
        conf.setClass("hbase.replication.sink.walentrysinkfilter", IfTimeIsGreaterThanBOUNDARYWALEntrySinkFilterImpl.class, WALEntrySinkFilter.class);
        conf.setClass("hbase.client.async.connection.impl", DevNullAsyncConnection.class, AsyncConnection.class);
        ReplicationSink sink = new ReplicationSink(conf, null);
        ArrayList<AdminProtos.WALEntry> entries = new ArrayList<AdminProtos.WALEntry>();
        AdminProtos.WALEntry.Builder entryBuilder = AdminProtos.WALEntry.newBuilder();
        ByteString tableName = ByteString.copyFromUtf8((String)TableName.valueOf((String)this.name.getMethodName()).toString());
        final ArrayList<Cell> cells = new ArrayList<Cell>();
        int count = 10;
        for (int i = 0; i < count; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            entryBuilder.clear();
            entryBuilder.setKey(entryBuilder.getKeyBuilder().setLogSequenceNumber((long)i).setEncodedRegionName(ByteString.copyFrom((byte[])bytes)).setWriteTime((long)i).setTableName(tableName).build());
            entryBuilder.setAssociatedCellCount(1);
            entries.add(entryBuilder.build());
            CellBuilder cellBuilder = CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY);
            Cell cell = cellBuilder.setRow(bytes).setFamily(bytes).setQualifier(bytes).setType(Cell.Type.Put).setTimestamp((long)i).setValue(bytes).build();
            cells.add(cell);
        }
        CellScanner cellScanner = new CellScanner(){
            int index = -1;

            public Cell current() {
                return (Cell)cells.get(this.index);
            }

            public boolean advance() throws IOException {
                ++this.index;
                return this.index < cells.size();
            }
        };
        sink.replicateEntries(entries, cellScanner, null, null, null);
        Assert.assertTrue((FILTERED.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((UNFILTERED.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)count, (long)(FILTERED.get() + UNFILTERED.get()));
    }

    public static class DevNullAsyncConnection
    implements AsyncConnection {
        private final Configuration conf;

        public DevNullAsyncConnection(Configuration conf, ConnectionRegistry registry, String clusterId, User user) {
            this.conf = conf;
        }

        public AsyncTableRegionLocator getRegionLocator(TableName tableName) {
            return null;
        }

        public void clearRegionLocationCache() {
        }

        public AsyncTableBuilder<AdvancedScanResultConsumer> getTableBuilder(TableName tableName) {
            return null;
        }

        public AsyncTableBuilder<ScanResultConsumer> getTableBuilder(TableName tableName, ExecutorService pool) {
            return null;
        }

        public AsyncAdminBuilder getAdminBuilder() {
            return null;
        }

        public AsyncAdminBuilder getAdminBuilder(ExecutorService pool) {
            return null;
        }

        public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName) {
            return null;
        }

        public AsyncBufferedMutatorBuilder getBufferedMutatorBuilder(TableName tableName, ExecutorService pool) {
            return null;
        }

        public CompletableFuture<Hbck> getHbck() {
            return null;
        }

        public Hbck getHbck(ServerName masterServer) throws IOException {
            return null;
        }

        public boolean isClosed() {
            return false;
        }

        public void close() throws IOException {
        }

        public AsyncTable<AdvancedScanResultConsumer> getTable(TableName tableName) {
            return new DummyAsyncTable<AdvancedScanResultConsumer>(){

                public <T> CompletableFuture<List<T>> batchAll(List<? extends Row> actions) {
                    ArrayList<Object> list = new ArrayList<Object>(actions.size());
                    for (Row row : actions) {
                        int row2 = Bytes.toInt((byte[])row.getRow());
                        Assert.assertTrue((String)("" + row2), (row2 > 5 ? 1 : 0) != 0);
                        UNFILTERED.incrementAndGet();
                        list.add(null);
                    }
                    return CompletableFuture.completedFuture(list);
                }
            };
        }

        public Configuration getConfiguration() {
            return this.conf;
        }
    }

    public static class DevNullConnectionRegistry
    extends DummyConnectionRegistry {
        public DevNullConnectionRegistry(Configuration conf) {
        }

        @Override
        public CompletableFuture<String> getClusterId() {
            return CompletableFuture.completedFuture("test");
        }
    }

    public static class IfTimeIsGreaterThanBOUNDARYWALEntrySinkFilterImpl
    implements WALEntrySinkFilter {
        public void init(Connection connection) {
        }

        public boolean filter(TableName table, long writeTime) {
            boolean b;
            boolean bl = b = writeTime <= 5L;
            if (b) {
                FILTERED.incrementAndGet();
            }
            return b;
        }
    }
}

