/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege.grant;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrincipalDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Grant", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class GrantDesc
implements DDLDesc,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final PrivilegeObjectDesc privilegeSubject;
    private final List<PrivilegeDesc> privileges;
    private final List<PrincipalDesc> principals;
    private final String grantor;
    private final PrincipalType grantorType;
    private final boolean grantOption;

    public GrantDesc(PrivilegeObjectDesc privilegeSubject, List<PrivilegeDesc> privileges, List<PrincipalDesc> principals, String grantor, PrincipalType grantorType, boolean grantOption) {
        this.privilegeSubject = privilegeSubject;
        this.privileges = privileges;
        this.principals = principals;
        this.grantor = grantor;
        this.grantorType = grantorType;
        this.grantOption = grantOption;
    }

    @Explain(skipHeader=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public PrivilegeObjectDesc getPrivilegeSubject() {
        return this.privilegeSubject;
    }

    @Explain(displayName="Privileges", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<PrivilegeDesc> getPrivileges() {
        return this.privileges;
    }

    @Explain(displayName="Principals", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<PrincipalDesc> getPrincipals() {
        return this.principals;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public PrincipalType getGrantorType() {
        return this.grantorType;
    }

    @Explain(displayName="grant option", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isGrantOption() {
        return this.grantOption;
    }
}

