/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.handler.TenantAwareHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sessiondict.rpc.proto.GetReply;
import org.apache.bifromq.sessiondict.rpc.proto.GetRequest;
import org.apache.bifromq.type.ClientInfo;

@Path(value="/session")
final class GetSessionInfoHandler
extends TenantAwareHandler {
    private final ISessionDictClient sessionDictClient;

    GetSessionInfoHandler(ISettingProvider settingProvider, ISessionDictClient sessionDictClient) {
        super(settingProvider);
        this.sessionDictClient = sessionDictClient;
    }

    @Override
    @GET
    @Operation(summary="Get the session information of the given user and client id")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="tenant_id", in=ParameterIn.HEADER, required=true, description="the id of tenant", schema=@Schema(implementation=String.class)), @Parameter(name="user_id", in=ParameterIn.HEADER, required=true, description="the id of user who established the session", schema=@Schema(implementation=String.class)), @Parameter(name="client_id", in=ParameterIn.HEADER, required=true, description="the client id of the mqtt session", schema=@Schema(implementation=String.class))})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="No session found for the given user and client id", content={@Content(schema=@Schema(implementation=String.class))})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) String tenantId, @Parameter(hidden=true) FullHttpRequest req) {
        String userId = HeaderUtils.getHeader(Headers.HEADER_USER_ID, (HttpRequest)req, true);
        String clientId = HeaderUtils.getHeader(Headers.HEADER_CLIENT_ID, (HttpRequest)req, true);
        return this.sessionDictClient.get(GetRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setUserId(userId).setClientId(clientId).build()).thenApply(reply -> switch (reply.getResult()) {
            case GetReply.Result.OK -> {
                DefaultFullHttpResponse resp = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.toJSON(reply.getOwner()).getBytes()));
                resp.headers().set("Content-Type", (Object)"application/json");
                yield resp;
            }
            case GetReply.Result.NOT_FOUND -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.EMPTY_BUFFER);
            default -> new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER);
        });
    }

    private String toJSON(ClientInfo clientInfo) {
        return JsonFormat.printer().print((MessageOrBuilder)clientInfo);
    }
}

