/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basescheduler;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import org.apache.bifromq.basescheduler.BatchCallWeighterFactory;
import org.apache.bifromq.basescheduler.Batcher;
import org.apache.bifromq.basescheduler.CallSchedulerFactory;
import org.apache.bifromq.basescheduler.CapacityEstimatorFactory;
import org.apache.bifromq.basescheduler.IBatchCallBuilderFactory;
import org.apache.bifromq.basescheduler.IBatchCallScheduler;
import org.apache.bifromq.basescheduler.exception.AbortException;
import org.apache.bifromq.basescheduler.exception.BatcherUnavailableException;
import org.apache.bifromq.basescheduler.spi.ICallScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchCallScheduler<CallT, CallResultT, BatcherKeyT>
implements IBatchCallScheduler<CallT, CallResultT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchCallScheduler.class);
    private static final int BATCHER_EXPIRY_SECONDS = 600;
    private final ICallScheduler<CallT> callScheduler;
    private final LoadingCache<BatcherKeyT, Batcher<CallT, CallResultT, BatcherKeyT>> batchers;
    private final LongAdder runningCalls = new LongAdder();
    private final Gauge runningCallsGauge;
    private final Gauge batcherNumGauge;
    private final Counter callSchedCounter;
    private final Counter callSubmitCounter;

    protected BatchCallScheduler(IBatchCallBuilderFactory<CallT, CallResultT, BatcherKeyT> batchCallFactory, long maxBurstLatency) {
        String name = this.getName();
        this.callScheduler = CallSchedulerFactory.INSTANCE.create(name);
        this.batchers = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterAccess(Duration.ofSeconds(600L)).evictionListener((key, value, removalCause) -> {
            if (value != null) {
                value.close();
            }
        }).build(k -> new Batcher(name, k, batchCallFactory.newBuilder(name, k), maxBurstLatency, CapacityEstimatorFactory.INSTANCE.get(name, k), BatchCallWeighterFactory.INSTANCE.create(name, this.getReqType())));
        this.runningCallsGauge = Gauge.builder((String)"batcher.call.running.gauge", this.runningCalls::sum).tags(new String[]{"name", name}).register((MeterRegistry)Metrics.globalRegistry);
        this.batcherNumGauge = Gauge.builder((String)"batcher.num", () -> this.batchers.estimatedSize()).tags(new String[]{"name", name}).register((MeterRegistry)Metrics.globalRegistry);
        this.callSchedCounter = Counter.builder((String)"batcher.call.sched.count").tags(new String[]{"name", name}).register((MeterRegistry)Metrics.globalRegistry);
        this.callSubmitCounter = Counter.builder((String)"batcher.call.submit.count").tags(new String[]{"name", name}).register((MeterRegistry)Metrics.globalRegistry);
    }

    protected abstract Optional<BatcherKeyT> find(CallT var1);

    @Override
    public CompletableFuture<CallResultT> schedule(CallT request) {
        this.callSchedCounter.increment();
        this.runningCalls.increment();
        return ((CompletableFuture)this.callScheduler.submit(request).thenCompose(req -> {
            try {
                Optional<BatcherKeyT> batcherKey = this.find(req);
                if (batcherKey.isPresent()) {
                    Batcher batcher = (Batcher)this.batchers.get(batcherKey.get());
                    this.callSubmitCounter.increment();
                    return batcher.submit(batcherKey.get(), req);
                }
                return CompletableFuture.failedFuture(new BatcherUnavailableException("Batcher not found"));
            }
            catch (Throwable e) {
                log.error("Error", e);
                return CompletableFuture.failedFuture(new AbortException("Failed to submit request", e));
            }
        })).whenComplete((v, e) -> this.runningCalls.decrement());
    }

    @Override
    public void close() {
        CompletableFuture.allOf((CompletableFuture[])this.batchers.asMap().values().stream().map(Batcher::close).toArray(CompletableFuture[]::new)).join();
        this.batchers.invalidateAll();
        this.callScheduler.close();
        CapacityEstimatorFactory.INSTANCE.close();
        Metrics.globalRegistry.remove((Meter)this.runningCallsGauge);
        Metrics.globalRegistry.remove((Meter)this.batcherNumGauge);
        Metrics.globalRegistry.remove((Meter)this.callSubmitCounter);
        Metrics.globalRegistry.remove((Meter)this.callSchedCounter);
    }

    private Class<CallT> getReqType() {
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        return (Class)type;
    }

    private String getName() {
        String typeName = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0].getTypeName();
        if (typeName.lastIndexOf(".") > 0) {
            typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
        }
        return "scheduler[" + typeName + "]";
    }
}

