/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.protobuf.ByteString;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.Headers;
import org.apache.bifromq.apiserver.http.handler.AbstractLandscapeHandler;
import org.apache.bifromq.apiserver.http.handler.utils.HeaderUtils;
import org.apache.bifromq.apiserver.http.handler.utils.JSONUtils;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeObserver;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;

@Path(value="/store/ranges")
class GetStoreRangesHandler
extends AbstractLandscapeHandler {
    GetStoreRangesHandler(IBaseKVMetaService metaService) {
        super(metaService);
    }

    @Override
    @GET
    @Operation(summary="Get the ranges information in a store node")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class)), @Parameter(name="store_name", in=ParameterIn.HEADER, required=true, description="the store name", schema=@Schema(implementation=String.class)), @Parameter(name="store_id", in=ParameterIn.HEADER, required=true, description="the store id", schema=@Schema(implementation=String.class))})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="Store or store server not found", content={@Content(schema=@Schema(implementation=String.class))})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) FullHttpRequest req) {
        String storeName = HeaderUtils.getHeader(Headers.HEADER_STORE_NAME, (HttpRequest)req, true);
        IBaseKVLandscapeObserver landscapeObserver = (IBaseKVLandscapeObserver)this.landscapeObservers.get(storeName);
        if (landscapeObserver == null) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])("Store not found: " + storeName).getBytes())));
        }
        String storeId = HeaderUtils.getHeader(Headers.HEADER_STORE_ID, (HttpRequest)req, true);
        Optional storeDescriptor = landscapeObserver.getStoreDescriptor(storeId);
        if (storeDescriptor.isEmpty()) {
            return CompletableFuture.completedFuture(new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.NOT_FOUND, Unpooled.copiedBuffer((byte[])("Store server not found: " + storeId).getBytes())));
        }
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.toJSON(((KVRangeStoreDescriptor)storeDescriptor.get()).getRangesList()).getBytes()));
        resp.headers().set("Content-Type", (Object)"application/json");
        return CompletableFuture.completedFuture(resp);
    }

    private String toJSON(List<KVRangeDescriptor> rangeDescriptors) {
        ArrayNode rootObject = JSONUtils.MAPPER.createArrayNode();
        for (KVRangeDescriptor rangeDescriptor : rangeDescriptors) {
            rootObject.add(this.toJSON(rangeDescriptor));
        }
        return rootObject.toString();
    }

    private JsonNode toJSON(KVRangeDescriptor descriptor) {
        ObjectNode rangeObject = JSONUtils.MAPPER.createObjectNode();
        rangeObject.put("id", descriptor.getId().getEpoch() + "_" + descriptor.getId().getId());
        rangeObject.put("ver", descriptor.getVer());
        rangeObject.set("boundary", this.toJSON(descriptor.getBoundary()));
        rangeObject.put("state", descriptor.getState().name());
        rangeObject.put("role", descriptor.getRole().name());
        rangeObject.set("clusterConfig", this.toJSON(descriptor.getConfig()));
        return rangeObject;
    }

    private JsonNode toJSON(Boundary boundary) {
        ObjectNode boundaryObject = JSONUtils.MAPPER.createObjectNode();
        boundaryObject.put("startKey", boundary.hasStartKey() ? this.toHex(boundary.getStartKey()) : null);
        boundaryObject.put("endKey", boundary.hasEndKey() ? this.toHex(boundary.getEndKey()) : null);
        return boundaryObject;
    }

    private JsonNode toJSON(ClusterConfig config) {
        ObjectNode clusterConfigObject = JSONUtils.MAPPER.createObjectNode();
        ArrayNode votersArray = JSONUtils.MAPPER.createArrayNode();
        config.getVotersList().forEach(arg_0 -> ((ArrayNode)votersArray).add(arg_0));
        clusterConfigObject.set("voters", (JsonNode)votersArray);
        ArrayNode learnersArray = JSONUtils.MAPPER.createArrayNode();
        config.getLearnersList().forEach(arg_0 -> ((ArrayNode)learnersArray).add(arg_0));
        clusterConfigObject.set("learners", (JsonNode)learnersArray);
        ArrayNode nextVotersArray = JSONUtils.MAPPER.createArrayNode();
        config.getNextVotersList().forEach(arg_0 -> ((ArrayNode)nextVotersArray).add(arg_0));
        clusterConfigObject.set("nextVoters", (JsonNode)nextVotersArray);
        ArrayNode nextLearnersArray = JSONUtils.MAPPER.createArrayNode();
        config.getNextLearnersList().forEach(arg_0 -> ((ArrayNode)nextLearnersArray).add(arg_0));
        clusterConfigObject.set("nextLearners", (JsonNode)nextLearnersArray);
        return clusterConfigObject;
    }

    private String toHex(ByteString bs) {
        StringBuilder sb = new StringBuilder(bs.size() * 5);
        for (int i = 0; i < bs.size(); ++i) {
            byte b = bs.byteAt(i);
            if (b >= 32 && b <= 126) {
                sb.append((char)b);
                continue;
            }
            sb.append(String.format("0x%02X", b));
        }
        return sb.toString();
    }
}

