/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.plugin.authprovider;

import com.google.common.base.Strings;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.plugin.authprovider.IAuthProvider;
import org.apache.bifromq.plugin.authprovider.type.CheckResult;
import org.apache.bifromq.plugin.authprovider.type.Granted;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthData;
import org.apache.bifromq.plugin.authprovider.type.MQTT3AuthResult;
import org.apache.bifromq.plugin.authprovider.type.MQTTAction;
import org.apache.bifromq.plugin.authprovider.type.Ok;
import org.apache.bifromq.type.ClientInfo;

class DevOnlyAuthProvider
implements IAuthProvider {
    private static final CheckResult GRANTED = CheckResult.newBuilder().setGranted(Granted.getDefaultInstance()).build();

    DevOnlyAuthProvider() {
    }

    public CompletableFuture<MQTT3AuthResult> auth(MQTT3AuthData authData) {
        if (!Strings.isNullOrEmpty((String)authData.getUsername())) {
            String[] username = authData.getUsername().split("/");
            if (username.length == 2) {
                return CompletableFuture.completedFuture(MQTT3AuthResult.newBuilder().setOk(Ok.newBuilder().setTenantId(username[0]).setUserId(username[1]).build()).build());
            }
            return CompletableFuture.completedFuture(MQTT3AuthResult.newBuilder().setOk(Ok.newBuilder().setTenantId("DevOnly").setUserId(authData.getUsername()).build()).build());
        }
        return CompletableFuture.completedFuture(MQTT3AuthResult.newBuilder().setOk(Ok.newBuilder().setTenantId("DevOnly").setUserId("DevUser").build()).build());
    }

    public CompletableFuture<Boolean> check(ClientInfo clientInfo, MQTTAction action) {
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<CheckResult> checkPermission(ClientInfo client, MQTTAction action) {
        return CompletableFuture.completedFuture(GRANTED);
    }
}

